/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.ConfigurationCaller;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Properties;
import javax.swing.JFrame;
import org.apache.derby.drda.NetworkServerControl;

public class DCMDBServer
extends Thread
implements ConfigurationCaller {
    private Connection connection = null;
    private final String protocol = "jdbc:derby:";
    private String database = "DCMMetaDB";
    private final String attributes = ";create=true";
    private final String user = "dbadmin";
    private final String toegang = "IsNwtNp4DB";
    private final String url = "jdbc:derby:" + this.database + ";create=true";
    private boolean keepRunning = true;
    private Properties props;
    private NetworkServerControl networkServerControl;
    private DCMDBClient javaDBClient;
    private DCMDBServer javaDBServerReference;
    private Configuration configuration;
    private String logDateString;
    private Calendar currentTimeCalendar;
    private static final String THISPRODUCT = "DCMDBServer";
    private FileWriter logFileWriter;
    private String logFileString;
    private String logBuffer = "";
    private boolean debug = false;
    private boolean daemon = false;

    public DCMDBServer(DCMDBClient javaDBClientParam, String databaseParam, boolean testParam, boolean daemonParam, boolean debugParam) throws Exception {
        this.daemon = daemonParam;
        this.debug = debugParam;
        if (!this.debug) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FilteredStream filteredStream = new FilteredStream(byteArrayOutputStream);
            PrintStream aPrintStream = new PrintStream(filteredStream);
            System.setOut(aPrintStream);
            System.setErr(aPrintStream);
        } else {
            System.out.println("DCMDBServer debugging enabled...");
        }
        this.javaDBClient = javaDBClientParam;
        this.javaDBServerReference = this;
        this.networkServerControl = new NetworkServerControl();
        this.database = databaseParam;
        this.configuration = new Configuration(this.javaDBServerReference);
        this.currentTimeCalendar = Calendar.getInstance();
        this.logDateString = "" + String.format("%04d", this.currentTimeCalendar.get(1)) + String.format("%02d", this.currentTimeCalendar.get(2) + 1) + String.format("%02d", this.currentTimeCalendar.get(5)) + "_" + String.format("%02d", this.currentTimeCalendar.get(11)) + String.format("%02d", this.currentTimeCalendar.get(12)) + String.format("%02d", this.currentTimeCalendar.get(13));
        this.logFileString = this.configuration.getLogDir() + this.logDateString + "_" + THISPRODUCT + ".log";
        if (testParam) {
            System.setProperty("derby.system.durability", "test");
            System.setProperty("derby.storage.rowLocking", "true");
        }
        this.props = new Properties();
        this.props.setProperty("derby.system.home", this.configuration.getDatabasesDir());
        this.props.setProperty("databaseName", this.database);
        this.props.setProperty("user", "dbadmin");
        this.props.setProperty("password", "IsNwtNp4DB");
        this.javaDBClient.log("JavaDB Database Server Starting...", true, true, true);
        Thread javaDBServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DCMDBServer.this.networkServerControl.start(null);
                }
                catch (Exception ex) {
                    DCMDBServer.this.javaDBClient.log("Error: Exception: JavaDBServer() networkServerControl.start(null): " + ex.getMessage(), true, true, true);
                }
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                try {
                    DCMDBServer.this.javaDBServerReference.waitForStart();
                }
                catch (Exception ex) {
                    DCMDBServer.this.javaDBClient.log("Error: Exception: JavaDBServer() javaDBServerReference.waitForStart(): " + ex.getMessage(), true, true, true);
                }
                try {
                    DCMDBServer.this.connection = DriverManager.getConnection(DCMDBServer.this.url, DCMDBServer.this.props);
                }
                catch (SQLException ex) {
                    DCMDBServer.this.javaDBClient.log("Error: SQLException: JavaDBServer() DriverManager.getConnection(url, props): " + ex.getMessage(), true, true, true);
                }
                try {
                    DCMDBServer.this.test(DCMDBServer.this.connection);
                }
                catch (Exception ex) {
                    DCMDBServer.this.javaDBClient.log("Error: Exception: JavaDBServer() test(connection): " + ex.getMessage(), true, true, true);
                }
                DCMDBServer.this.initRuntime();
            }
        });
        javaDBServerThread.setName("javaDBServerThread");
        javaDBServerThread.setDaemon(false);
        javaDBServerThread.setPriority(9);
        javaDBServerThread.start();
    }

    public DCMDBServer(boolean daemonParam, boolean debugParam) {
        this.daemon = daemonParam;
        this.debug = debugParam;
        if (!this.debug) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FilteredStream filteredStream = new FilteredStream(byteArrayOutputStream);
            PrintStream aPrintStream = new PrintStream(filteredStream);
            System.setOut(aPrintStream);
            System.setErr(aPrintStream);
        } else {
            System.out.println("DCMDBServer debugging enabled...");
        }
        if (!this.daemon) {
            JFrame jframe = new JFrame(THISPRODUCT);
            jframe.setState(1);
            jframe.setDefaultCloseOperation(3);
            jframe.setVisible(true);
        }
        this.configuration = new Configuration();
        this.currentTimeCalendar = Calendar.getInstance();
        this.logDateString = "" + String.format("%04d", this.currentTimeCalendar.get(1)) + String.format("%02d", this.currentTimeCalendar.get(2) + 1) + String.format("%02d", this.currentTimeCalendar.get(5)) + "_" + String.format("%02d", this.currentTimeCalendar.get(11)) + String.format("%02d", this.currentTimeCalendar.get(12)) + String.format("%02d", this.currentTimeCalendar.get(13));
        this.logFileString = this.configuration.getLogDir() + this.logDateString + "_" + THISPRODUCT + ".log";
        this.javaDBServerReference = this;
        System.setProperty("derby.system.durability", "test");
        System.setProperty("derby.storage.rowLocking", "true");
        this.props = new Properties();
        System.setProperty("derby.system.home", this.configuration.getDatabasesDir());
        System.setProperty("databaseName", this.configuration.getJavaDB());
        this.props.setProperty("derby.system.home", this.configuration.getDatabasesDir());
        this.props.setProperty("databaseName", this.configuration.getJavaDB());
        this.props.setProperty("user", "dbadmin");
        this.props.setProperty("password", "IsNwtNp4DB");
        try {
            this.networkServerControl = new NetworkServerControl();
        }
        catch (Exception ex) {
            this.log("Error: Exception: JavaDBServer() new NetworkServerControl(): " + ex.getMessage());
        }
        this.log("JavaDB Database Server Starting...");
        Thread javaDBServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DCMDBServer.this.networkServerControl.start(null);
                }
                catch (Exception ex) {
                    DCMDBServer.this.log("Error: Exception: JavaDBServer() networkServerControl.start(null): " + ex.getMessage());
                }
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                try {
                    DCMDBServer.this.waitForStart();
                }
                catch (Exception ex) {
                    DCMDBServer.this.log("Error: Exception: JavaDBServer() javaDBServerReference.waitForStart(): " + ex.getMessage());
                }
                try {
                    DCMDBServer.this.connection = DriverManager.getConnection(DCMDBServer.this.url, DCMDBServer.this.props);
                }
                catch (SQLException ex) {
                    DCMDBServer.this.log("Error: SQLException: JavaDBServer() DriverManager.getConnection(url, props): " + ex.getMessage());
                }
                try {
                    DCMDBServer.this.test(DCMDBServer.this.connection);
                }
                catch (Exception ex) {
                    DCMDBServer.this.log("Error: Exception: JavaDBServer() test(connection): " + ex.getMessage());
                }
                DCMDBServer.this.initRuntime2();
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (DCMDBServer.this.keepRunning);
            }
        });
        javaDBServerThread.setName("javaDBServerThread");
        javaDBServerThread.setDaemon(false);
        javaDBServerThread.setPriority(9);
        javaDBServerThread.start();
    }

    private void waitForStart() throws Exception {
        NetworkServerControl server = new NetworkServerControl();
        this.log("JavaDB Database Server Waiting for Completion...");
        boolean dbserverok = false;
        int counter = 0;
        do {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
                this.networkServerControl.ping();
            }
            catch (Exception e) {
                this.log("Try #" + counter + " " + e.toString());
            }
        } while (!dbserverok && ++counter < 20);
        this.log("JavaDB Database Server Running");
    }

    public Connection getEmbeddedConnection() throws Exception {
        return DriverManager.getConnection(this.url, this.props);
    }

    public void test(Connection conn) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.createStatement();
            resultSet = statement.executeQuery("select count(*) from sys.systables");
            if (resultSet.next()) {
                this.log("JavaDB Database Server Ready for Connections");
            }
        }
        catch (SQLException sqle) {
            this.log("JavaDB Database Server Embedded Connection Failed Test: " + sqle.getMessage());
            throw sqle;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void initRuntime() {
        String getProperty = "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(";
        String setProperty = "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(";
        String requireAuth = "'derby.connection.requireAuthentication'";
        String defaultConnMode = "'derby.database.defaultConnectionMode'";
        String fullAccessUsers = "'derby.database.fullAccessUsers'";
        String provider = "'derby.authentication.provider'";
        String propertiesOnly = "'derby.database.propertiesOnly'";
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.javaDBClient.log("1: " + ex.getMessage(), true, true, true);
        }
        String providerString = setProperty + provider + ", 'BUILTIN')";
        try {
            statement.executeUpdate(providerString);
        }
        catch (SQLException ex) {
            this.javaDBClient.log("3: " + ex.getMessage(), true, true, true);
        }
        String userString = setProperty + "'derby.user." + "dbadmin" + "', '" + "IsNwtNp4DB" + "')";
        try {
            statement.executeUpdate(userString);
        }
        catch (SQLException ex) {
            this.javaDBClient.log("4: " + ex.getMessage(), true, true, true);
        }
        String fullAccessUsersString = setProperty + fullAccessUsers + ", '" + "dbadmin" + "')";
        try {
            statement.executeUpdate(fullAccessUsersString);
        }
        catch (SQLException ex) {
            this.javaDBClient.log("6: " + ex.getMessage(), true, true, true);
        }
        String defaultConnectionModeString = setProperty + defaultConnMode + ", 'noAccess')";
        try {
            statement.executeUpdate(defaultConnectionModeString);
        }
        catch (SQLException ex) {
            this.javaDBClient.log("5: " + ex.getMessage(), true, true, true);
        }
        String requirteAuthString = setProperty + requireAuth + ", 'true')";
        try {
            statement.executeUpdate(requirteAuthString);
        }
        catch (SQLException ex) {
            this.javaDBClient.log("2: " + ex.getMessage(), true, true, true);
        }
        String propertiesOnlyString = setProperty + propertiesOnly + ", 'true')";
        try {
            statement.executeUpdate(propertiesOnlyString);
        }
        catch (SQLException ex) {
            this.javaDBClient.log("7: " + ex.getMessage(), true, true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.javaDBClient.log("8: " + ex.getMessage(), true, true, true);
        }
    }

    public void initRuntime2() {
        String getProperty = "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(";
        String setProperty = "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(";
        String requireAuth = "'derby.connection.requireAuthentication'";
        String defaultConnMode = "'derby.database.defaultConnectionMode'";
        String fullAccessUsers = "'derby.database.fullAccessUsers'";
        String provider = "'derby.authentication.provider'";
        String propertiesOnly = "'derby.database.propertiesOnly'";
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            this.log("1: " + ex.getMessage());
        }
        String providerString = setProperty + provider + ", 'BUILTIN')";
        try {
            statement.executeUpdate(providerString);
        }
        catch (SQLException ex) {
            this.log("3: " + ex.getMessage());
        }
        String userString = setProperty + "'derby.user." + "dbadmin" + "', '" + "IsNwtNp4DB" + "')";
        try {
            statement.executeUpdate(userString);
        }
        catch (SQLException ex) {
            this.log("4: " + ex.getMessage());
        }
        String fullAccessUsersString = setProperty + fullAccessUsers + ", '" + "dbadmin" + "')";
        try {
            statement.executeUpdate(fullAccessUsersString);
        }
        catch (SQLException ex) {
            this.log("6: " + ex.getMessage());
        }
        String defaultConnectionModeString = setProperty + defaultConnMode + ", 'noAccess')";
        try {
            statement.executeUpdate(defaultConnectionModeString);
        }
        catch (SQLException ex) {
            this.log("5: " + ex.getMessage());
        }
        String requirteAuthString = setProperty + requireAuth + ", 'true')";
        try {
            statement.executeUpdate(requirteAuthString);
        }
        catch (SQLException ex) {
            this.log("2: " + ex.getMessage());
        }
        String propertiesOnlyString = setProperty + propertiesOnly + ", 'true')";
        try {
            statement.executeUpdate(propertiesOnlyString);
        }
        catch (SQLException ex) {
            this.log("7: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.log("8: " + ex.getMessage());
        }
    }

    private void waitForExit() throws Exception {
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.keepRunning);
    }

    public void shutdown() {
        this.keepRunning = false;
        try {
            this.networkServerControl.shutdown();
        }
        catch (Exception ex) {
            System.err.println("Error: DBServer.shutdown: " + ex.getMessage());
        }
    }

    private void log(String messageParam) {
        this.logToFile(messageParam);
        System.out.println(messageParam);
    }

    @Override
    public void log(String messageParam, boolean logToStatus, boolean logApplication, boolean logToFile) {
        this.logToFile(messageParam);
        this.javaDBClient.log(messageParam, logToStatus, logApplication, logToFile);
    }

    public synchronized void logToFile(final String displaymessage) {
        Thread logToFileThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Calendar logCalendar = Calendar.getInstance();
                String humanDate = "" + String.format("%04d", logCalendar.get(1)) + "-" + String.format("%02d", logCalendar.get(2) + 1) + "-" + String.format("%02d", logCalendar.get(5)) + " " + String.format("%02d", logCalendar.get(11)) + ":" + String.format("%02d", logCalendar.get(12)) + ":" + String.format("%02d", logCalendar.get(13));
                try {
                    DCMDBServer.this.logFileWriter = new FileWriter(DCMDBServer.this.logFileString, true);
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: new FileWriter(" + DCMDBServer.this.logFileString + ")" + ex.getMessage());
                    DCMDBServer.this.logBuffer = DCMDBServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMDBServer.this.logFileWriter.flush();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.flush()1;");
                    DCMDBServer.this.logBuffer = DCMDBServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMDBServer.this.logFileWriter.write(DCMDBServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n");
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.write()");
                    DCMDBServer.this.logBuffer = DCMDBServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMDBServer.this.logFileWriter.flush();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.flush()2;");
                    DCMDBServer.this.logBuffer = DCMDBServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                DCMDBServer.this.logBuffer = "";
                try {
                    DCMDBServer.this.logFileWriter.close();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.close();");
                    return;
                }
            }
        });
        logToFileThread.setName("logToFileThread");
        logToFileThread.setDaemon(false);
        logToFileThread.start();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean daemon = false;
                boolean debug = false;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("--daemon")) {
                        daemon = true;
                        continue;
                    }
                    if (args[i].equals("--debug")) {
                        debug = true;
                        continue;
                    }
                    if (!args[i].equals("--help")) continue;
                    DCMDBServer.usage();
                    System.exit(1);
                }
                try {
                    new DCMDBServer(daemon, debug);
                }
                catch (Exception ex) {
                    System.out.println("Error: main(): ");
                    ex.printStackTrace();
                }
            }
        });
    }

    @Override
    public void run() {
    }

    private static void usage() {
        System.out.println("\n");
        System.out.println("Usage:   java -cp DCManager.jar DCMDBServer [--daemon] [--debug]\n");
        System.out.println(DCMLicense.getCopyright());
    }

    public class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

