/*
 * Decompiled with CFR 0.152.
 */
import data.Host;
import data.Resource;
import data.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.util.Calendar;

public class DCMDataConverterDarwin {
    Host host;
    Resource resource;
    DCMCommandLibraryDarwin osCommands;
    int resCnt = 0;
    int pollServerInstance;
    int retentionTime;

    public DCMDataConverterDarwin(Host hostParam, int retentionTimeParam) throws UnknownHostException {
        this.host = hostParam;
        this.osCommands = new DCMCommandLibraryDarwin(this.host);
        this.retentionTime = retentionTimeParam;
    }

    public Server convertInventoryDataToServer(String dataParam) {
        Server outputServer = new Server();
        String dataHeaders = "";
        String line = "";
        String output = "";
        long id = 0L;
        long hostId = 0L;
        String category = "";
        String resourceType = "";
        String valueType = "";
        String counterType = "";
        String resourceName = "";
        boolean enabled = true;
        String pollCommand = "";
        Double lastValue = 0.0;
        Double warningLimit = 0.0;
        Double criticalLimit = 0.0;
        int alertPolls = 30;
        Calendar created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        String rrdFile = "";
        outputServer.setHost(this.host);
        this.host.setCommand(this.osCommands.getPSCPUHostCommand());
        this.host.addCommand(this.osCommands.getPSMEMHostCommand());
        this.host.addCommand(this.osCommands.getCPUHostCommand());
        this.host.addCommand(this.osCommands.getDiskIOHostCommand());
        id = 0L;
        hostId = 0L;
        category = "WORKLOAD";
        resourceType = "MINUTELOAD";
        valueType = "Factor";
        counterType = "GAUGE";
        resourceName = "MINLOAD";
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        pollCommand = this.osCommands.getWorkload();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        dataHeaders = "CPU: ";
        BufferedReader reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
        line = "";
        output = "";
        try {
            while ((line = reader.readLine()) != null) {
                id = 0L;
                hostId = 0L;
                category = "CPU";
                resourceType = "";
                valueType = "Percentage";
                counterType = "GAUGE";
                resourceName = line.replace(dataHeaders, "");
                enabled = true;
                pollCommand = "";
                lastValue = 0.0;
                warningLimit = 0.0;
                criticalLimit = 0.0;
                alertPolls = 30;
                created = Calendar.getInstance();
                created.setTimeInMillis(0L);
                rrdFile = "";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "USR";
                pollCommand = this.osCommands.getCPUUSERCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "SYS";
                pollCommand = this.osCommands.getCPUSYSCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "IDL";
                pollCommand = this.osCommands.getCPUIDLECommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dataHeaders = "DiskIO: ";
        reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
        line = "";
        output = "";
        try {
            while ((line = reader.readLine()) != null) {
                id = 0L;
                hostId = 0L;
                category = "DiskIO";
                resourceType = "";
                valueType = "";
                counterType = "GAUGE";
                resourceName = line.replace(dataHeaders, "");
                enabled = true;
                pollCommand = "";
                lastValue = 0.0;
                warningLimit = 0.0;
                criticalLimit = 0.0;
                alertPolls = 30;
                created = Calendar.getInstance();
                created.setTimeInMillis(0L);
                rrdFile = "";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "KBPerTransfer";
                valueType = "KB";
                pollCommand = this.osCommands.getDiskIOKBPerTransferCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "TransfersPerSec";
                valueType = "Transfers";
                pollCommand = this.osCommands.getDiskIOTransfersPerSecondCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "MBPerSecond";
                valueType = "MB";
                pollCommand = this.osCommands.getDiskIOMBPerSecondCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        id = 0L;
        hostId = 0L;
        category = "Memory";
        resourceType = "";
        valueType = "MB";
        counterType = "GAUGE";
        resourceName = line;
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "RAMTOT";
        resourceName = "RAMTOT";
        pollCommand = this.osCommands.getRAMTOTCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "RAMUSED";
        resourceName = "RAMUSED";
        pollCommand = this.osCommands.getRAMUSEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "RAMFREE";
        resourceName = "RAMFREE";
        pollCommand = this.osCommands.getRAMFREECommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SWAPTOT";
        resourceName = "SWAPTOT";
        pollCommand = this.osCommands.getSWAPTOTCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SWAPUSED";
        resourceName = "SWAPUSED";
        pollCommand = this.osCommands.getSWAPUSEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SWAPFREE";
        resourceName = "SWAPFREE";
        pollCommand = this.osCommands.getSWAPFREECommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "TOTMEM";
        resourceName = "TOTMEM";
        pollCommand = this.osCommands.getTOTMEMCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "TOTUSED";
        resourceName = "TOTUSED";
        pollCommand = this.osCommands.getTOTUSEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "TOTFREE";
        resourceName = "TOTFREE";
        pollCommand = this.osCommands.getTOTFREECommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        dataHeaders = "Storage: ";
        reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
        line = "";
        output = "";
        try {
            while ((line = reader.readLine()) != null) {
                id = 0L;
                hostId = 0L;
                category = "Storage";
                resourceType = "";
                valueType = "MB";
                counterType = "";
                resourceName = line.replace(dataHeaders, "");
                enabled = true;
                pollCommand = "";
                lastValue = 0.0;
                warningLimit = 0.0;
                criticalLimit = 0.0;
                alertPolls = 30;
                created = Calendar.getInstance();
                created.setTimeInMillis(0L);
                rrdFile = "";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "FSTot";
                valueType = "MB";
                counterType = "GAUGE";
                pollCommand = this.osCommands.getFSTOTCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = resourceName.length() <= 20 ? new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime) : new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName.substring(resourceName.length() - 20, resourceName.length()), true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "FSUsed";
                valueType = "MB";
                counterType = "GAUGE";
                pollCommand = this.osCommands.getFSUSEDCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = resourceName.length() <= 20 ? new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime) : new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName.substring(resourceName.length() - 20, resourceName.length()), true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "FSFree";
                valueType = "MB";
                counterType = "GAUGE";
                pollCommand = this.osCommands.getFSFREECommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = resourceName.length() <= 20 ? new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime) : new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName.substring(resourceName.length() - 20, resourceName.length()), true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "FSUsedPerc";
                valueType = "Percentage";
                counterType = "GAUGE";
                pollCommand = this.osCommands.getFSUSEDPercCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = resourceName.length() <= 20 ? new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime) : new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName.substring(resourceName.length() - 20, resourceName.length()), true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dataHeaders = "Network: ";
        reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
        line = "";
        output = "";
        try {
            while ((line = reader.readLine()) != null) {
                id = 0L;
                hostId = 0L;
                category = "Network";
                resourceType = "";
                valueType = "";
                counterType = "COUNTER";
                resourceName = line.replace(dataHeaders, "");
                enabled = true;
                pollCommand = "";
                lastValue = 0.0;
                warningLimit = 0.0;
                criticalLimit = 0.0;
                alertPolls = 30;
                created = Calendar.getInstance();
                created.setTimeInMillis(0L);
                rrdFile = "";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "TXPackets";
                valueType = "Packets";
                pollCommand = this.osCommands.getIFTXPacketsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "RXPackets";
                valueType = "Packets";
                pollCommand = this.osCommands.getIFRXPacketsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "TXErr";
                valueType = "Errors";
                pollCommand = this.osCommands.getIFTXErrCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "RXErr";
                valueType = "Errors";
                pollCommand = this.osCommands.getIFRXErrCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "Collisions";
                valueType = "Collisions";
                pollCommand = this.osCommands.getIFCollisionCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        id = 0L;
        hostId = 0L;
        category = "TCPSTATS";
        resourceType = "";
        valueType = "NumOf";
        counterType = "GAUGE";
        resourceName = line;
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "ESTABLISHED";
        resourceName = "ESTABLISHED";
        pollCommand = this.osCommands.getTCPSTATESTABLISHEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SYN_SENT";
        resourceName = "SYN_SENT";
        pollCommand = this.osCommands.getTCPSTATSYN_SENTCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SYN_RECV";
        resourceName = "SYN_RECV";
        pollCommand = this.osCommands.getTCPSTATSYN_RECVCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "FIN_WAIT1";
        resourceName = "FIN_WAIT1";
        pollCommand = this.osCommands.getTCPSTATFIN_WAIT1Command(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "FIN_WAIT2";
        resourceName = "FIN_WAIT2";
        pollCommand = this.osCommands.getTCPSTATFIN_WAIT2Command(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "TIME_WAIT";
        resourceName = "TIME_WAIT";
        pollCommand = this.osCommands.getTCPSTATTIME_WAITCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "CLOSED";
        resourceName = "CLOSED";
        pollCommand = this.osCommands.getTCPSTATCLOSEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "CLOSE_WAIT";
        resourceName = "CLOSE_WAIT";
        pollCommand = this.osCommands.getTCPSTATCLOSE_WAITCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "LAST_ACK";
        resourceName = "LAST_ACK";
        pollCommand = this.osCommands.getTCPSTATLAST_ACKCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "LISTEN";
        resourceName = "LISTEN";
        pollCommand = this.osCommands.getTCPSTATLISTENCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "CLOSING";
        resourceName = "CLOSING";
        pollCommand = this.osCommands.getTCPSTATCLOSINGCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "UNKNOWN";
        resourceName = "UNKNOWN";
        pollCommand = this.osCommands.getTCPSTATUNKNOWNCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = 0L;
        hostId = 0L;
        category = "GENERIC";
        resourceType = "";
        valueType = "";
        counterType = "GAUGE";
        resourceName = line;
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "NUMOFUSERS";
        resourceName = "NUMOFUSERS";
        valueType = "Users";
        pollCommand = this.osCommands.getNUMOFUSERSCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "NUMOFPROCS";
        resourceName = "NUMOFPROCS";
        valueType = "Processes";
        pollCommand = this.osCommands.getNUMOFPROCSCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = 0L;
        hostId = 0L;
        category = "PROCESS";
        resourceType = "";
        valueType = "";
        counterType = "GAUGE";
        resourceName = line;
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPUPID";
        resourceName = "PS1CPUPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS1CPUPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPU";
        resourceName = "PS1CPU";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS1CPUCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPUPID";
        resourceName = "PS2CPUPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS2CPUPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPU";
        resourceName = "PS2CPU";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS2CPUCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPUPID";
        resourceName = "PS3CPUPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS3CPUPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPU";
        resourceName = "PS3CPU";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS3CPUCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEMPID";
        resourceName = "PS1MEMPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS1MEMPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEM";
        resourceName = "PS1MEM";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS1MEMCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEMPID";
        resourceName = "PS2MEMPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS2MEMPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEM";
        resourceName = "PS2MEM";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS2MEMCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEMPID";
        resourceName = "PS3MEMPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS3MEMPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEM";
        resourceName = "PS3MEM";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS3MEMCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        return outputServer;
    }
}

