/*
 * Decompiled with CFR 0.152.
 */
import data.Host;
import data.Resource;
import data.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.util.Calendar;

public class DCMDataConverterSunOS {
    Host host;
    Resource resource;
    DCMCommandLibrarySunOS osCommands;
    int resCnt = 0;
    int pollServerInstance;
    int retentionTime;

    public DCMDataConverterSunOS(Host hostParam, int retentionTimeParam) throws UnknownHostException {
        this.host = hostParam;
        this.osCommands = new DCMCommandLibrarySunOS(this.host);
        this.retentionTime = retentionTimeParam;
    }

    public Server convertInventoryDataToServer(String dataParam) {
        Server outputServer = new Server();
        String dataHeaders = "";
        String line = "";
        String output = "";
        long id = 0L;
        long hostId = 0L;
        String category = "";
        String resourceType = "";
        String valueType = "";
        String counterType = "";
        String resourceName = "";
        boolean enabled = true;
        String pollCommand = "";
        Double lastValue = 0.0;
        Double warningLimit = 0.0;
        Double criticalLimit = 0.0;
        int alertPolls = 30;
        Calendar created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        String rrdFile = "";
        outputServer.setHost(this.host);
        this.host.setCommand(this.osCommands.getPSCPUHostCommand());
        this.host.addCommand(this.osCommands.getPSMEMHostCommand());
        this.host.addCommand(this.osCommands.getCPUHostCommand());
        this.host.addCommand(this.osCommands.getALLCPUHostCommand());
        this.host.addCommand(this.osCommands.getDiskIOHostCommand());
        id = 0L;
        hostId = 0L;
        category = "WORKLOAD";
        resourceType = "MINUTELOAD";
        valueType = "Factor";
        counterType = "GAUGE";
        resourceName = "MINLOAD";
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        pollCommand = this.osCommands.getWorkload();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        dataHeaders = "CPU: ";
        BufferedReader reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
        line = "";
        output = "";
        try {
            while ((line = reader.readLine()) != null) {
                id = 0L;
                hostId = 0L;
                category = "CPUEXT";
                resourceType = "";
                valueType = "Percentage";
                counterType = "GAUGE";
                resourceName = line.replace(dataHeaders, "");
                enabled = true;
                pollCommand = "";
                lastValue = 0.0;
                warningLimit = 0.0;
                criticalLimit = 0.0;
                alertPolls = 30;
                created = Calendar.getInstance();
                created.setTimeInMillis(0L);
                rrdFile = "";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "MinorFaults";
                valueType = "Faults";
                pollCommand = this.osCommands.getCPUMinorFaultsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "MajorFaults";
                valueType = "Faults";
                pollCommand = this.osCommands.getCPUMajorFaultsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "CrossCalls";
                valueType = "CrossCalls";
                pollCommand = this.osCommands.getCPUCrossCallsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "Interrupts";
                valueType = "Interrupts";
                pollCommand = this.osCommands.getCPUInterruptsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "ThreadInterrupts";
                valueType = "Interrupts";
                pollCommand = this.osCommands.getCPUThreadInterruptsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "ContextSwitches";
                valueType = "ContextSwitches";
                pollCommand = this.osCommands.getCPUContextSwitchesCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "ForcedContextSwitches";
                valueType = "ContextSwitches";
                pollCommand = this.osCommands.getCPUInvoluntaryContextSwitchesCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "ThreadMigrations";
                valueType = "Migrations";
                pollCommand = this.osCommands.getCPUThreadMigrationsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "SpinsOnMutexes";
                valueType = "Spins";
                pollCommand = this.osCommands.getCPUSpinsOnMutexesCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "SpinsOnReadWrite";
                valueType = "Spins";
                pollCommand = this.osCommands.getCPUSpinsOnReadersWritersCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "SystemCalls";
                valueType = "SystemCalls";
                pollCommand = this.osCommands.getCPUSystemCallsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                category = "CPU";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "USR";
                valueType = "Percentage";
                pollCommand = this.osCommands.getCPUUserCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "SYS";
                valueType = "Percentage";
                pollCommand = this.osCommands.getCPUSystemCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "WIO";
                valueType = "Percentage";
                pollCommand = this.osCommands.getCPUWIOCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "IDL";
                valueType = "Percentage";
                pollCommand = this.osCommands.getCPUIDLECommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dataHeaders = "DiskIO: ";
        reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
        line = "";
        output = "";
        try {
            while ((line = reader.readLine()) != null) {
                id = 0L;
                hostId = 0L;
                category = "DiskIO";
                resourceType = "";
                valueType = "";
                counterType = "GAUGE";
                resourceName = line.replace(dataHeaders, "");
                enabled = true;
                pollCommand = "";
                lastValue = 0.0;
                warningLimit = 0.0;
                criticalLimit = 0.0;
                alertPolls = 30;
                created = Calendar.getInstance();
                created.setTimeInMillis(0L);
                rrdFile = "";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "ReadsPerSecond";
                valueType = "Reads";
                pollCommand = this.osCommands.getDiskIOReadsPerSecondCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "WritesPerSecond";
                valueType = "Writes";
                pollCommand = this.osCommands.getDiskIOWritesPerSecondCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "KBReadsPerSecond";
                valueType = "KB";
                pollCommand = this.osCommands.getDiskIOKBReadPerSecondCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "KBWritesPerSecond";
                valueType = "KB";
                pollCommand = this.osCommands.getDiskIOKBWritePerSecondCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "TransactionsWaiting";
                valueType = "Transactions";
                pollCommand = this.osCommands.getDiskIOTransactionsWaitingCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "TransactionsServed";
                valueType = "Transactions";
                pollCommand = this.osCommands.getDiskIOTransactionsServedCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "AvgTransactRespTime";
                valueType = "mSec";
                pollCommand = this.osCommands.getDiskIOAverageTranscationResponseTimeCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "TransactWaitPerc";
                valueType = "Percentage";
                pollCommand = this.osCommands.getDiskIOTransactionsWaitingPercentageCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "DiskBusyPercentage";
                valueType = "Percentage";
                pollCommand = this.osCommands.getDiskIODiskBusyPercentageCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        id = 0L;
        hostId = 0L;
        category = "Memory";
        resourceType = "";
        valueType = "MB";
        counterType = "GAUGE";
        resourceName = line;
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "RAMTOT";
        resourceName = "RAMTOT";
        pollCommand = this.osCommands.getRAMTOTCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "RAMUSED";
        resourceName = "RAMUSED";
        pollCommand = this.osCommands.getRAMUSEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "RAMFREE";
        resourceName = "RAMFREE";
        pollCommand = this.osCommands.getRAMFREECommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SWAPTOT";
        resourceName = "SWAPTOT";
        pollCommand = this.osCommands.getSWAPTOTCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SWAPUSED";
        resourceName = "SWAPUSED";
        pollCommand = this.osCommands.getSWAPUSEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SWAPFREE";
        resourceName = "SWAPFREE";
        pollCommand = this.osCommands.getSWAPFREECommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "TOTMEM";
        resourceName = "TOTMEM";
        pollCommand = this.osCommands.getTOTMEMCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "TOTUSED";
        resourceName = "TOTUSED";
        pollCommand = this.osCommands.getTOTUSEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "TOTFREE";
        resourceName = "TOTFREE";
        pollCommand = this.osCommands.getTOTFREECommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        dataHeaders = "Storage: ";
        reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
        line = "";
        output = "";
        try {
            while ((line = reader.readLine()) != null) {
                id = 0L;
                hostId = 0L;
                category = "Storage";
                resourceType = "";
                valueType = "MB";
                counterType = "";
                resourceName = line.replace(dataHeaders, "");
                enabled = true;
                pollCommand = "";
                lastValue = 0.0;
                warningLimit = 0.0;
                criticalLimit = 0.0;
                alertPolls = 30;
                created = Calendar.getInstance();
                created.setTimeInMillis(0L);
                rrdFile = "";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "FSTot";
                valueType = "MB";
                counterType = "GAUGE";
                pollCommand = this.osCommands.getFSTOTCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = resourceName.length() <= 20 ? new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime) : new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName.substring(resourceName.length() - 20, resourceName.length()), true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "FSUsed";
                valueType = "MB";
                counterType = "GAUGE";
                pollCommand = this.osCommands.getFSUSEDCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = resourceName.length() <= 20 ? new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime) : new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName.substring(resourceName.length() - 20, resourceName.length()), true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "FSFree";
                valueType = "MB";
                counterType = "GAUGE";
                pollCommand = this.osCommands.getFSFREECommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = resourceName.length() <= 20 ? new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime) : new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName.substring(resourceName.length() - 20, resourceName.length()), true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "FSUsedPerc";
                valueType = "Percentage";
                counterType = "GAUGE";
                pollCommand = this.osCommands.getFSUSEDPercCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = resourceName.length() <= 20 ? new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime) : new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName.substring(resourceName.length() - 20, resourceName.length()), true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dataHeaders = "Network: ";
        reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
        line = "";
        output = "";
        try {
            while ((line = reader.readLine()) != null) {
                id = 0L;
                hostId = 0L;
                category = "Network";
                resourceType = "";
                valueType = "";
                counterType = "COUNTER";
                resourceName = line.replace(dataHeaders, "");
                enabled = true;
                pollCommand = "";
                lastValue = 0.0;
                warningLimit = 0.0;
                criticalLimit = 0.0;
                alertPolls = 30;
                created = Calendar.getInstance();
                created.setTimeInMillis(0L);
                rrdFile = "";
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "IFINPackets";
                valueType = "Packets";
                pollCommand = this.osCommands.getIFTINPacketsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "IFINErr";
                valueType = "Errors";
                pollCommand = this.osCommands.getIFINERRCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "IFOUTPackets";
                valueType = "Packets";
                pollCommand = this.osCommands.getIFOUTPacketsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "IFOUTErrors";
                valueType = "Errors";
                pollCommand = this.osCommands.getIFOUTERRCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "IFCollisions";
                valueType = "Collisions";
                pollCommand = this.osCommands.getIFCollisionsCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
                id = this.resCnt;
                ++this.resCnt;
                resourceType = "IFQueue";
                valueType = "Packets";
                pollCommand = this.osCommands.getIFQueueCommand(resourceName);
                rrdFile = category + "_" + resourceType + "_" + resourceName.replace("/", "-") + ".rrd";
                this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
                outputServer.addResource(this.resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        id = 0L;
        hostId = 0L;
        category = "TCPSTATS";
        resourceType = "";
        valueType = "NumOf";
        counterType = "GAUGE";
        resourceName = line;
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "BOUND";
        resourceName = "BOUND";
        pollCommand = this.osCommands.getTCPSTATBOUNDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "CLOSED";
        resourceName = "CLOSED";
        pollCommand = this.osCommands.getTCPSTATCLOSEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "CLOSING";
        resourceName = "CLOSING";
        pollCommand = this.osCommands.getTCPSTATCLOSINGCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "CLOSE_WAIT";
        resourceName = "CLOSE_WAIT";
        pollCommand = this.osCommands.getTCPSTATCLOSE_WAITCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "ESTABLISHED";
        resourceName = "ESTABLISHED";
        pollCommand = this.osCommands.getTCPSTATESTABLISHEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "FIN_WAIT1";
        resourceName = "FIN_WAIT1";
        pollCommand = this.osCommands.getTCPSTATFIN_WAIT_1Command(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "FIN_WAIT2";
        resourceName = "FIN_WAIT2";
        pollCommand = this.osCommands.getTCPSTATFIN_WAIT_2Command(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "IDLE";
        resourceName = "IDLE";
        pollCommand = this.osCommands.getTCPSTATIDLECommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "LAST_ACK";
        resourceName = "LAST_ACK";
        pollCommand = this.osCommands.getTCPSTATLAST_ACKCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "LISTEN";
        resourceName = "LISTEN";
        pollCommand = this.osCommands.getTCPSTATLISTENCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SYN_RECV";
        resourceName = "SYN_RECV";
        pollCommand = this.osCommands.getTCPSTATSYN_RECEIVEDCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "SYN_SENT";
        resourceName = "SYN_SENT";
        pollCommand = this.osCommands.getTCPSTATSYN_SENTCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "TIME_WAIT";
        resourceName = "TIME_WAIT";
        pollCommand = this.osCommands.getTCPSTATTIME_WAITCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = 0L;
        hostId = 0L;
        category = "GENERIC";
        resourceType = "";
        valueType = "";
        counterType = "GAUGE";
        resourceName = line;
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "NUMOFUSERS";
        resourceName = "NUMOFUSERS";
        valueType = "Users";
        pollCommand = this.osCommands.getNUMOFUSERSCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "NUMOFPROCS";
        resourceName = "NUMOFPROCS";
        valueType = "Processes";
        pollCommand = this.osCommands.getNUMOFPROCSCommand(this.host);
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = 0L;
        hostId = 0L;
        category = "PROCESS";
        resourceType = "";
        valueType = "";
        counterType = "GAUGE";
        resourceName = line;
        enabled = true;
        pollCommand = "";
        lastValue = 0.0;
        warningLimit = 0.0;
        criticalLimit = 0.0;
        alertPolls = 30;
        created = Calendar.getInstance();
        created.setTimeInMillis(0L);
        rrdFile = "";
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPUPID";
        resourceName = "PS1CPUPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS1CPUPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPU";
        resourceName = "PS1CPU";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS1CPUCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPUPID";
        resourceName = "PS2CPUPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS2CPUPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPU";
        resourceName = "PS2CPU";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS2CPUCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPUPID";
        resourceName = "PS3CPUPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS3CPUPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSCPU";
        resourceName = "PS3CPU";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS3CPUCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEMPID";
        resourceName = "PS1MEMPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS1MEMPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEM";
        resourceName = "PS1MEM";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS1MEMCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEMPID";
        resourceName = "PS2MEMPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS2MEMPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEM";
        resourceName = "PS2MEM";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS2MEMCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEMPID";
        resourceName = "PS3MEMPID";
        valueType = "PID";
        pollCommand = this.osCommands.getPS3MEMPIDCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        id = this.resCnt;
        ++this.resCnt;
        resourceType = "PSMEM";
        resourceName = "PS3MEM";
        valueType = "Percentage";
        pollCommand = this.osCommands.getPS3MEMCommand();
        rrdFile = category + "_" + resourceType + "_" + resourceName + ".rrd";
        this.resource = new Resource(id, hostId, category, resourceType, valueType, counterType, resourceName, true, pollCommand, lastValue, warningLimit, criticalLimit, alertPolls, created, rrdFile, this.retentionTime);
        outputServer.addResource(this.resource);
        return outputServer;
    }
}

