/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.jdesktop.layout.GroupLayout;

public class DCMFileBrowserClient
extends JFrame {
    private String platform;
    private String fileSeparator;
    private File file;
    private File directory;
    private DCMAddServerFormClient addServerFormClient2;
    private DCMExtensionFilter extensionFilter;
    private JFileChooser fileChooser;

    public DCMFileBrowserClient() {
        this.initComponents();
        this.platform = "";
        this.fileSeparator = "";
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        int posX = Math.round(screenDim.width / 2 - winWidth / 2);
        int posY = Math.round(screenDim.height / 2 - winHeight / 2);
        this.setLocation(posX, posY);
        this.file = new File("");
        this.directory = new File("");
        this.platform = System.getProperty("os.name").toLowerCase();
        this.fileSeparator = this.platform.indexOf("windows") != -1 ? "\\" : "/";
        try {
            this.directory = new File(new File(".").getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DCMFileBrowserClient(DCMAddServerFormClient addServerFormParam) {
        this();
        this.addServerFormClient2 = addServerFormParam;
        this.fileChooser.setCurrentDirectory(this.directory);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.extensionFilter = new DCMExtensionFilter(".csv", "Comma Separated Format (*.csv)");
        this.fileChooser.addChoosableFileFilter(this.extensionFilter);
        this.fileChooser.setFileFilter(this.extensionFilter);
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser();
        this.setAlwaysOnTop(true);
        this.fileChooser.setDialogTitle("Select Host ImportFile (*.csv)");
        this.fileChooser.setFont(new Font("STHeiti", 0, 10));
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMFileBrowserClient.this.fileChooserActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.fileChooser, -1, 570, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.fileChooser, -2, -1, -2));
        this.pack();
    }

    private void fileChooserActionPerformed(ActionEvent evt) {
        this.addServerFormClient2.setImportFile(this.fileChooser.getCurrentDirectory() + this.fileSeparator + this.fileChooser.getName(this.fileChooser.getSelectedFile()));
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DCMFileBrowser().setVisible(true);
            }
        });
    }
}

