/*
 * Decompiled with CFR 0.152.
 */
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import data.Host;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DCMFileTransfer {
    private Host host;
    private String file;
    private Session session;
    private Channel channel;
    private DCMFileTranferCaller DCMFileTransferCaller;

    public DCMFileTransfer(DCMFileTranferCaller dmcFileTransferCallerParam, Host hostParam, String scriptfileParam) throws CloneNotSupportedException {
        this.DCMFileTransferCaller = dmcFileTransferCallerParam;
        this.host = new Host();
        this.host = (Host)hostParam.clone();
        this.file = new String();
        this.file = scriptfileParam;
        FileInputStream fileInputStream = null;
        try {
            int fileLength;
            JSch jsch = new JSch();
            this.session = jsch.getSession(this.host.getUsername(), this.host.getHostname(), hostParam.getPort());
            MyUserInfo userInfo = new MyUserInfo();
            this.session.setUserInfo((UserInfo)userInfo);
            this.session.connect();
            if (this.session.isConnected()) {
                this.DCMFileTransferCaller.log("Success: DCMFileTransfer: Session Connected Successfully.", true, true, true);
            } else {
                this.DCMFileTransferCaller.log("Error:  DCMFileTransfer: Session NOT Connected!", true, true, true);
            }
            String command = "scp -p -t " + this.file;
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
            OutputStream outputStream = this.channel.getOutputStream();
            InputStream inputStream = this.channel.getInputStream();
            this.channel.connect();
            if (this.channel.isConnected()) {
                this.DCMFileTransferCaller.log("Success: DCMFileTransfer: Channel(exec) " + command + " Connected Successfully.", true, true, true);
            } else {
                this.DCMFileTransferCaller.log("Error:  DCMFileTransfer: Channel NOT Connected!", true, true, true);
            }
            if (DCMFileTransfer.checkAck(inputStream) != 0) {
                this.DCMFileTransferCaller.log("Error:   DCMFileTransfer: Channel InputStream1 after channel.connect() Failed", true, true, true);
            } else {
                this.DCMFileTransferCaller.log("Success: DCMFileTransfer: Channel InputStream1 after channel.connect() Successful", true, true, true);
            }
            long filesize = new File(this.file).length();
            command = "C0644 " + filesize + " ";
            command = this.file.lastIndexOf(47) > 0 ? command + this.file.substring(this.file.lastIndexOf(47) + 1) : command + this.file;
            command = command + "\n";
            this.DCMFileTransferCaller.log("Action:  DCMFileTransfer: Writing Channel OutputStream", true, true, true);
            outputStream.write(command.getBytes());
            outputStream.flush();
            if (DCMFileTransfer.checkAck(inputStream) != 0) {
                this.DCMFileTransferCaller.log("Error:   DCMFileTransfer: Channel InputStream2 after outputStream.write(..) Failed", true, true, true);
            } else {
                this.DCMFileTransferCaller.log("Success: DCMFileTransfer: Channel InputStream2 after outputStream.write(..) Successful", true, true, true);
            }
            fileInputStream = new FileInputStream(this.file);
            byte[] buffer = new byte[1024];
            while ((fileLength = fileInputStream.read(buffer, 0, buffer.length)) > 0) {
                outputStream.write(buffer, 0, fileLength);
            }
            fileInputStream.close();
            fileInputStream = null;
            buffer[0] = 0;
            outputStream.write(buffer, 0, 1);
            outputStream.flush();
            if (DCMFileTransfer.checkAck(inputStream) != 0) {
                this.DCMFileTransferCaller.log("Error:   DCMFileTransfer: InputStream after outputStream.write(..) Failed", true, true, true);
            } else {
                this.DCMFileTransferCaller.log("Success: DCMFileTransfer: InputStream after outputStream.write(..) Successful", true, true, true);
            }
            outputStream.close();
            this.channel.disconnect();
            if (!this.channel.isConnected()) {
                this.DCMFileTransferCaller.log("Success: DCMFileTransfer: Channel Disconnected Successfully.", true, true, true);
            } else {
                this.DCMFileTransferCaller.log("Error:  DCMFileTransfer: Channel NOT Disconnected!", true, true, true);
            }
            this.session.disconnect();
            if (!this.channel.isConnected()) {
                this.DCMFileTransferCaller.log("Success: DCMFileTransfer: Session Disconnected Successfully.", true, true, true);
            } else {
                this.DCMFileTransferCaller.log("Error:  DCMFileTransfer: Session NOT Disconnected!", true, true, true);
            }
        }
        catch (Exception e) {
            this.DCMFileTransferCaller.log("Error3:   DCMFileTransfer: Exception: Codeblock Failure: " + e.getMessage(), true, true, true);
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception ee) {
                this.DCMFileTransferCaller.log("Error3:   DCMFileTransfer: Exception: fileInputStream.close() " + e.getMessage(), true, true, true);
            }
        }
    }

    public static void main(String[] arg) {
    }

    static int checkAck(InputStream inputStream) throws IOException {
        int b = inputStream.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int character;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                character = inputStream.read();
                stringBuffer.append((char)character);
            } while (character != 10);
            if (b == 1) {
                System.out.print(stringBuffer.toString());
            }
            if (b == 2) {
                System.out.print(stringBuffer.toString());
            }
        }
        return b;
    }

    private void log(String message, boolean logToStatus, boolean logToApplication, boolean logToFile) {
        if (logToStatus) {
            System.out.println(message);
        }
    }

    public class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd;
        JTextField passwordField;

        public MyUserInfo() {
            this.passwd = DCMFileTransfer.this.host.getUserPassword();
            this.passwordField = new JPasswordField(20);
        }

        public String getPassword() {
            return DCMFileTransfer.this.host.getUserPassword();
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String string) {
            System.out.println(string);
        }

        public String[] promptKeyboardInteractive(String string, String string1, String string2, String[] strings, boolean[] blns) {
            String[] pw = new String(DCMFileTransfer.this.host.getUserPassword()).split(string);
            return pw;
        }
    }
}

