/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.ConfigurationCaller;
import data.Host;
import data.Resource;
import data.Server;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;

public class DCMInventoryServerServer
implements DCMRemoteCommandCaller,
DCMDBClientCaller,
ConfigurationCaller,
DCMPushPollScriptCaller,
DCMFileTranferCaller {
    private Server server;
    private Host host;
    String user;
    String userPassword;
    String superuserPassword = null;
    String serversListArray;
    DCMRemoteCommand remoteCommand;
    StringBuffer command;
    String tmpOutput;
    String sysinfo;
    String output;
    String data;
    int port = 22;
    int sessionTimeout = 3;
    int userCounter = 0;
    int userPasswordsCounter = 0;
    int superuserPasswordsCounter = 0;
    int serversCounter = 0;
    int commandCounter = 0;
    int lastCommandCounter = 0;
    int serverInstance = 0;
    int serverInstanceCounter = 0;
    String scriptTip = "# Commands or Script to Execute";
    boolean daemon = false;
    boolean debug = false;
    final DCMRemoteCommandCaller remoteCommandCaller;
    DCMInventoryServerServerCaller inventoryServerServerCaller;
    final DCMFileTranferCaller dcmFileTranferCaller;
    private DCMDBClient javaDBClient;
    private DCMInventoryServerServer inventoryServerServerReference;
    private Configuration configuration;
    private String customPromptFlat = "DCMCommandEnd";
    private final int IDENTIFICATIONSTAGE = 0;
    private final int IVENTORYSTAGE = 1;
    private String[] stageArray;
    private long inventoryInstance;
    private String pollerHeaderKey;
    private InetAddress inetAddress;
    private String dcmServerIP;
    private String dcmInventoryScriptFile;
    private String dcmPollerScriptFile;
    private String dcmPollerDataFile;
    private final String LINUX = "Linux";
    private final String DARWIN = "Darwin";
    private final String SUNOS = "SunOS";
    private final String AIX = "AIX";
    private final String HPUX = "HP-UX";
    private int retentionTime = 1;
    private int retryMax = 2;
    private int retryCounter = 0;

    public DCMInventoryServerServer(DCMInventoryServerServerCaller inventoryServerServerCallerParam, long inventoryInstanceParam, Host hostParam, int retentionTimeParam, int timeoutParam, int retryMaxParam, boolean daemonParam, boolean debugParam) {
        this.retentionTime = retentionTimeParam;
        this.retryCounter = 0;
        this.retryMax = retryMaxParam;
        this.stageArray = new String[2];
        this.stageArray[0] = "IdentificationStage";
        this.stageArray[1] = "InventoryStage";
        this.daemon = daemonParam;
        this.debug = debugParam;
        this.sessionTimeout = timeoutParam;
        if (!this.debug) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FilteredStream filteredStream = new FilteredStream(byteArrayOutputStream);
            PrintStream aPrintStream = new PrintStream(filteredStream);
            System.setOut(aPrintStream);
            System.setErr(aPrintStream);
        }
        this.inventoryServerServerReference = this;
        this.dcmFileTranferCaller = this;
        this.inventoryServerServerCaller = inventoryServerServerCallerParam;
        this.remoteCommandCaller = this;
        this.inventoryInstance = inventoryInstanceParam;
        this.configuration = new Configuration(this.inventoryServerServerReference);
        try {
            this.inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException byteArrayOutputStream) {
            // empty catch block
        }
        this.dcmServerIP = this.inetAddress.getHostAddress();
        this.host = hostParam;
        this.dcmInventoryScriptFile = ".dcminventoryscript_" + this.dcmServerIP + "_" + this.host.getHostname() + ".sh";
        this.javaDBClient = null;
        try {
            this.javaDBClient = new DCMDBClient(this.inventoryServerServerReference, this.configuration.getJavaDB(), this.daemon, this.debug);
        }
        catch (SQLException ex) {
            this.inventoryServerServerCaller.log("SQLException", true, true, true);
        }
        catch (ClassNotFoundException ex) {
            this.inventoryServerServerCaller.log("ClassNotFoundException: " + ex.getMessage(), true, true, true);
        }
        catch (InstantiationException ex) {
            this.inventoryServerServerCaller.log("InstantiationException: " + ex.getMessage(), true, true, true);
        }
        catch (IllegalAccessException ex) {
            this.inventoryServerServerCaller.log("IllegalAccessException: " + ex.getMessage(), true, true, true);
        }
        catch (NoSuchMethodException ex) {
            this.inventoryServerServerCaller.log("NoSuchMethodException: " + ex.getMessage(), true, true, true);
        }
        catch (InvocationTargetException ex) {
            this.inventoryServerServerCaller.log("InvocationTargetException: " + ex.getMessage(), true, true, true);
        }
        catch (Exception ex) {
            this.inventoryServerServerCaller.log("Exception: " + ex.getMessage(), true, true, true);
        }
        this.server = new Server();
        this.server.setHost(this.host);
        this.command = new StringBuffer();
        this.command.append(this.getIdentificationCommand());
        this.inventoryServerServerCaller.log("Action:  DCMInventoryServerServer [" + this.inventoryInstance + "] connecting to Host: " + this.host.getHostname() + " for Identification Stage", true, true, true);
        try {
            this.remoteCommand = new DCMRemoteCommand(this.remoteCommandCaller, 0, this.host, this.command, true, this.sessionTimeout, this.debug);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void remoteFinalCommandSuccessResponse(int stageParam, String stdOutParam, String stdErrParam) {
        if (stageParam == 0) {
            this.sysinfo = DCMTools.substitude(DCMTools.substitude(DCMTools.startsWith(stdOutParam, "Sysinfo:"), "Sysinfo:"), this.customPromptFlat + ".*$");
            if (this.sysinfo.length() > 2) {
                this.inventoryServerServerCaller.log("Success: DCMInventoryServerServer: " + this.host.getHostname() + " Identification completed", true, true, true);
                this.host.setSysinfo(this.sysinfo);
                this.server.setHost(this.host);
                this.data = this.data + this.sysinfo;
                this.command.setLength(0);
                this.command.append(this.getInventoryScript(this.sysinfo));
                this.command.append(this.getRequirementsScript(this.sysinfo));
                new DCMFileWrite(this.dcmInventoryScriptFile, this.command.toString());
                this.inventoryServerServerCaller.log("Action:  DCMInventoryServerServer [" + this.inventoryInstance + "] transfering inventoryscript to Host: " + this.host.getHostname(), true, true, true);
                try {
                    new DCMFileTransfer(this.dcmFileTranferCaller, this.server.getHost(), this.dcmInventoryScriptFile);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                this.command.setLength(0);
                this.command.append("sh " + this.dcmInventoryScriptFile + "; ").append("echo \"" + this.customPromptFlat + "\";");
                this.inventoryServerServerCaller.log("Action:  DCMInventoryServer [" + this.inventoryInstance + "] connecting to Host: " + this.host.getHostname() + " for Inventory Stage", true, true, true);
                try {
                    new DCMRemoteCommand(this.remoteCommandCaller, 1, this.host, this.command, true, this.sessionTimeout, this.debug);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            } else {
                ++this.retryCounter;
                this.inventoryServerServerCaller.log("Failure: DCMInventoryServerServer [" + this.inventoryInstance + "] Host: " + this.host.getHostname() + " failed to identify server", true, true, true);
                if (this.retryCounter <= this.retryMax) {
                    this.command.setLength(0);
                    this.command.append(this.getIdentificationCommand());
                    this.inventoryServerServerCaller.log("Retry[" + this.retryCounter + "/" + this.retryMax + "] DCMInventoryServer [" + this.inventoryInstance + "] connecting to Host: " + this.host.getHostname() + " for Identification Stage", true, true, true);
                    try {
                        new DCMRemoteCommand(this.remoteCommandCaller, 0, this.host, this.command, true, this.sessionTimeout, this.debug);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                    this.data = "";
                }
            }
        } else if (stageParam == 1) {
            this.output = stdOutParam;
            if (this.sysinfo.length() > 2) {
                this.inventoryServerServerCaller.log("Success: DCMInventoryServerServer [" + this.inventoryInstance + "] Host: " + this.host.getHostname() + " inventory completed", true, true, true);
                this.data = this.data + this.output;
                String missingServerRequirements = this.getMissingServerRequirements(this.sysinfo, this.data);
                if (missingServerRequirements.length() > 0) {
                    this.inventoryServerServerCaller.log(missingServerRequirements, true, true, true);
                }
                if (this.sysinfo.contains("Linux")) {
                    DCMDataConverterLinux inventoryServerDataConverterLinux = null;
                    try {
                        inventoryServerDataConverterLinux = new DCMDataConverterLinux(this.host, this.retentionTime);
                    }
                    catch (UnknownHostException ex) {
                        this.inventoryServerServerCaller.log("InventoryServerServer Received Thrown UnknownHost from the LinuxCommandLibrary", true, true, true);
                    }
                    try {
                        this.server = (Server)inventoryServerDataConverterLinux.convertInventoryDataToServer(this.data).clone();
                    }
                    catch (CloneNotSupportedException ex) {
                        this.inventoryServerServerCaller.log("Inventory Clone server", true, true, true);
                    }
                } else if (this.sysinfo.contains("Darwin")) {
                    DCMDataConverterDarwin dcmDataConverterDarwin = null;
                    try {
                        dcmDataConverterDarwin = new DCMDataConverterDarwin(this.host, this.retentionTime);
                    }
                    catch (UnknownHostException ex) {
                        this.inventoryServerServerCaller.log("InventoryServerServer Received Thrown UnknownHost from the DarwinCommandLibrary", true, true, true);
                    }
                    try {
                        this.server = (Server)dcmDataConverterDarwin.convertInventoryDataToServer(this.data).clone();
                    }
                    catch (CloneNotSupportedException ex) {
                        this.inventoryServerServerCaller.log("Inventory Clone server", true, true, true);
                    }
                } else if (this.sysinfo.contains("SunOS")) {
                    DCMDataConverterSunOS inventoryServerDataConverterSunOS = null;
                    try {
                        inventoryServerDataConverterSunOS = new DCMDataConverterSunOS(this.host, this.retentionTime);
                    }
                    catch (UnknownHostException ex) {
                        this.inventoryServerServerCaller.log("InventoryServerServer Received Thrown UnknownHost from the SunOSCommandLibrary", true, true, true);
                    }
                    try {
                        this.server = (Server)inventoryServerDataConverterSunOS.convertInventoryDataToServer(this.data).clone();
                    }
                    catch (CloneNotSupportedException ex) {
                        this.inventoryServerServerCaller.log("Inventory Clone server", true, true, true);
                    }
                } else if (this.sysinfo.contains("AIX")) {
                    DCMDataConverterAIX inventoryServerDataConverterAIX = null;
                    try {
                        inventoryServerDataConverterAIX = new DCMDataConverterAIX(this.host, this.retentionTime);
                    }
                    catch (UnknownHostException ex) {
                        this.inventoryServerServerCaller.log("InventoryServerServer Received Thrown UnknownHost from the AIXCommandLibrary", true, true, true);
                    }
                    try {
                        this.server = (Server)inventoryServerDataConverterAIX.convertInventoryDataToServer(this.data).clone();
                    }
                    catch (CloneNotSupportedException ex) {
                        this.inventoryServerServerCaller.log("Inventory Clone server", true, true, true);
                    }
                } else if (this.sysinfo.contains("HP-UX")) {
                    DCMDataConverterHPUX inventoryServerDataConverterHPUX = null;
                    try {
                        inventoryServerDataConverterHPUX = new DCMDataConverterHPUX(this.host, this.retentionTime);
                    }
                    catch (UnknownHostException ex) {
                        this.inventoryServerServerCaller.log("InventoryServerServer Received Thrown UnknownHost from the HPUXCommandLibrary", true, true, true);
                    }
                    try {
                        this.server = (Server)inventoryServerDataConverterHPUX.convertInventoryDataToServer(this.data).clone();
                    }
                    catch (CloneNotSupportedException ex) {
                        this.inventoryServerServerCaller.log("Inventory Clone server", true, true, true);
                    }
                }
                try {
                    this.javaDBClient.deleteServerByHostname(this.server.getHost().getHostname());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                new DCMArchiveCreateServer(this.inventoryServerServerReference, this.server);
                this.inventoryServerServerCaller.log("Action:  DCMInventoryServerServer [" + this.inventoryInstance + "] inserting server: " + this.host.getHostname() + " into MetaDB", true, true, true);
                this.javaDBClient.insertServer(this.server);
                try {
                    this.server = this.javaDBClient.getServerByHostname(this.host.getHostname());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                try {
                    DCMPushPollScript dCMPushPollScript = new DCMPushPollScript(this.inventoryServerServerReference, this.server);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                this.deleteUnlinkedRRDArchives();
                this.inventoryServerServerCaller.log("Action:  DCMInventoryServerServer [" + this.inventoryInstance + "] inventory for server: " + this.host.getHostname() + " completed", true, true, true);
                this.inventoryServerServerCaller.inventoryReady();
            } else {
                this.inventoryServerServerCaller.log("Failure: DCMInventoryServerServer [" + this.inventoryInstance + "] Host: " + this.host.getHostname() + " inventory failed", true, true, true);
            }
        } else {
            this.inventoryServerServerCaller.log("Failure: DCMInventoryServerServer [" + this.inventoryInstance + "] Host: " + this.host.getHostname() + " Invalid inventory stage: " + stageParam + " returned", true, true, true);
        }
    }

    @Override
    public synchronized void remoteCommandSuccessResponse(int stageParam, String stdOutParam, String stdErrParam) {
        this.inventoryServerServerCaller.log("Success: DCMInventoryServerServer: remoteCommandSuccessResponse", true, true, true);
    }

    @Override
    public synchronized void remoteCommandFailureResponse(int stageParam, String messageParam) {
        ++this.retryCounter;
        if (this.retryCounter <= this.retryMax) {
            if (stageParam == 0) {
                this.command.setLength(0);
                this.command.append(this.getIdentificationCommand());
                this.inventoryServerServerCaller.log("Retry[" + this.retryCounter + "/" + this.retryMax + "] DCMInventoryServer [" + this.inventoryInstance + "] connecting to Host: " + this.host.getHostname() + " for Identification Stage", true, true, true);
                try {
                    new DCMRemoteCommand(this.remoteCommandCaller, 0, this.host, this.command, true, this.sessionTimeout, this.debug);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                this.data = "";
            } else if (stageParam == 1) {
                this.inventoryServerServerCaller.log("Retry[" + this.retryCounter + "/" + this.retryMax + "] DCMInventoryServer [" + this.inventoryInstance + "] connecting to Host: " + this.host.getHostname() + " for Inventory Stage", true, true, true);
                try {
                    new DCMRemoteCommand(this.remoteCommandCaller, 1, this.host, this.command, true, this.sessionTimeout, this.debug);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void rrdCreateSuccessResponse(String messageParam) {
        this.inventoryServerServerCaller.log("Success: DCMInventoryServerServer [" + this.inventoryInstance + "] Host: " + this.host.getHostname() + messageParam, true, true, true);
    }

    public synchronized void rrdCreateFailureResponse(String messageParam) {
        this.inventoryServerServerCaller.log("Failure: DCMInventoryServerServer [" + this.inventoryInstance + "] Host: " + this.host.getHostname() + messageParam, true, true, true);
    }

    public Server getServer() {
        return this.server;
    }

    private synchronized void deleteUnlinkedRRDArchives() {
        ArrayList<String> javaDBFileList = new ArrayList<String>();
        for (Resource resource : this.server.getResourceList()) {
            javaDBFileList.add(resource.getRRDFile());
        }
        Collections.sort(javaDBFileList);
        File hostRRDBDir = new File(this.configuration.getArchiveDBDir() + this.server.getHost().getHostname() + this.configuration.getFileSeparator());
        ArrayList<String> rrdbFileList = new ArrayList<String>();
        for (File file : hostRRDBDir.listFiles()) {
            rrdbFileList.add(file.getName());
        }
        Collections.sort(rrdbFileList);
        for (String file : rrdbFileList) {
            if (javaDBFileList.contains(file)) continue;
            File unlinkedFile = new File(this.configuration.getArchiveDBDir() + this.server.getHost().getHostname() + this.configuration.getFileSeparator() + file);
            if (unlinkedFile.delete()) {
                this.inventoryServerServerCaller.log("Removed unlinked archive file: " + unlinkedFile.getName(), true, true, true);
                continue;
            }
            this.inventoryServerServerCaller.log("Could not remove unlinked archive file: " + unlinkedFile.getName(), true, true, true);
        }
    }

    public String getIdentificationCommand() {
        return "echo \"Sysinfo: `uname -a`\"; echo \"" + this.customPromptFlat + "\";\r\n";
    }

    public StringBuffer getInventoryScript(String sysinfoParam) {
        StringBuffer cmd = new StringBuffer();
        if (sysinfoParam.contains("Linux")) {
            cmd.append("mpstat -P ALL | egrep -v \"CPU|^$\" | sed \"s/AM//\" | sed \"s/PM//\" | awk '{ print $2 }' | while read resource; do echo ").append("\"CPU: ${resource}\"; done; \n");
            cmd.append("iostat | egrep -ive \"cpu|device|^$|^ +\" | awk '{ print $1 }' | while read resource; do echo ").append("\"DiskIO: ${resource}\"; done; \n");
            cmd.append("df -kP | grep \"^/dev/\" | awk '{ print $6 }' | while read resource; do echo ").append("\"Storage: ${resource}\"; done; \n");
            cmd.append("netstat -i | egrep -vie \"kernel|^Iface|MTU\" | awk '{ print $1 }' | while read resource; do echo ").append("\"Network: ${resource}\"; done; \n");
        } else if (sysinfoParam.contains("Darwin")) {
            cmd.append("echo \"").append("\"CPU: all; \n");
            cmd.append("for resource in `iostat -d | head -1`; do echo ").append("\"DiskIO: ${resource}\"; done; \n");
            cmd.append("df -kP | grep \"^/dev/\" | awk '{ print $6 }' | while read resource; do echo ").append("\"Storage: ${resource}\"; done; \n");
            cmd.append("netstat -i | egrep \"en\" | grep Link | awk '{ print $1 }' | while read resource; do echo ").append("\"Network: ${resource}\"; done; \n");
        } else if (sysinfoParam.contains("SunOS")) {
            cmd.append("mpstat | egrep -v \"CPU|^$\" | awk '{ print $1 }' | while read resource; do echo ").append("\"CPU: ${resource}\"; done; \n");
            cmd.append("iostat -xtc | grep -v device | awk '{ print $1 }' | while read resource; do echo ").append("\"DiskIO: ${resource}\"; done; \n");
            cmd.append("df -lk | grep \"^/\" | grep -v \"/platform/\" | awk '{ print $6 }' | while read resource; do echo ").append("\"Storage: ${resource}\"; done; \n");
            cmd.append("netstat -i | awk '{ print $1 }' | egrep -ive \"name|^$\" | while read resource; do echo ").append("\"Network: ${resource}\"; done; \n");
        } else if (sysinfoParam.contains("AIX")) {
            cmd.append("mpstat | egrep -vi \"CPU|^$|U\" | awk '{ print $1 }' | while read resource; do echo ").append("\"CPU: ${resource}\"; done; \n");
            cmd.append("iostat -ld | egrep -e \"^hdisk\" | awk '{ print $1 }' | while read resource; do echo ").append("\"DiskIO: ${resource}\"; done; \n");
            cmd.append("df -k | grep \"/\" | grep -v \"/proc\" | awk '{ print $7 }' | while read resource; do echo ").append("\"Storage: ${resource}\"; done; \n");
            cmd.append("netstat -i | grep -i \"link\" | awk '{ print $1 }' | while read resource; do echo ").append("\"Network: ${resource}\"; done; \n");
        } else if (sysinfoParam.contains("HP-UX")) {
            cmd.append("c=0;while [ $c -lt `machinfo | grep -i cpus | awk '{ print $5 }'` ]; do echo $c;c=`expr $c + 1`;done | while read resource; do echo ").append("\"CPU: ${resource}\"; done; \n");
            cmd.append("echo \"CPU: all\"\n");
            cmd.append("iostat | awk '{ print $1 }' | egrep -ie \"^c[0-9]t[0-9]d[0-9]\" | while read resource; do echo ").append("\"DiskIO: ${resource}\"; done; \n");
            cmd.append("df -kP | awk '{ print $6 }' | egrep \"/\" | while read resource; do echo ").append("\"Storage: ${resource}\"; done; \n");
            cmd.append("netstat -ni | grep -vi \"Name\" | awk '{ print $1 }' | while read resource; do echo ").append("\"Network: ${resource}\"; done; \n");
        }
        return cmd;
    }

    public StringBuffer getRequirementsScript(String sysinfoParam) {
        StringBuffer cmd = new StringBuffer();
        if (sysinfoParam.contains("Linux")) {
            DCMCommandLibraryLinux dcmCommandLibraryLinux = null;
            try {
                dcmCommandLibraryLinux = new DCMCommandLibraryLinux(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            for (String[] cmdRecord : dcmCommandLibraryLinux.getCommandArray()) {
                cmd.append("echo \"CMD: " + cmdRecord[0] + " " + cmdRecord[1] + " `which " + cmdRecord[1] + "`\"\n");
            }
            cmd.append("echo \"").append(this.customPromptFlat).append("\";\n");
        } else if (sysinfoParam.contains("Darwin")) {
            DCMCommandLibraryDarwin dcmCommandLibraryDarwin = null;
            try {
                dcmCommandLibraryDarwin = new DCMCommandLibraryDarwin(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            for (String[] cmdRecord : dcmCommandLibraryDarwin.getCommandArray()) {
                cmd.append("echo \"CMD: " + cmdRecord[0] + " " + cmdRecord[1] + " `which " + cmdRecord[1] + "`\"\n");
            }
            cmd.append("echo \"").append(this.customPromptFlat).append("\";\n");
        } else if (sysinfoParam.contains("SunOS")) {
            DCMCommandLibrarySunOS dcmCommandLibrarySunOS = null;
            try {
                dcmCommandLibrarySunOS = new DCMCommandLibrarySunOS(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            for (String[] cmdRecord : dcmCommandLibrarySunOS.getCommandArray()) {
                cmd.append("echo \"CMD: " + cmdRecord[0] + " " + cmdRecord[1] + " `which " + cmdRecord[1] + "`\"\n");
            }
            cmd.append("echo \"").append(this.customPromptFlat).append("\";\n");
        } else if (sysinfoParam.contains("AIX")) {
            DCMCommandLibraryAIX dcmCommandLibraryAIX = null;
            try {
                dcmCommandLibraryAIX = new DCMCommandLibraryAIX(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            for (String[] cmdRecord : dcmCommandLibraryAIX.getCommandArray()) {
                cmd.append("echo \"CMD: " + cmdRecord[0] + " " + cmdRecord[1] + " `which " + cmdRecord[1] + "`\"\n");
            }
            cmd.append("echo \"").append(this.customPromptFlat).append("\";\n");
        } else if (sysinfoParam.contains("HP-UX")) {
            DCMCommandLibraryHPUX dcmCommandLibraryHPUX = null;
            try {
                dcmCommandLibraryHPUX = new DCMCommandLibraryHPUX(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            for (String[] cmdRecord : dcmCommandLibraryHPUX.getCommandArray()) {
                cmd.append("echo \"CMD: " + cmdRecord[0] + " " + cmdRecord[1] + " `which " + cmdRecord[1] + "`\"\n");
            }
            cmd.append("echo \"").append(this.customPromptFlat).append("\";\n");
        }
        return cmd;
    }

    public String getMissingServerRequirements(String sysinfoParam, String dataParam) {
        String dataHeaders = "";
        dataHeaders = "CMD: ";
        String line = "";
        String output = "";
        if (sysinfoParam.contains("Linux")) {
            DCMCommandLibraryLinux dcmCommandLibraryLinux = null;
            try {
                dcmCommandLibraryLinux = new DCMCommandLibraryLinux(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            String[][] commandArray = dcmCommandLibraryLinux.getCommandArray();
            BufferedReader reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
            line = "";
            output = "";
            try {
                while ((line = reader.readLine()) != null) {
                    String[] inventoryDataFields = new String[4];
                    inventoryDataFields = line.split("\\s+", 4);
                    if (inventoryDataFields[3].length() >= 1) continue;
                    output = output + "Warning: DCMInventoryServerServer: Server: " + this.host.getHostname() + " " + commandArray[Integer.parseInt(inventoryDataFields[1])][3];
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (sysinfoParam.contains("Darwin")) {
            DCMCommandLibraryDarwin dcmCommandLibraryDarwin = null;
            try {
                dcmCommandLibraryDarwin = new DCMCommandLibraryDarwin(this.host);
            }
            catch (UnknownHostException commandArray) {
                // empty catch block
            }
            String[][] commandArray = dcmCommandLibraryDarwin.getCommandArray();
            BufferedReader reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
            line = "";
            output = "";
            try {
                while ((line = reader.readLine()) != null) {
                    String[] inventoryDataFields = new String[4];
                    inventoryDataFields = line.split("\\s+", 4);
                    if (inventoryDataFields[3].length() >= 1) continue;
                    output = output + "Warning: DCMInventoryServerServer: Server: " + this.host.getHostname() + " " + commandArray[Integer.parseInt(inventoryDataFields[1])][3];
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (sysinfoParam.contains("SunOS")) {
            DCMCommandLibrarySunOS dcmCommandLibrarySunOS = null;
            try {
                dcmCommandLibrarySunOS = new DCMCommandLibrarySunOS(this.host);
            }
            catch (UnknownHostException commandArray) {
                // empty catch block
            }
            String[][] commandArray = dcmCommandLibrarySunOS.getCommandArray();
            BufferedReader reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
            line = "";
            output = "";
            try {
                while ((line = reader.readLine()) != null) {
                    String[] inventoryDataFields = new String[4];
                    inventoryDataFields = line.split("\\s+", 4);
                    if (inventoryDataFields[3].length() >= 1) continue;
                    output = output + "Warning: DCMInventoryServerServer: Server: " + this.host.getHostname() + " " + commandArray[Integer.parseInt(inventoryDataFields[1])][3];
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (sysinfoParam.contains("AIX")) {
            DCMCommandLibraryAIX dcmCommandLibraryAIX = null;
            try {
                dcmCommandLibraryAIX = new DCMCommandLibraryAIX(this.host);
            }
            catch (UnknownHostException commandArray) {
                // empty catch block
            }
            String[][] commandArray = dcmCommandLibraryAIX.getCommandArray();
            BufferedReader reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
            line = "";
            output = "";
            try {
                while ((line = reader.readLine()) != null) {
                    String[] inventoryDataFields = new String[4];
                    inventoryDataFields = line.split("\\s+", 4);
                    if (inventoryDataFields[3].length() >= 1) continue;
                    output = output + "Warning: DCMInventoryServerServer: Server: " + this.host.getHostname() + " " + commandArray[Integer.parseInt(inventoryDataFields[1])][3];
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (sysinfoParam.contains("HP-UX")) {
            DCMCommandLibraryHPUX dcmCommandLibraryHPUX = null;
            try {
                dcmCommandLibraryHPUX = new DCMCommandLibraryHPUX(this.host);
            }
            catch (UnknownHostException commandArray) {
                // empty catch block
            }
            String[][] commandArray = dcmCommandLibraryHPUX.getCommandArray();
            BufferedReader reader = new BufferedReader(new StringReader(DCMTools.startsWith(dataParam, dataHeaders)));
            line = "";
            output = "";
            try {
                while ((line = reader.readLine()) != null) {
                    String[] inventoryDataFields = new String[4];
                    inventoryDataFields = line.split("\\s+", 4);
                    if (inventoryDataFields[3].length() >= 1) continue;
                    output = output + "Warning: DCMInventoryServerServer: Server: " + this.host.getHostname() + " " + commandArray[Integer.parseInt(inventoryDataFields[1])][3];
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    @Override
    public synchronized void log(String messageParam, boolean logToStatusParam, boolean logToApplicationParam, boolean logToFileParam) {
        if (logToStatusParam) {
            this.inventoryServerServerCaller.log(messageParam, logToStatusParam, logToApplicationParam, logToFileParam);
        }
    }

    @Override
    public void dbClientReady() {
    }

    @Override
    public void updatedHost() {
    }

    @Override
    public void inventoryReady(Server serverParam) {
    }

    public class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

