/*
 * Decompiled with CFR 0.152.
 */
import data.MD5Converter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.layout.GroupLayout;

public class DCMLoginFormClient
extends JFrame {
    String hostname;
    DCMClient dcmClient;
    private JLabel connectLabel;
    private JLabel hostLabel;
    private JButton loginButton;
    private JPanel loginPanel;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JLabel portLabel;
    private JTextField rmiPortField;
    private JComboBox<String> rmiServerComboBox;
    private JPanel serverPanel;
    private JLabel statusLabel;
    private JLabel userLabel;
    private JTextField usernameField;
    private JPanel windowPanel;

    public DCMLoginFormClient(DCMClient dcManagerClientParam) throws UnsupportedLookAndFeelException {
        this.dcmClient = dcManagerClientParam;
        this.initComponents();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        int posX = Math.round(screenDim.width / 2 - winWidth / 2);
        int posY = Math.round(screenDim.height / 2 - winHeight / 2);
        this.setLocation(posX, posY);
    }

    private void initComponents() {
        this.windowPanel = new JPanel();
        this.serverPanel = new JPanel();
        this.hostLabel = new JLabel();
        this.portLabel = new JLabel();
        this.rmiServerComboBox = new JComboBox();
        this.rmiPortField = new JTextField();
        this.loginPanel = new JPanel();
        this.userLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.usernameField = new JTextField();
        this.passwordField = new JPasswordField();
        this.loginButton = new JButton();
        this.connectLabel = new JLabel();
        this.statusLabel = new JLabel();
        this.setAlwaysOnTop(true);
        this.setFont(new Font("Arial", 0, 10));
        this.setResizable(false);
        this.windowPanel.setBackground(new Color(153, 153, 153));
        this.windowPanel.setFont(this.windowPanel.getFont());
        this.serverPanel.setBackground(new Color(153, 153, 153));
        ResourceBundle bundle = ResourceBundle.getBundle("DCMLoginFormClient");
        this.serverPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("DCMLoginFormClient.serverPanel.border.title"), 2, 2, new Font("Lucida Grande", 0, 12), new Color(51, 51, 51)));
        this.serverPanel.setFont(this.serverPanel.getFont());
        this.hostLabel.setFont(this.hostLabel.getFont().deriveFont((float)this.hostLabel.getFont().getSize() - 1.0f));
        this.hostLabel.setForeground(new Color(51, 51, 51));
        this.hostLabel.setHorizontalAlignment(0);
        this.hostLabel.setText(bundle.getString("DCMLoginFormClient.hostLabel.text"));
        this.portLabel.setFont(this.portLabel.getFont().deriveFont((float)this.portLabel.getFont().getSize() - 1.0f));
        this.portLabel.setForeground(new Color(51, 51, 51));
        this.portLabel.setHorizontalAlignment(0);
        this.portLabel.setText(bundle.getString("DCMLoginFormClient.portLabel.text"));
        this.rmiServerComboBox.setEditable(true);
        this.rmiServerComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"192.168.192.3", "localhost"}));
        this.rmiServerComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DCMLoginFormClient.this.rmiServerComboBoxKeyReleased(evt);
            }
        });
        this.rmiPortField.setBackground(new Color(204, 204, 204));
        this.rmiPortField.setFont(this.rmiPortField.getFont().deriveFont((float)this.rmiPortField.getFont().getSize() - 1.0f));
        this.rmiPortField.setHorizontalAlignment(0);
        this.rmiPortField.setText(bundle.getString("DCMLoginFormClient.rmiPortField.text"));
        this.rmiPortField.setToolTipText(bundle.getString("DCMLoginFormClient.rmiPortField.toolTipText"));
        this.rmiPortField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DCMLoginFormClient.this.rmiPortFieldKeyReleased(evt);
            }
        });
        GroupLayout serverPanelLayout = new GroupLayout((Container)this.serverPanel);
        this.serverPanel.setLayout((LayoutManager)serverPanelLayout);
        serverPanelLayout.setHorizontalGroup((GroupLayout.Group)serverPanelLayout.createParallelGroup(1).add((GroupLayout.Group)serverPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)serverPanelLayout.createParallelGroup(1).add(this.rmiServerComboBox, 0, 374, Short.MAX_VALUE).add((Component)this.hostLabel, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)serverPanelLayout.createParallelGroup(1).add((GroupLayout.Group)serverPanelLayout.createSequentialGroup().add(8, 8, 8).add((Component)this.portLabel, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)serverPanelLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.rmiPortField, -1, 141, Short.MAX_VALUE))).addContainerGap()));
        serverPanelLayout.setVerticalGroup((GroupLayout.Group)serverPanelLayout.createParallelGroup(1).add((GroupLayout.Group)serverPanelLayout.createSequentialGroup().add((GroupLayout.Group)serverPanelLayout.createParallelGroup(3).add((Component)this.hostLabel).add((Component)this.portLabel)).add(18, 18, 18).add((GroupLayout.Group)serverPanelLayout.createParallelGroup(3).add((Component)this.rmiPortField, -2, -1, -2).add(this.rmiServerComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.loginPanel.setBackground(new Color(153, 153, 153));
        this.loginPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("DCMLoginFormClient.loginPanel.border.title"), 2, 2, new Font("Lucida Grande", 0, 12), new Color(51, 51, 51)));
        this.loginPanel.setFont(this.loginPanel.getFont());
        this.userLabel.setFont(this.userLabel.getFont().deriveFont((float)this.userLabel.getFont().getSize() - 1.0f));
        this.userLabel.setForeground(new Color(51, 51, 51));
        this.userLabel.setHorizontalAlignment(0);
        this.userLabel.setText(bundle.getString("DCMLoginFormClient.userLabel.text"));
        this.passwordLabel.setFont(this.passwordLabel.getFont().deriveFont((float)this.passwordLabel.getFont().getSize() - 1.0f));
        this.passwordLabel.setForeground(new Color(51, 51, 51));
        this.passwordLabel.setHorizontalAlignment(0);
        this.passwordLabel.setText(bundle.getString("DCMLoginFormClient.passwordLabel.text"));
        this.usernameField.setBackground(new Color(204, 204, 204));
        this.usernameField.setFont(this.usernameField.getFont().deriveFont((float)this.usernameField.getFont().getSize() - 1.0f));
        this.usernameField.setHorizontalAlignment(2);
        this.usernameField.setText(bundle.getString("DCMLoginFormClient.usernameField.text"));
        this.usernameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DCMLoginFormClient.this.usernameFieldKeyReleased(evt);
            }
        });
        this.passwordField.setBackground(new Color(204, 204, 204));
        this.passwordField.setFont(this.passwordField.getFont().deriveFont((float)this.passwordField.getFont().getSize() - 1.0f));
        this.passwordField.setHorizontalAlignment(2);
        this.passwordField.setToolTipText(bundle.getString("DCMLoginFormClient.passwordField.toolTipText"));
        this.passwordField.setFocusCycleRoot(true);
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DCMLoginFormClient.this.passwordFieldKeyReleased(evt);
            }
        });
        this.loginButton.setFont(this.loginButton.getFont().deriveFont((float)this.loginButton.getFont().getSize() + 1.0f));
        this.loginButton.setText(bundle.getString("DCMLoginFormClient.loginButton.text"));
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMLoginFormClient.this.loginButtonActionPerformed(evt);
            }
        });
        GroupLayout loginPanelLayout = new GroupLayout((Container)this.loginPanel);
        this.loginPanel.setLayout((LayoutManager)loginPanelLayout);
        loginPanelLayout.setHorizontalGroup((GroupLayout.Group)loginPanelLayout.createParallelGroup(1).add((GroupLayout.Group)loginPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)loginPanelLayout.createParallelGroup(1).add(2, (Component)this.loginButton, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)loginPanelLayout.createSequentialGroup().add((GroupLayout.Group)loginPanelLayout.createParallelGroup(1).add((Component)this.userLabel, -1, 284, Short.MAX_VALUE).add((Component)this.usernameField)).addPreferredGap(0).add((GroupLayout.Group)loginPanelLayout.createParallelGroup(1, false).add((GroupLayout.Group)loginPanelLayout.createSequentialGroup().add((Component)this.passwordLabel, -1, -1, Short.MAX_VALUE).add(7, 7, 7)).add((Component)this.passwordField, -2, 231, -2)))).addContainerGap()));
        loginPanelLayout.setVerticalGroup((GroupLayout.Group)loginPanelLayout.createParallelGroup(1).add((GroupLayout.Group)loginPanelLayout.createSequentialGroup().add((GroupLayout.Group)loginPanelLayout.createParallelGroup(3).add((Component)this.userLabel).add((Component)this.passwordLabel)).addPreferredGap(0).add((GroupLayout.Group)loginPanelLayout.createParallelGroup(3).add((Component)this.usernameField, -2, -1, -2).add((Component)this.passwordField, -2, -1, -2)).addPreferredGap(0).add((Component)this.loginButton, -2, 41, -2).addContainerGap(-1, Short.MAX_VALUE)));
        loginPanelLayout.linkSize(new Component[]{this.passwordField, this.usernameField}, 2);
        this.connectLabel.setBackground(new Color(51, 51, 51));
        this.connectLabel.setFont(this.connectLabel.getFont().deriveFont((float)this.connectLabel.getFont().getSize() + 5.0f));
        this.connectLabel.setForeground(new Color(204, 204, 204));
        this.connectLabel.setHorizontalAlignment(0);
        this.connectLabel.setText(bundle.getString("DCMLoginFormClient.connectLabel.text"));
        this.connectLabel.setOpaque(true);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont((float)this.statusLabel.getFont().getSize() - 2.0f));
        this.statusLabel.setForeground(new Color(51, 51, 51));
        this.statusLabel.setHorizontalAlignment(2);
        this.statusLabel.setText(bundle.getString("DCMLoginFormClient.statusLabel.text"));
        this.statusLabel.setBorder(BorderFactory.createEtchedBorder(0, new Color(204, 204, 204), new Color(51, 51, 51)));
        GroupLayout windowPanelLayout = new GroupLayout((Container)this.windowPanel);
        this.windowPanel.setLayout((LayoutManager)windowPanelLayout);
        windowPanelLayout.setHorizontalGroup((GroupLayout.Group)windowPanelLayout.createParallelGroup(1).add((Component)this.serverPanel, -1, -1, Short.MAX_VALUE).add((Component)this.connectLabel, -1, -1, Short.MAX_VALUE).add((Component)this.loginPanel, -1, -1, Short.MAX_VALUE).add((Component)this.statusLabel, -1, -1, Short.MAX_VALUE));
        windowPanelLayout.setVerticalGroup((GroupLayout.Group)windowPanelLayout.createParallelGroup(1).add((GroupLayout.Group)windowPanelLayout.createSequentialGroup().add((Component)this.connectLabel, -2, 34, -2).add(7, 7, 7).add((Component)this.serverPanel, -2, -1, -2).addPreferredGap(1).add((Component)this.loginPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.statusLabel, -2, 21, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.windowPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.windowPanel, -2, -1, -2));
        this.pack();
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        this.login();
    }

    private void login() {
        String dcmServer = String.valueOf(this.rmiServerComboBox.getSelectedItem());
        if (dcmServer.length() > 0 && this.rmiPortField.getText().length() > 0 && this.usernameField.getText().length() > 0 && new String(this.passwordField.getPassword()).length() > 0) {
            if (this.dcmClient.dcmClientRMI.connect(dcmServer, this.rmiPortField.getText())) {
                this.dcmClient.continueAfterConnect(this.usernameField.getText(), MD5Converter.getMD5SumFromString(new String(this.passwordField.getPassword())));
            } else {
                this.statusLabel.setText("Failed to connect to server: " + dcmServer + ":" + this.rmiPortField.getText());
                this.loginButton.setEnabled(false);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.loginButton.setEnabled(true);
            }
        } else {
            this.status("Please fillin all fields...");
        }
    }

    protected String getRMIServer() {
        return String.valueOf(this.rmiServerComboBox.getSelectedItem());
    }

    protected String getRMIPort() {
        return this.rmiPortField.getText();
    }

    private void rmiPortFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.login();
        }
    }

    private void usernameFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.login();
        }
    }

    private void passwordFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.login();
        }
    }

    private void rmiServerComboBoxKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.login();
        }
    }

    public void resetPassword() {
        this.passwordField.setText("");
    }

    public void status(String status) {
        this.statusLabel.setText(status);
    }

    public void close() {
        this.close();
    }
}

