/*
 * Decompiled with CFR 0.152.
 */
import data.ConfigurationCaller;
import data.Resource;
import data.Server;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DCMPollServer
implements DCMRemoteCommandCaller,
DCMDBClientCaller,
ConfigurationCaller,
DCMPushPollScriptCaller {
    private Server server;
    private StringBuffer command;
    private String data;
    private int sessionTimeout = 10;
    private String customPromptFlat = "DCMCommandEnd";
    private boolean debug = false;
    private DCMPollServerCaller pollServerCaller;
    private final DCMRemoteCommandCaller remoteCommandCaller;
    private DCMPollerDataToServer pollerDataToServer;
    private DCMArchiveUpdate rrdUpdate;
    private DCMDBClientCaller javaDBClientCaller;
    private DCMPollServer pollerReference;
    private final int POLLSTAGE = 0;
    private InetAddress inetAddress;
    private String pollerIP;
    private int pollerInstance;
    private String dcmPollerScriptFile;
    private String dcmPollerDataFile;
    private String dcmPollerErrorFile;
    private boolean runAsDeamon = true;
    private static final String THISPRODUCT = "DCMPollServer";
    private final String LINUX = "Linux";
    private final String DARWIN = "Darwin";
    private final String SUNOS = "SunOS";
    private final String AIX = "AIX";
    private final String HPUX = "HP-UX";

    public DCMPollServer(DCMPollServerCaller pollerCallerParam, int pollerInstanceParam, Server serverParam, int timeoutParam, boolean debugParam) throws UnknownHostException, CloneNotSupportedException {
        this.debug = debugParam;
        this.sessionTimeout = timeoutParam;
        if (!this.debug) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FilteredStream filteredStream = new FilteredStream(byteArrayOutputStream);
            PrintStream aPrintStream = new PrintStream(filteredStream);
            System.setOut(aPrintStream);
            System.setErr(aPrintStream);
        } else {
            System.out.println("DCMPollServer debugging enabled for server: " + serverParam.getHost().getHostname());
        }
        this.inetAddress = InetAddress.getLocalHost();
        this.pollerIP = this.inetAddress.getHostAddress();
        this.pollerReference = this;
        this.pollServerCaller = pollerCallerParam;
        this.remoteCommandCaller = this;
        this.pollerInstance = pollerInstanceParam;
        this.server = (Server)serverParam.clone();
        this.dcmPollerScriptFile = ".dcmpollscript_" + this.pollerIP + "_" + this.server.getHost().getHostname() + ".sh";
        this.dcmPollerDataFile = ".dcmpolldata_" + this.pollerIP + "_" + this.server.getHost().getHostname() + ".dat";
        this.dcmPollerErrorFile = ".dcmpolldata_" + this.pollerIP + "_" + this.server.getHost().getHostname() + ".err";
        Thread pollServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMPollServer.this.command = new StringBuffer();
                DCMPollServer.this.command.append("sort -k 1n ").append(DCMPollServer.this.dcmPollerDataFile).append("\n");
                DCMPollServer.this.command.append("> ").append(DCMPollServer.this.dcmPollerDataFile).append("\n");
                if (DCMPollServer.this.server.getHost().getSysinfo().contains("SunOS")) {
                    DCMPollServer.this.command.append("nohup ksh " + DCMPollServer.this.dcmPollerScriptFile + " 2> " + DCMPollServer.this.dcmPollerErrorFile + " & \n");
                } else if (DCMPollServer.this.server.getHost().getSysinfo().contains("Darwin")) {
                    DCMPollServer.this.command.append("sh " + DCMPollServer.this.dcmPollerScriptFile + " 2> " + DCMPollServer.this.dcmPollerErrorFile + " & \n");
                    DCMPollServer.this.command.append("disown -ah \n");
                    DCMPollServer.this.command.append("unset HISTFILE \n");
                } else if (DCMPollServer.this.server.getHost().getSysinfo().contains("Linux")) {
                    DCMPollServer.this.command.append("sh " + DCMPollServer.this.dcmPollerScriptFile + " & 2> " + DCMPollServer.this.dcmPollerErrorFile + "\n");
                    DCMPollServer.this.command.append("disown -ah \n");
                    DCMPollServer.this.command.append("unset HISTFILE \n");
                } else if (DCMPollServer.this.server.getHost().getSysinfo().contains("AIX")) {
                    DCMPollServer.this.command.append("ksh93\n");
                    DCMPollServer.this.command.append("disown \n");
                    DCMPollServer.this.command.append("ksh " + DCMPollServer.this.dcmPollerScriptFile + " & 2> " + DCMPollServer.this.dcmPollerErrorFile + "\n");
                    DCMPollServer.this.command.append("unset HISTFILE \n");
                } else if (DCMPollServer.this.server.getHost().getSysinfo().contains("HP-UX")) {
                    DCMPollServer.this.command.append("nohup ksh " + DCMPollServer.this.dcmPollerScriptFile + " 2> " + DCMPollServer.this.dcmPollerErrorFile + " & \n");
                } else {
                    DCMPollServer.this.command.append("nohup sh " + DCMPollServer.this.dcmPollerScriptFile + " & 2> " + DCMPollServer.this.dcmPollerErrorFile + "\n");
                    DCMPollServer.this.command.append("disown -ah \n");
                    DCMPollServer.this.command.append("unset HISTFILE \n");
                }
                DCMPollServer.this.command.append("echo \"" + DCMPollServer.this.customPromptFlat + "\";\n");
                DCMPollServer.this.pollServerCaller.log("Action:  DCMPollServer [" + DCMPollServer.this.pollerInstance + "] connecting to Host: " + DCMPollServer.this.server.getHost().getHostname() + " for collecting data...", true, true, true);
                try {
                    new DCMRemoteCommand(DCMPollServer.this.remoteCommandCaller, 0, DCMPollServer.this.server.getHost(), DCMPollServer.this.command, true, DCMPollServer.this.sessionTimeout, DCMPollServer.this.debug);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        });
        pollServerThread.setName("pollServerThread");
        pollServerThread.setDaemon(this.runAsDeamon);
        pollServerThread.setPriority(5);
        pollServerThread.start();
    }

    @Override
    public synchronized void remoteFinalCommandSuccessResponse(final int stageParam, final String stdOutParam, final String stdErrParam) {
        Thread updateArchiveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (stageParam == 0) {
                    if (stdOutParam.contains(DCMPollServer.this.dcmPollerScriptFile) && (stdOutParam.toUpperCase().contains("No such file".toUpperCase()) || stdOutParam.toUpperCase().contains("not found".toUpperCase())) || stdErrParam.contains(DCMPollServer.this.dcmPollerScriptFile) && (stdErrParam.toUpperCase().contains("No such file".toUpperCase()) || stdErrParam.toUpperCase().contains("not found".toUpperCase()))) {
                        DCMPollServer.this.pollServerCaller.log("Warning: DCMPollServer: pollscript " + DCMPollServer.this.dcmPollerScriptFile + " not found on server " + DCMPollServer.this.server.getHost().getHostname(), true, true, true);
                        try {
                            DCMPushPollScript dCMPushPollScript = new DCMPushPollScript(DCMPollServer.this.pollerReference, DCMPollServer.this.server);
                        }
                        catch (UnknownHostException unknownHostException) {}
                    } else {
                        DCMPollServer.this.data = stdOutParam;
                        if (DCMPollServer.this.data.length() > 2) {
                            DCMPollServer.this.pollServerCaller.log("Success: DCMPollServer: [" + DCMPollServer.this.pollerInstance + "] Host: " + DCMPollServer.this.server.getHost().getHostname() + " poll completed\r\n", true, true, true);
                            DCMPollServer.this.pollerDataToServer = new DCMPollerDataToServer();
                            try {
                                DCMPollServer.this.server = (Server)DCMPollServer.this.pollerDataToServer.convertPollerDataToServer(DCMPollServer.this.server, DCMPollServer.this.data).clone();
                            }
                            catch (CloneNotSupportedException ex) {
                                DCMPollServer.this.pollServerCaller.log("Poller Clone server", true, true, true);
                            }
                            if (DCMPollServer.this.debug) {
                                DCMPollServer.this.pollServerCaller.log("Debug:   DCMPollServer: Converted Data from server: " + DCMPollServer.this.server.getHost().getHostname() + ":\n", false, true, true);
                                for (Resource resource : DCMPollServer.this.server.getResourceList()) {
                                    DCMPollServer.this.pollServerCaller.log(resource.getId() + " " + resource.getRRDFile() + " " + resource.getCategory() + " " + resource.getResource() + " " + resource.getLastValue(), false, true, true);
                                }
                            }
                            DCMPollServer.this.rrdUpdate = new DCMArchiveUpdate(DCMPollServer.this.pollerReference, DCMPollServer.this.server);
                            DCMPollServer.this.pollServerCaller.pollServerReady();
                        } else {
                            DCMPollServer.this.pollServerCaller.log("Failure: DCMPollServer[" + DCMPollServer.this.pollerInstance + "] Host: " + DCMPollServer.this.server.getHost().getHostname() + " no poller data", true, true, true);
                        }
                    }
                } else {
                    DCMPollServer.this.pollServerCaller.log("Failure: DCMPollServer[" + DCMPollServer.this.pollerInstance + "] Host: " + DCMPollServer.this.server.getHost().getHostname() + " Invalid stage: " + stageParam + " returned", true, true, true);
                }
            }
        });
        updateArchiveThread.setName("updateArchiveThread");
        updateArchiveThread.setDaemon(this.runAsDeamon);
        updateArchiveThread.setPriority(5);
        updateArchiveThread.start();
    }

    @Override
    public void remoteCommandSuccessResponse(int stageParam, String stdOutParam, String stdErrParam) {
        if (stdOutParam.contains(this.dcmPollerScriptFile) && (stdOutParam.toUpperCase().contains("No such file".toUpperCase()) || stdOutParam.toUpperCase().contains("not found".toUpperCase())) || stdErrParam.contains(this.dcmPollerScriptFile) && (stdErrParam.toUpperCase().contains("No such file".toUpperCase()) || stdErrParam.toUpperCase().contains("not found".toUpperCase()))) {
            this.pollServerCaller.log("Warning: DCMPollServer: pollscript " + this.dcmPollerScriptFile + " not found on server " + this.server.getHost().getHostname(), true, true, true);
            try {
                DCMPushPollScript dCMPushPollScript = new DCMPushPollScript(this.pollerReference, this.server);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void remoteCommandFailureResponse(int stageParam, String messageParam) {
        this.pollServerCaller.log(messageParam, true, true, true);
    }

    public void rrdUpdateSuccessResponse(String messageParam) {
        this.pollServerCaller.log("Success: DCMPollServer[" + this.pollerInstance + "] Host: " + this.server.getHost().getHostname() + messageParam, true, true, true);
    }

    public void rrdUpdateFailureResponse(String messageParam) {
        this.pollServerCaller.log("Failure: DCMPollServer[" + this.pollerInstance + "] Host: " + this.server.getHost().getHostname() + messageParam, true, true, true);
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public void log(String messageParam, boolean logToStatusParam, boolean logToApplicationParam, boolean logToFileParam) {
        this.pollServerCaller.log(messageParam, logToStatusParam, logToApplicationParam, logToFileParam);
    }

    @Override
    public void dbClientReady() {
    }

    @Override
    public void updatedHost() {
    }

    @Override
    public void inventoryReady(Server serverParam) {
    }

    public class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

