/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.ConfigurationCaller;
import data.Server;
import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;

public class DCMPoller
implements DCMDBClientCaller,
ConfigurationCaller,
DCMPollServerCaller {
    String serversListArray;
    int sessionTimeout = 10;
    int serverInstanceCounter = 0;
    DCMCommandLibraryLinux commandsLibrary;
    private DCMDBClient dcmDBClient;
    private DCMDBClientCaller dcmMetaDBClientCaller;
    private DCMPoller pollerReference;
    private DCMPollServer pollServer;
    private DCMPollServerCaller pollServerCaller;
    private DCMPoller configurationCaller;
    private Configuration configuration;
    private int dutyCycle = 40;
    private Timer pollTime;
    private int pollerInstance;
    private Server server;
    private boolean isDBClientReady = false;
    private boolean singleShot = false;
    private Timer pollServersTimer;
    private Timer pollerExitTimer;
    private long pollTimerInterval = 60000L;
    private int counter = 0;
    private boolean runThreadsAsDaemons = true;
    private String logDateString;
    private Calendar currentTimeCalendar;
    private static final String THISPRODUCT = "DCMPoller";
    private FileWriter logFileWriter;
    private String logFileString;
    private String logBuffer = "";
    private boolean daemon = false;
    private boolean debug = false;

    public DCMPoller(boolean singleShotParam, int timeoutParam, boolean daemonParam, boolean debugParam) throws CloneNotSupportedException {
        this.daemon = daemonParam;
        this.debug = debugParam;
        this.sessionTimeout = timeoutParam;
        if (!this.debug) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FilteredStream filteredStream = new FilteredStream(byteArrayOutputStream);
            PrintStream aPrintStream = new PrintStream(filteredStream);
            System.setOut(aPrintStream);
            System.setErr(aPrintStream);
        } else {
            this.log("DCMPoller debugging enabled (SessionTimeout set to: " + this.sessionTimeout + " seconds)", true, true, true);
        }
        if (!this.daemon) {
            JFrame jframe = new JFrame(THISPRODUCT);
            jframe.setState(1);
            jframe.setDefaultCloseOperation(3);
            jframe.setVisible(true);
        }
        this.configuration = new Configuration();
        this.currentTimeCalendar = Calendar.getInstance();
        this.logDateString = "" + String.format("%04d", this.currentTimeCalendar.get(1)) + String.format("%02d", this.currentTimeCalendar.get(2) + 1) + String.format("%02d", this.currentTimeCalendar.get(5)) + "_" + String.format("%02d", this.currentTimeCalendar.get(11)) + String.format("%02d", this.currentTimeCalendar.get(12)) + String.format("%02d", this.currentTimeCalendar.get(13));
        this.logFileString = this.configuration.getLogDir() + this.logDateString + "_" + THISPRODUCT + ".log";
        this.pollerReference = this;
        this.server = new Server();
        this.singleShot = singleShotParam;
        Thread pollerJavaDBClientThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMPoller.this.dcmDBClient = null;
                try {
                    DCMPoller.this.dcmDBClient = new DCMDBClient(DCMPoller.this.pollerReference, DCMPoller.this.configuration.getJavaDB(), DCMPoller.this.daemon, DCMPoller.this.debug);
                }
                catch (SQLException ex) {
                    DCMPoller.this.log("Poller: SQLException", true, true, true);
                }
                catch (ClassNotFoundException ex) {
                    DCMPoller.this.log("Poller: ClassNotFoundException: " + ex.getMessage(), true, true, true);
                }
                catch (InstantiationException ex) {
                    DCMPoller.this.log("Poller: InstantiationException: " + ex.getMessage(), true, true, true);
                }
                catch (IllegalAccessException ex) {
                    DCMPoller.this.log("Poller: IllegalAccessException: " + ex.getMessage(), true, true, true);
                }
                catch (NoSuchMethodException ex) {
                    DCMPoller.this.log("Poller: NoSuchMethodException: " + ex.getMessage(), true, true, true);
                }
                catch (InvocationTargetException ex) {
                    DCMPoller.this.log("Poller: InvocationTargetException: " + ex.getMessage(), true, true, true);
                }
                catch (Exception ex) {
                    DCMPoller.this.log("Poller: Exception: " + ex.getMessage(), true, true, true);
                }
            }
        });
        pollerJavaDBClientThread.setName("pollerJavaDBClientThread");
        pollerJavaDBClientThread.setDaemon(this.runThreadsAsDaemons);
        pollerJavaDBClientThread.setPriority(5);
        pollerJavaDBClientThread.start();
        try {
            this.waitForExit();
        }
        catch (Exception ex) {
            this.log("Poller: Exception: waitForExit: " + ex.getMessage(), true, true, true);
        }
    }

    private void waitForExit() throws Exception {
        while (!this.isDBClientReady) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.singleShot) {
            this.pollerExitTimer = new Timer();
            this.pollerExitTimer.schedule((TimerTask)new DCMPollerExitTimer(this), this.pollTimerInterval);
            this.pollServers();
        } else {
            this.pollServersTimer = new Timer();
            this.pollServersTimer.scheduleAtFixedRate((TimerTask)new DCMPollServersTimer(this), 0L, this.pollTimerInterval);
        }
    }

    public void pollServers() throws CloneNotSupportedException, UnknownHostException {
        this.pollServerCaller = this;
        ArrayList<Object> serverList = new ArrayList();
        serverList = this.dcmDBClient.selectServers();
        this.counter = 0;
        for (Server server : serverList) {
            long sleepPeriod = this.dutyCycle * 1000 / serverList.size();
            if (sleepPeriod > 1000L) {
                sleepPeriod = 1000L;
            }
            if (server.getHost().getEnabled()) {
                try {
                    try {
                        this.pollServer = new DCMPollServer(this.pollServerCaller, this.counter, server, this.sessionTimeout, this.debug);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            ++this.counter;
            try {
                Thread.sleep(sleepPeriod);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void exitPoller() {
        System.exit(0);
    }

    @Override
    public final synchronized void log(final String messageParam, final boolean logToStatusParam, final boolean logToApplicationParam, final boolean logToFileParam) {
        Thread LogThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (logToStatusParam) {
                    // empty if block
                }
                if (logToApplicationParam && DCMPoller.this.debug) {
                    System.out.println(messageParam);
                }
                if (logToFileParam && DCMPoller.this.debug) {
                    DCMPoller.this.logToFile(messageParam);
                }
            }
        });
        LogThread.setName("LogThread");
        LogThread.setDaemon(false);
        LogThread.setPriority(5);
        LogThread.start();
    }

    public synchronized void logToFile(final String displaymessage) {
        Thread logToFileThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Calendar logCalendar = Calendar.getInstance();
                String humanDate = "" + String.format("%04d", logCalendar.get(1)) + "-" + String.format("%02d", logCalendar.get(2) + 1) + "-" + String.format("%02d", logCalendar.get(5)) + " " + String.format("%02d", logCalendar.get(11)) + ":" + String.format("%02d", logCalendar.get(12)) + ":" + String.format("%02d", logCalendar.get(13));
                try {
                    DCMPoller.this.logFileWriter = new FileWriter(DCMPoller.this.logFileString, true);
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: new FileWriter(" + DCMPoller.this.logFileString + ")" + ex.getMessage());
                    DCMPoller.this.logBuffer = DCMPoller.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMPoller.this.logFileWriter.flush();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.flush()1;");
                    DCMPoller.this.logBuffer = DCMPoller.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMPoller.this.logFileWriter.write(DCMPoller.this.logBuffer + humanDate + " " + displaymessage + "\r\n");
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.write()");
                    DCMPoller.this.logBuffer = DCMPoller.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMPoller.this.logFileWriter.flush();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.flush()2;");
                    DCMPoller.this.logBuffer = DCMPoller.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                DCMPoller.this.logBuffer = "";
                try {
                    DCMPoller.this.logFileWriter.close();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.close();");
                    return;
                }
            }
        });
        logToFileThread.setName("logToFileThread");
        logToFileThread.setDaemon(this.runThreadsAsDaemons);
        logToFileThread.start();
    }

    @Override
    public void dbClientReady() {
        this.isDBClientReady = true;
    }

    @Override
    public void pollServerReady() {
    }

    public static void main(final String[] argsParam) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean singleShot = false;
                int timeout = 10;
                boolean daemon = false;
                boolean debug = false;
                for (int i = 0; i < argsParam.length; ++i) {
                    if (argsParam[i].equals("--singleshot")) {
                        singleShot = true;
                        continue;
                    }
                    if (argsParam[i].equals("--continues")) {
                        singleShot = false;
                        continue;
                    }
                    if (argsParam[i].contains("timeout")) {
                        String[] timeoutArray = new String[2];
                        timeoutArray = argsParam[i].split("=");
                        try {
                            timeout = Integer.parseInt(timeoutArray[1]);
                        }
                        catch (NumberFormatException ex) {
                            timeout = 10;
                        }
                        continue;
                    }
                    if (argsParam[i].equals("--daemon")) {
                        daemon = true;
                        continue;
                    }
                    if (argsParam[i].equals("--debug")) {
                        debug = true;
                        continue;
                    }
                    if (argsParam[i].equals("--help")) {
                        DCMPoller.usage();
                        System.exit(1);
                        continue;
                    }
                    DCMPoller.usage();
                    System.exit(1);
                }
                try {
                    new DCMPoller(singleShot, timeout, daemon, debug);
                }
                catch (Exception ex) {
                    System.out.println("Error: main(): ");
                }
            }
        });
    }

    @Override
    public void updatedHost() {
    }

    private static void usage() {
        System.out.println("\n");
        System.out.println("Usage:   java -cp DCManager.jar DCMPoller [--singleshot|--continues] [--timeout=10] [--daemon] [--debug]\n");
        System.out.println(DCMLicense.getCopyright());
    }

    public class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

