/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.Resource;
import data.Server;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DCMPushPollScriptServer
implements DCMFileTranferCaller {
    private Configuration configuration;
    private InetAddress inetAddress;
    private String dcmServerIP;
    private Server server;
    private StringBuffer command;
    private String dcmPollerScriptFile;
    private String dcmPollerDataFile;
    private DCMPushPollScriptCaller pushPollScriptCaller;
    private DCMFileTranferCaller dcmFileTranferCaller = this;

    public DCMPushPollScriptServer(DCMPushPollScriptCaller pushPollScriptCallerParam, Server serverParam) throws UnknownHostException {
        this.pushPollScriptCaller = pushPollScriptCallerParam;
        this.configuration = new Configuration();
        this.inetAddress = InetAddress.getLocalHost();
        this.dcmServerIP = this.inetAddress.getHostAddress();
        this.server = serverParam;
        this.dcmPollerScriptFile = ".dcmpollscript_" + this.dcmServerIP + "_" + this.server.getHost().getHostname() + ".sh";
        this.dcmPollerDataFile = ".dcmpolldata_" + this.dcmServerIP + "_" + this.server.getHost().getHostname() + ".dat";
        this.command = new StringBuffer();
        this.command.setLength(0);
        this.command.append("# This script is generated by DatacenterManager " + DCMLicense.getVersion() + " hosted on: " + this.dcmServerIP + " \n");
        this.command.append("# Please do not change this script (unless you know what you are doing) as it's maintained by DCM\n");
        this.command.append("# Check the latest DCM version: https://sites.google.com/site/ronuitzaandam/home\n");
        this.command.append("# If for whatever reason this script malfunctions, then just delete it and it will be pushed again\n");
        this.command.append("#\n");
        this.command.append("set +e \n");
        if (this.server.getHost().getSysinfo().contains("HP-UX")) {
            this.command.append("UNIX95=\"\"; export UNIX95 # Just to make ps -o work on HPUX\n");
        }
        this.command.append("#\n");
        for (Resource resource : this.server.getResourceList()) {
            if (!resource.getEnabled()) continue;
            this.command.append("id").append(resource.getId()).append("=`").append(resource.getPollCommand().replaceAll("`", "\\\\`")).append("` && echo \"").append(" ").append(resource.getId()).append(" ${id").append(resource.getId()).append("}\" >> ").append(this.dcmPollerDataFile).append(" \n");
        }
        if (this.server.getHost().getCommand().length() > 0) {
            this.command.append("#\n");
            this.command.append("# Host Command\n");
            this.command.append("#\n");
            this.command.append(this.server.getHost().getCommand());
            this.command.append("#\n");
        }
        Thread PushPollScriptThread = new Thread(new Runnable(){

            @Override
            public void run() {
                new DCMFileWrite(DCMPushPollScriptServer.this.dcmPollerScriptFile, DCMPushPollScriptServer.this.command.toString());
                DCMPushPollScriptServer.this.pushPollScriptCaller.log("DCMPollServer transfering pollscript to server: " + DCMPushPollScriptServer.this.server.getHost().getHostname() + " ...", true, true, true);
                try {
                    DCMFileTransfer dCMFileTransfer = new DCMFileTransfer(DCMPushPollScriptServer.this.dcmFileTranferCaller, DCMPushPollScriptServer.this.server.getHost(), DCMPushPollScriptServer.this.dcmPollerScriptFile);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                DCMPushPollScriptServer.this.pushPollScriptCaller.log("DCMPollServer transfering pollscript to server: " + DCMPushPollScriptServer.this.server.getHost().getHostname() + " completed", true, true, true);
            }
        });
        PushPollScriptThread.setName("PushPollScriptThread");
        PushPollScriptThread.setDaemon(false);
        PushPollScriptThread.setPriority(5);
        PushPollScriptThread.start();
    }

    @Override
    public void log(String messageParam, boolean logToStatus, boolean logApplication, boolean logToFile) {
        this.pushPollScriptCaller.log(messageParam, logToStatus, logApplication, logToFile);
    }
}

