/*
 * Decompiled with CFR 0.152.
 */
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import data.Host;
import expectj.ExpectJ;
import expectj.ExpectJException;
import expectj.Spawn;
import expectj.TimeoutException;
import java.io.IOException;
import java.util.Properties;

public class DCMRemoteCommand {
    ExpectJ expect;
    Spawn spawn;
    String ipAddress;
    int port;
    String userPassword;
    String superuserPassword;
    StringBuffer command;
    int defaultTimeout = 15;
    int sessionTimeout;
    boolean debugging;
    boolean verbose;
    String promptFlat;
    String superuserPromptFlat;
    String promptRegex;
    String superuserPromptRegex;
    String customPromptFlat;
    String sysinfo;
    int stage;
    int state = 0;
    DCMRemoteCommandCaller remoteCommandCaller;
    private Host host = new Host();
    boolean finalCommand;
    private boolean runThreadsAsDaemons = true;
    private boolean customChannel = true;
    private JSch jsch;
    private Session session;
    private Channel channel;
    private UserInfo userInfo;
    private Properties sessionConfig;
    private boolean loginSuccess;

    public DCMRemoteCommand(DCMRemoteCommandCaller callerParam, int stageParam, Host hostParam, StringBuffer commandParam, boolean finalCommandParam, int sessionTimeoutParam, boolean debuggingParam) throws CloneNotSupportedException {
        this.remoteCommandCaller = callerParam;
        this.stage = stageParam;
        this.host = (Host)hostParam.clone();
        this.finalCommand = finalCommandParam;
        this.command = commandParam;
        this.sessionTimeout = sessionTimeoutParam;
        this.debugging = debuggingParam;
        if (this.host.getSuperuserPassword().length() == 0) {
            this.promptFlat = "$";
            this.promptRegex = "[>$] ";
            this.superuserPromptFlat = "#";
            this.superuserPromptRegex = "#";
            this.customPromptFlat = "DCMCommandEnd";
        } else {
            this.promptFlat = "$";
            this.promptRegex = "[>$] ";
            this.superuserPromptFlat = "#";
            this.superuserPromptRegex = "#";
            this.customPromptFlat = "DCMCommandEnd";
        }
        this.expect = new ExpectJ((long)this.sessionTimeout);
        this.loginSuccess = true;
        if (this.customChannel) {
            this.jsch = new JSch();
            try {
                this.session = this.jsch.getSession(this.host.getUsername(), this.host.getHostname(), this.host.getPort());
            }
            catch (JSchException ex) {
                this.remoteCommandCaller.log("Error:   DCMRemoteCommand: session = jsch.getSession(" + this.host.getUsername() + ", " + this.host.getHostname() + ", " + this.host.getPort() + ");", false, true, true);
                this.loginSuccess = false;
            }
            this.session.setPassword(this.host.getUserPassword());
            this.sessionConfig = new Properties();
            this.sessionConfig.put("StrictHostKeyChecking", "no");
            this.sessionConfig.put("userauth.keyboard-interactive", "com.jcraft.jsch.UserAuthKeyboardInteractive");
            this.sessionConfig.put("PreferredAuthentications", "keyboard-interactive,password");
            this.session.setConfig(this.sessionConfig);
            if (this.debugging) {
                this.remoteCommandCaller.log("Action:  SSHLogin to " + this.host.getUsername() + ":" + this.host.getUserPassword() + "@" + this.host.getHostname(), false, true, true);
            } else {
                this.remoteCommandCaller.log("Action:  DCMRemoteCommand: SSHLogin to " + this.host.getUsername() + "@" + this.host.getHostname(), false, true, true);
            }
            try {
                this.session.connect(this.sessionTimeout * 1000);
            }
            catch (JSchException ex) {
                this.remoteCommandCaller.log("Error:   DCMRemoteCommand: session.connect()); (" + ex.getMessage() + ")", true, true, true);
                this.loginSuccess = false;
            }
            if (this.loginSuccess) {
                this.remoteCommandCaller.log("Success: DCMRemoteCommand: Session Connected Successfully.", true, true, true);
            }
            if (this.loginSuccess) {
                this.channel = null;
                try {
                    this.channel = this.session.openChannel("shell");
                }
                catch (JSchException ex) {
                    this.remoteCommandCaller.log("Error:   DCMRemoteCommand: channel = session.openChannel(\"shell\"); (" + ex.getMessage() + ")", true, true, true);
                    this.loginSuccess = false;
                }
            }
            if (this.loginSuccess) {
                this.remoteCommandCaller.log("Success: DCMRemoteCommand: Channel Opened Successfully.", true, true, true);
            }
            if (this.loginSuccess) {
                this.spawn = null;
                try {
                    this.spawn = this.expect.spawn(this.channel);
                }
                catch (IOException ex) {
                    this.remoteCommandCaller.log("Error:   DCMRemoteCommand: spawn = expect.spawn(channel)); (" + ex.getMessage() + ")", true, true, true);
                    this.loginSuccess = false;
                }
            }
        } else {
            try {
                this.spawn = this.expect.spawn(this.host.getHostname(), this.host.getPort(), this.host.getUsername(), this.host.getUserPassword());
            }
            catch (IOException ex) {
                this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error: Login Failure: Could not login to " + this.host.getUsername() + "@" + this.host.getHostname() + " (" + ex.getMessage() + ")");
                this.loginSuccess = false;
            }
        }
        if (this.loginSuccess) {
            this.remoteCommandCaller.log("Success: DCMRemoteCommand: Login successful for host " + this.host.getHostname(), true, true, true);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.host.getSuperuserPassword().length() == 0) {
                this.cmd(this.command.toString());
            } else {
                this.supasswd(this.host.getSuperuserPassword());
            }
        } else {
            this.closeShell(1);
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error:   DCMRemoteCommand: Login failed for host " + this.host.getHostname());
        }
    }

    private synchronized void cmd(String commandParam) {
        String stderror;
        String response = "";
        this.remoteCommandCaller.log("Action:  DCMRemoteCommand: " + this.host.getHostname() + ": sending command: " + commandParam, false, true, true);
        try {
            this.spawn.send(commandParam + "\n");
        }
        catch (IOException ex) {
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error: " + this.host.getHostname() + ": IOException: RemoteCommand.cmd sshConnection.send(commandParam)" + ex.getMessage());
        }
        try {
            this.spawn.expect(this.customPromptFlat, (long)this.sessionTimeout);
        }
        catch (IOException ex) {
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error: " + this.host.getHostname() + ":IOException: RemoteCommand.cmd sshConnection.expect(\"" + this.customPromptFlat + "\"," + this.sessionTimeout + ")" + ex.getMessage());
        }
        catch (TimeoutException ex) {
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error: " + this.host.getHostname() + ":TimeoutException: RemoteCommand.cmd sshConnection.expect(\"" + this.customPromptFlat + "\"," + this.sessionTimeout + ")" + ex.getMessage());
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        String stdout = this.spawn.getCurrentStandardOutContents();
        if (stdout == null) {
            stdout = "-";
        }
        if ((stderror = this.spawn.getCurrentStandardErrContents()) == null) {
            stderror = "-";
        }
        if (this.debugging) {
            this.remoteCommandCaller.log("STDOUT: " + this.host.getHostname() + ": " + stdout, true, true, true);
            this.remoteCommandCaller.log("STDERR: " + this.host.getHostname() + ": " + stderror, true, true, true);
        }
        if (this.finalCommand) {
            this.closeShell(0);
            this.remoteCommandCaller.remoteFinalCommandSuccessResponse(this.stage, stdout, stderror);
        } else {
            this.closeShell(0);
            this.remoteCommandCaller.remoteCommandSuccessResponse(this.stage, stdout, stderror);
        }
    }

    private synchronized void supasswd(String superuserPasswordParam) {
        String response = "";
        boolean suSuccessful = false;
        this.remoteCommandCaller.log("Action:  DCMRemoteCommand: " + this.host.getHostname() + ": sending su", false, true, true);
        try {
            this.spawn.send("su\n");
        }
        catch (IOException ex) {
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error: " + this.host.getHostname() + ": IOException: RemoteCommand.supasswd: sshConnection.send(su)" + ex.getMessage());
        }
        try {
            this.spawn.expect("Password", 2L);
        }
        catch (IOException ex) {
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, ex.getMessage());
        }
        catch (TimeoutException ex) {
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, ex.getMessage());
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        response = this.spawn.getCurrentStandardOutContents();
        if (response.contains("Password")) {
            this.remoteCommandCaller.log("\nSuccess: DCMRemoteCommand: " + this.host.getHostname() + ": Password matched", false, true, true);
            if (this.debugging) {
                this.remoteCommandCaller.log("Action:  DCMRemoteCommand: " + this.host.getHostname() + ": sending password: " + this.host.getSuperuserPassword(), false, true, true);
            } else {
                this.remoteCommandCaller.log("Action:  DCMRemoteCommand: " + this.host.getHostname() + ": sending password: " + superuserPasswordParam.replaceAll(".", "*"), false, true, true);
            }
            try {
                this.spawn.send(superuserPasswordParam + "\r\n");
            }
            catch (IOException ex) {
                this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error: " + this.host.getHostname() + ": IOException: RemoteCommand.supasswd sshConnection.send(superuserPassword)" + ex.getMessage());
            }
            try {
                this.spawn.expect(this.superuserPromptFlat, (long)this.sessionTimeout);
            }
            catch (IOException ex) {
                this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error:   DCMRemoteCommand: " + this.host.getHostname() + ": IOException: RemoteCommand.supasswd sshConnection.expect(\"" + this.superuserPromptFlat + "\"," + this.sessionTimeout + ")" + ex.getMessage());
            }
            catch (TimeoutException ex) {
                this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error:   DCMRemoteCommand: " + this.host.getHostname() + ": TimeoutException: RemoteCommand.supasswd sshConnection.expect(\"" + this.superuserPromptFlat + "\"," + this.sessionTimeout + ")" + ex.getMessage());
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            response = this.spawn.getCurrentStandardOutContents();
            if (response.contains(this.superuserPromptFlat)) {
                suSuccessful = true;
                this.remoteCommandCaller.log("\nSuccess: DCMRemoteCommand: " + this.host.getHostname() + ": su successful", false, true, true);
                this.remoteCommandCaller.log("Action:  DCMRemoteCommand: " + this.host.getHostname() + ": jumping to cmd", false, true, true);
            } else if (response.contains("incorrect")) {
                suSuccessful = false;
                this.closeShell(1);
                this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "incorrect password: " + response);
            } else if (response.contains("Sorry")) {
                suSuccessful = false;
                this.closeShell(1);
                this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "su was Sorry: " + response);
            } else {
                suSuccessful = false;
                this.closeShell(1);
                this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error:   DCMRemoteCommand: Unexpected response after superuser password: " + response);
            }
        } else {
            suSuccessful = false;
            this.closeShell(1);
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error:   DCMRemoteCommand: No Password response after invoking su: " + response);
        }
        if (suSuccessful) {
            this.cmd(this.command.toString());
        } else {
            this.closeShell(1);
            this.remoteCommandCaller.remoteCommandFailureResponse(this.stage, "Error:   DCMRemoteCommand: su login failed");
        }
    }

    public synchronized String getCommandOutput() {
        return this.spawn.getCurrentStandardOutContents();
    }

    private synchronized void closeShell(int exitCode) {
        this.remoteCommandCaller.log("Action:  DCMRemoteCommand: " + this.host.getHostname() + ": Closing Session with exit code: " + exitCode, true, true, true);
        if (this.spawn != null && !this.spawn.isClosed()) {
            try {
                this.spawn.expectClose(1L);
            }
            catch (ExpectJException ex) {
                this.remoteCommandCaller.log("Error:   DCMRemoteCommand: " + this.host.getHostname() + ": ExpectJException: spawn.expectClose(1)" + ex.getMessage(), true, true, true);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        if (this.spawn != null && !this.spawn.isClosed()) {
            this.spawn.stop();
        }
        if (this.customChannel) {
            // empty if block
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
            if (!this.session.isConnected()) {
                this.remoteCommandCaller.log("Success: DCMRemoteCommand: Session Closed Successfully.", true, true, true);
            } else {
                this.remoteCommandCaller.log("Error:   DCMRemoteCommand: Session dit NOT Close!", true, true, true);
            }
        }
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
            if (!this.channel.isConnected()) {
                this.remoteCommandCaller.log("Success: DCMRemoteCommand: Channel Closed Successfully.", true, true, true);
            } else {
                this.remoteCommandCaller.log("Error:   DCMRemoteCommand: Channel dit NOT Close!", true, true, true);
            }
        }
        if (this.spawn != null) {
            if (this.spawn.isClosed()) {
                this.remoteCommandCaller.log("Success: DCMRemoteCommand: Spawner Closed Successfully.", true, true, true);
            } else {
                this.remoteCommandCaller.log("Error:   DCMRemoteCommand: Spawner did NOT Close!", true, true, true);
            }
        }
    }
}

