/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.layout.GroupLayout;

public class DCMSendMessage
extends JFrame {
    private DCMVergunning dcmVergunning;
    private String subject;
    private String message;
    private DCMSendMessage ref;
    private boolean sloganWaitWarningBlinking = false;
    private final String dcmFirsttimePassedFile;
    private JButton agreeButton;
    private JButton disagreeButton;
    private JLabel explanationLabel;
    private JPanel helpdeskPanel;
    private JLabel mainLabel;
    private JEditorPane messagePane;
    private JScrollPane messageScroller;
    private JTextField subjectField;
    private JLabel subjectLabel;

    public DCMSendMessage() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        this.initComponents();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        int posX = Math.round(screenDim.width / 2 - winWidth / 2);
        int posY = Math.round(screenDim.height / 2 - winHeight / 2);
        this.setLocation(posX, posY);
        this.dcmVergunning = new DCMVergunning(false);
        this.subject = DCMLicense.getProcuct() + " " + DCMLicense.getVersion() + " Runtime Environment";
        this.message = "Runtime Environment: " + this.dcmVergunning.getVergunningPeriod() + " Free " + this.dcmVergunning.getServersInLicense() + " Server License.\n\n";
        ArrayList<String[]> staticPropertiesList = this.getJVMStaticPropertiesList();
        for (String[] propertyArray : staticPropertiesList) {
            this.message = this.message + propertyArray[0] + " " + propertyArray[1] + "\n";
        }
        this.message = this.message + "\n";
        this.message = this.message + "Thank you for your cooperation and enjoy " + DCMLicense.getProcuct() + " " + DCMLicense.getVersion() + "\n\n";
        this.message = this.message + "Kind Regards,\n\n";
        this.message = this.message + "The " + DCMLicense.getProcuct() + " Team\n";
        this.subjectField.setText(this.subject);
        this.messagePane.setText(this.message);
        this.dcmFirsttimePassedFile = ".dcmfirsttimepassed";
        this.ref = this;
    }

    private void initComponents() {
        this.helpdeskPanel = new JPanel();
        this.subjectField = new JTextField();
        this.messageScroller = new JScrollPane();
        this.messagePane = new JEditorPane();
        this.subjectLabel = new JLabel();
        this.mainLabel = new JLabel();
        this.explanationLabel = new JLabel();
        this.agreeButton = new JButton();
        this.disagreeButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent evt) {
                DCMSendMessage.this.formWindowIconified(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("DCMSendMessage");
        this.helpdeskPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("DCMSendMessage.helpdeskPanel.border.title"), 2, 2, new Font("Lucida Grande", 0, 14), new Color(51, 51, 51)));
        this.helpdeskPanel.setFont(this.helpdeskPanel.getFont());
        this.helpdeskPanel.setMaximumSize(new Dimension(500, Short.MAX_VALUE));
        this.helpdeskPanel.setPreferredSize(new Dimension(400, 424));
        this.helpdeskPanel.setSize(new Dimension(600, 0));
        this.subjectField.setFont(new Font("Courier New", 0, 12));
        this.subjectField.setForeground(new Color(102, 102, 102));
        this.subjectField.setToolTipText(bundle.getString("DCMSendMessage.subjectField.toolTipText"));
        this.messagePane.setFont(new Font("Courier New", 0, 10));
        this.messagePane.setForeground(new Color(102, 102, 102));
        this.messageScroller.setViewportView(this.messagePane);
        this.subjectLabel.setFont(this.subjectLabel.getFont().deriveFont((float)this.subjectLabel.getFont().getSize() - 2.0f));
        this.subjectLabel.setForeground(new Color(102, 102, 102));
        this.subjectLabel.setHorizontalAlignment(0);
        this.subjectLabel.setText(bundle.getString("DCMSendMessage.subjectLabel.text"));
        GroupLayout helpdeskPanelLayout = new GroupLayout((Container)this.helpdeskPanel);
        this.helpdeskPanel.setLayout((LayoutManager)helpdeskPanelLayout);
        helpdeskPanelLayout.setHorizontalGroup((GroupLayout.Group)helpdeskPanelLayout.createParallelGroup(1).add((GroupLayout.Group)helpdeskPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)helpdeskPanelLayout.createParallelGroup(1).add((Component)this.messageScroller).add((GroupLayout.Group)helpdeskPanelLayout.createSequentialGroup().add((Component)this.subjectLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.subjectField, -2, 594, -2))).addContainerGap()));
        helpdeskPanelLayout.setVerticalGroup((GroupLayout.Group)helpdeskPanelLayout.createParallelGroup(1).add((GroupLayout.Group)helpdeskPanelLayout.createSequentialGroup().add((GroupLayout.Group)helpdeskPanelLayout.createParallelGroup(3).add((Component)this.subjectField, -2, -1, -2).add((Component)this.subjectLabel)).addPreferredGap(0).add((Component)this.messageScroller, -1, 316, Short.MAX_VALUE).addContainerGap()));
        this.mainLabel.setBackground(new Color(102, 102, 102));
        this.mainLabel.setFont(this.mainLabel.getFont().deriveFont((float)this.mainLabel.getFont().getSize() + 10.0f));
        this.mainLabel.setForeground(new Color(204, 204, 204));
        this.mainLabel.setHorizontalAlignment(0);
        this.mainLabel.setText(bundle.getString("DCMSendMessage.mainLabel.text"));
        this.mainLabel.setOpaque(true);
        this.explanationLabel.setFont(this.explanationLabel.getFont());
        this.explanationLabel.setHorizontalAlignment(0);
        this.explanationLabel.setText(bundle.getString("DCMSendMessage.explanationLabel.text"));
        this.explanationLabel.setVerticalAlignment(1);
        this.explanationLabel.setHorizontalTextPosition(2);
        this.explanationLabel.setVerticalTextPosition(1);
        this.agreeButton.setText(bundle.getString("DCMSendMessage.agreeButton.text"));
        this.agreeButton.setToolTipText(bundle.getString("DCMSendMessage.agreeButton.toolTipText"));
        this.agreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMSendMessage.this.agreeButtonActionPerformed(evt);
            }
        });
        this.disagreeButton.setText(bundle.getString("DCMSendMessage.disagreeButton.text"));
        this.disagreeButton.setToolTipText(bundle.getString("DCMSendMessage.disagreeButton.toolTipText"));
        this.disagreeButton.setFocusable(false);
        this.disagreeButton.setHorizontalTextPosition(0);
        this.disagreeButton.setVerticalTextPosition(3);
        this.disagreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMSendMessage.this.disagreeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.helpdeskPanel, -1, 692, Short.MAX_VALUE).add((Component)this.explanationLabel, -2, 0, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(188, 188, 188).add((Component)this.agreeButton, -2, 166, -2).addPreferredGap(0).add((Component)this.disagreeButton).add(0, 0, Short.MAX_VALUE))).addContainerGap()).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.mainLabel, -1, 692, Short.MAX_VALUE).addContainerGap())));
        layout.linkSize(new Component[]{this.agreeButton, this.disagreeButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(48, 48, 48).add((Component)this.explanationLabel, -2, 47, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.agreeButton).add((Component)this.disagreeButton)).addPreferredGap(0).add((Component)this.helpdeskPanel, -1, 383, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.mainLabel, -2, 34, -2).addContainerGap(485, Short.MAX_VALUE))));
        layout.linkSize(new Component[]{this.agreeButton, this.disagreeButton}, 2);
        this.pack();
    }

    private void blinkLabel(final String message, final int blinkRepeats) {
        Thread blinkLabelThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!DCMSendMessage.this.sloganWaitWarningBlinking) {
                    DCMSendMessage.this.sloganWaitWarningBlinking = true;
                    for (int i = 1; i < blinkRepeats; ++i) {
                        DCMSendMessage.this.mainLabel.setText(message + " please wait...");
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        DCMSendMessage.this.mainLabel.setText("");
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DCMSendMessage.this.mainLabel.setText(message + " please wait...");
                    DCMSendMessage.this.sloganWaitWarningBlinking = false;
                }
            }
        });
        blinkLabelThread.setName("blinkLabelThread");
        blinkLabelThread.setDaemon(false);
        blinkLabelThread.setPriority(5);
        blinkLabelThread.start();
    }

    private void agreeButtonActionPerformed(ActionEvent evt) {
        Thread messThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMSendMessage.this.agreeButton.setEnabled(false);
                DCMSendMessage.this.disagreeButton.setEnabled(false);
                DCMSendMessage.this.mainLabel.setText("Thank you!");
                DCMSendMessage.this.blinkLabel("Sending message", 5);
                new DCMFileWrite(DCMSendMessage.this.dcmFirsttimePassedFile, "");
                new DCMSendMailTLS(DCMSendMessage.this.subject, DCMSendMessage.this.message);
                DCMSendMessage.this.explanationLabel.setText("Sending message finished!");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DCMSendMessage.this.setState(2);
                DCMSendMessage.this.setDefaultCloseOperation(2);
                DCMSendMessage.this.setVisible(false);
                DCMSendMessage.this.ref.dispose();
            }
        });
        messThread.setName("messThread");
        messThread.setDaemon(false);
        messThread.setPriority(5);
        messThread.start();
        try {
            messThread.wait(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setVisible(false);
    }

    private ArrayList<String[]> getJVMStaticPropertiesList() {
        ArrayList<String[]> staticPropertiesList = new ArrayList<String[]>();
        staticPropertiesList.add(new String[]{"Property", "Value"});
        staticPropertiesList.add(new String[]{"architecture", System.getProperty("sun.arch.data.model")});
        staticPropertiesList.add(new String[]{"cpu.endian", System.getProperty("sun.cpu.endian")});
        staticPropertiesList.add(new String[]{"os.arch", System.getProperty("os.arch")});
        staticPropertiesList.add(new String[]{"os.name", System.getProperty("os.name")});
        staticPropertiesList.add(new String[]{"os.version", System.getProperty("os.version")});
        staticPropertiesList.add(new String[]{"user.country", System.getProperty("user.country")});
        staticPropertiesList.add(new String[]{"user.language", System.getProperty("user.language")});
        staticPropertiesList.add(new String[]{"java.vendor", System.getProperty("java.vendor")});
        staticPropertiesList.add(new String[]{"java.version", System.getProperty("java.version")});
        staticPropertiesList.add(new String[]{"class.version", System.getProperty("java.class.version")});
        staticPropertiesList.add(new String[]{"DCM Version", DCMLicense.getVersion()});
        staticPropertiesList.add(new String[]{"heap max", Long.toString(Runtime.getRuntime().maxMemory() / 0x100000L) + " MB"});
        staticPropertiesList.add(new String[]{"heap tot", Long.toString(Runtime.getRuntime().totalMemory() / 0x100000L) + " MB"});
        staticPropertiesList.add(new String[]{"heap free", Long.toString(Runtime.getRuntime().freeMemory() / 0x100000L) + " MB"});
        return staticPropertiesList;
    }

    private void disagreeButtonActionPerformed(ActionEvent evt) {
        Thread messThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMSendMessage.this.agreeButton.setEnabled(false);
                DCMSendMessage.this.disagreeButton.setEnabled(false);
                DCMSendMessage.this.mainLabel.setText("We respect your choice!");
                DCMSendMessage.this.explanationLabel.setText("Message delete and canceled!");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DCMSendMessage.this.subjectField.setText("");
                DCMSendMessage.this.messagePane.setText("");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        messThread.setName("messThread");
        messThread.setDaemon(false);
        messThread.setPriority(5);
        messThread.start();
    }

    private void formWindowIconified(WindowEvent evt) {
        Thread minimizeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        });
        minimizeThread.setName("minimizeThread");
        minimizeThread.setDaemon(false);
        minimizeThread.setPriority(5);
        minimizeThread.start();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DCMSendMessage().setVisible(true);
            }
        });
    }
}

