/*
 * Decompiled with CFR 0.152.
 */
import data.Configuration;
import data.ConfigurationCaller;
import data.DCMPreset;
import data.DCMUser;
import data.Host;
import data.RMIMessage;
import data.Resource;
import data.Server;
import data.ValueLimits;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

public class DCMServer
extends UnicastRemoteObject
implements Serializable,
DCMInventoryServerServerCaller,
DCMDBClientCaller,
ConfigurationCaller,
DCMPollServerCaller,
DCMPushPollScriptCaller,
DCMServerRMI,
DCMRemoteCommandCaller {
    int rmiport = 20000;
    String rmiserver;
    static Registry rmiregistry;
    String host;
    String user;
    String userPassword;
    String superuserPassword = null;
    String serversListArray;
    Server inventoryServer;
    Server pollerServer;
    String command;
    String tmpOutput;
    String output;
    String data;
    int port = 22;
    int retentionTime = 1;
    int sessionTimeout = 5;
    int serverInstance = 0;
    int serverInstanceCounter = 0;
    DCMInventoryServerServer inventoryServerServer;
    DCMPollServer poller;
    DCMInventoryServerCaller inventoryCaller;
    ConfigurationCaller configurationCaller;
    private final Configuration configuration;
    private DCMDBClient dcmDBClient;
    private Thread dcmDBClientThread;
    private boolean dcmMetaDBClientIsRead = false;
    private boolean trendIsViewable = true;
    private DCMServer dcmServerReference;
    public static final int SECOND = 1;
    public static final int MINUTE = 60;
    public static final int HOUR = 3600;
    public static final int DAY = 86400;
    private boolean runThreadsAsDaemons = true;
    private DCMShell shell;
    protected Calendar startCalendar;
    protected Calendar endCalendar;
    protected boolean manualValueMode = false;
    protected ValueLimits valueLimits;
    private DCMVergunningServer dcmVergunningServer;
    private Calendar vergunningEndCalendar;
    protected float lineType = 2.0f;
    protected int imageWidth;
    protected int imageHeight;
    boolean mousePressed = false;
    private final int imageEdgeX = 82;
    private final int viewEdgeY = 30;
    private ImageIcon imageIcon;
    private ArrayList<RMIMessage> rmiMessageList;
    private boolean daemon = false;
    private boolean debug = false;
    private DCMSysMonitor sysmon;
    private String logDateString;
    private Calendar currentTimeCalendar;
    private static final String THISPRODUCT = "DCMServer";
    private FileWriter logFileWriter;
    private String logFileString;
    private String logBuffer = "";
    private DCMRemoteCommandCaller dcmRemoteCommandCaller;

    public DCMServer(int rmiportParam, boolean daemonParam, boolean debugParam) throws RemoteException, MalformedURLException {
        this.daemon = daemonParam;
        this.debug = debugParam;
        if (!this.debug) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FilteredStream filteredStream = new FilteredStream(byteArrayOutputStream);
            PrintStream aPrintStream = new PrintStream(filteredStream);
            System.setOut(aPrintStream);
            System.setErr(aPrintStream);
        } else {
            System.out.println("DCMServer debugging enabled...");
        }
        if (!this.daemon) {
            JFrame jframe = new JFrame(THISPRODUCT);
            jframe.setState(1);
            jframe.setDefaultCloseOperation(3);
            jframe.setVisible(true);
        }
        this.rmiport = rmiportParam;
        this.rmiMessageList = new ArrayList();
        try {
            this.rmiserver = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException ex) {
            System.out.println("Error: Server(): UnknownHostException InetAddress.getLocalHost() " + ex.getMessage());
        }
        try {
            rmiregistry = LocateRegistry.createRegistry(this.rmiport);
        }
        catch (RemoteException ex) {
            System.out.println("Error: Server(): RemoteException: LocateRegistry.createRegistry(port); " + ex.getMessage());
        }
        try {
            rmiregistry.rebind("ServerRMI", this);
        }
        catch (RemoteException ex) {
            System.out.println("Error: Server(): RemoteException: registry.rebind(\"rmiServer\", this); " + ex.getMessage());
        }
        this.dcmServerReference = this;
        this.configurationCaller = this;
        this.dcmRemoteCommandCaller = this;
        this.configuration = new Configuration(this.configurationCaller);
        this.currentTimeCalendar = Calendar.getInstance();
        this.logDateString = "" + String.format("%04d", this.currentTimeCalendar.get(1)) + String.format("%02d", this.currentTimeCalendar.get(2) + 1) + String.format("%02d", this.currentTimeCalendar.get(5)) + "_" + String.format("%02d", this.currentTimeCalendar.get(11)) + String.format("%02d", this.currentTimeCalendar.get(12)) + String.format("%02d", this.currentTimeCalendar.get(13));
        this.logFileString = this.configuration.getLogDir() + this.logDateString + "_" + THISPRODUCT + ".log";
        try {
            this.dcmDBClientThread = new DCMDBClient(this.dcmServerReference, this.configuration.getJavaDB(), this.daemon, this.debug);
        }
        catch (SQLException ex) {
            this.inventoryCaller.log("InventoryGUI: SQLException", true, true, true);
        }
        catch (ClassNotFoundException ex) {
            this.inventoryCaller.log("InventoryGUI: ClassNotFoundException: " + ex.getMessage(), true, true, true);
        }
        catch (InstantiationException ex) {
            this.inventoryCaller.log("InventoryGUI: InstantiationException: " + ex.getMessage(), true, true, true);
        }
        catch (IllegalAccessException ex) {
            this.inventoryCaller.log("InventoryGUI: IllegalAccessException: " + ex.getMessage(), true, true, true);
        }
        catch (NoSuchMethodException ex) {
            this.inventoryCaller.log("InventoryGUI: NoSuchMethodException: " + ex.getMessage(), true, true, true);
        }
        catch (InvocationTargetException ex) {
            this.inventoryCaller.log("InventoryGUI: InvocationTargetException: " + ex.getMessage(), true, true, true);
        }
        catch (Exception ex) {
            this.inventoryCaller.log("InventoryGUI: Exception: " + ex.getMessage(), true, true, true);
        }
        this.dcmDBClientThread.setName("dcmMetaDBClientThread");
        this.dcmDBClientThread.setDaemon(false);
        this.dcmDBClientThread.setPriority(5);
        this.dcmDBClientThread.start();
        this.dcmDBClient = (DCMDBClient)this.dcmDBClientThread;
        while (!this.dcmMetaDBClientIsRead) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.shell = new DCMShell(this.debug);
        this.startCalendar = Calendar.getInstance();
        this.startCalendar.setTimeInMillis(Calendar.getInstance().getTimeInMillis() - 86400000L);
        this.endCalendar = Calendar.getInstance();
        this.valueLimits = new ValueLimits();
        this.dcmVergunningServer = new DCMVergunningServer(this.dcmServerReference, this.debug);
        this.dcmVergunningServer.controleerVergunning();
        this.sysmon = new DCMSysMonitor();
        this.vergunningDoorvoeren();
    }

    @Override
    public boolean authenticate(String usernameParam, String passwordParam) throws RemoteException {
        boolean authenticated = false;
        authenticated = this.dcmDBClient.authenticateDCMUser(usernameParam, passwordParam);
        return authenticated;
    }

    @Override
    public DCMUser getDCMUserByUsername(String usernameParam) throws RemoteException {
        DCMUser dcmUser = this.dcmDBClient.getDCMUserByUsername(usernameParam);
        return dcmUser;
    }

    @Override
    public void exportInventory() {
        this.dcmDBClient.exportInventory();
    }

    @Override
    public void importInventory() {
        this.dcmDBClient.importInventory();
    }

    @Override
    public ArrayList<RMIMessage> addDCMUser(DCMUser userParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        this.dcmDBClient.insertDCMUser(userParam);
        return this.rmiMessageList;
    }

    @Override
    public ArrayList<RMIMessage> updateDCMUser(DCMUser userParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        this.dcmDBClient.updateDCMUser(userParam);
        return this.rmiMessageList;
    }

    @Override
    public ArrayList<RMIMessage> deleteDCMUser(long idParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        this.dcmDBClient.deleteDCMUser(idParam);
        return this.rmiMessageList;
    }

    @Override
    public DCMUser getDCMUser(long idParam) {
        DCMUser dcmUser = new DCMUser();
        dcmUser = this.dcmDBClient.getDCMUser(idParam);
        return dcmUser;
    }

    @Override
    public ArrayList<DCMUser> getDCMUserList() {
        ArrayList<DCMUser> dcmUserList = this.dcmDBClient.getDCMUserList();
        return dcmUserList;
    }

    @Override
    public ArrayList<RMIMessage> insertDCMPreset(DCMPreset viewParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        this.dcmDBClient.insertDCMPreset(viewParam);
        return this.rmiMessageList;
    }

    @Override
    public ArrayList<RMIMessage> updateDCMPreset(DCMPreset viewParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        this.dcmDBClient.updateDCMPreset(viewParam);
        return this.rmiMessageList;
    }

    @Override
    public ArrayList<RMIMessage> deleteDCMPreset(DCMPreset viewParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        this.dcmDBClient.deleteDCMPreset(viewParam.getId());
        return this.rmiMessageList;
    }

    @Override
    public DCMPreset getDCMPreset(long idParam) {
        DCMPreset DCMPreset2 = new DCMPreset();
        DCMPreset2 = this.dcmDBClient.getDCMPreset(idParam);
        return DCMPreset2;
    }

    @Override
    public ArrayList<DCMPreset> getDCMPresetList() {
        ArrayList<DCMPreset> DCMPresetList = this.dcmDBClient.getDCMPresetList();
        return DCMPresetList;
    }

    @Override
    public ArrayList<String[]> getJVMStaticPropertiesList() {
        ArrayList<String[]> staticPropertiesList = new ArrayList<String[]>();
        staticPropertiesList.add(new String[]{"Property", "Server"});
        staticPropertiesList.add(new String[]{"architecture", System.getProperty("sun.arch.data.model")});
        staticPropertiesList.add(new String[]{"cpu.endian", System.getProperty("sun.cpu.endian")});
        staticPropertiesList.add(new String[]{"os.arch", System.getProperty("os.arch")});
        staticPropertiesList.add(new String[]{"os.name", System.getProperty("os.name")});
        staticPropertiesList.add(new String[]{"os.version", System.getProperty("os.version")});
        staticPropertiesList.add(new String[]{"user.country", System.getProperty("user.country")});
        staticPropertiesList.add(new String[]{"user.language", System.getProperty("user.language")});
        staticPropertiesList.add(new String[]{"java.vendor", System.getProperty("java.vendor")});
        staticPropertiesList.add(new String[]{"java.version", System.getProperty("java.version")});
        staticPropertiesList.add(new String[]{"class.version", System.getProperty("java.class.version")});
        staticPropertiesList.add(new String[]{"DCM Version", DCMLicense.getVersion()});
        staticPropertiesList.add(new String[]{"heap max", Long.toString(Runtime.getRuntime().maxMemory() / 0x100000L) + " MB"});
        staticPropertiesList.add(new String[]{"heap tot", Long.toString(Runtime.getRuntime().totalMemory() / 0x100000L) + " MB"});
        staticPropertiesList.add(new String[]{"heap free", Long.toString(Runtime.getRuntime().freeMemory() / 0x100000L) + " MB"});
        staticPropertiesList.add(new String[]{"Threads", Long.toString(Thread.activeCount())});
        staticPropertiesList.add(new String[]{"CPU", Integer.toString(this.sysmon.getProcessTime()) + "%"});
        return staticPropertiesList;
    }

    @Override
    public ArrayList<String[]> getJVMDynamicPropertiesList() {
        ArrayList<String[]> dynamicPropertiesList = new ArrayList<String[]>();
        dynamicPropertiesList.add(new String[]{"heap max", Long.toString(Runtime.getRuntime().maxMemory() / 0x100000L) + " MB"});
        dynamicPropertiesList.add(new String[]{"heap tot", Long.toString(Runtime.getRuntime().totalMemory() / 0x100000L) + " MB"});
        dynamicPropertiesList.add(new String[]{"heap free", Long.toString(Runtime.getRuntime().freeMemory() / 0x100000L) + " MB"});
        dynamicPropertiesList.add(new String[]{"Threads", Long.toString(Thread.activeCount())});
        dynamicPropertiesList.add(new String[]{"CPU", Integer.toString(this.sysmon.getProcessTime()) + "%"});
        return dynamicPropertiesList;
    }

    @Override
    public synchronized ArrayList<RMIMessage> inventoryServer(long instanceParam, Host hostParam, int retentionTimeParam, int timeoutParam, int retryMaxParam, boolean debugParam) {
        boolean succeeded = false;
        this.rmiMessageList.clear();
        this.rmiMessageList.add(new RMIMessage("Log", "DCManagerServer.inventoryServer(instance,host)", "\nAction:  DCMServer: Server inventory initiated for server: " + hostParam.getHostname() + ", please wait...", true));
        this.log("\nAction:  DCMServer: Server inventory initiated for server: " + hostParam.getHostname() + ", please wait...", true, true, true);
        if (this.dcmDBClient.getHostCount() < this.dcmVergunningServer.getServersInLicense()) {
            new DCMInventoryServerServer(this.dcmServerReference, instanceParam, hostParam, retentionTimeParam, timeoutParam, retryMaxParam, this.daemon, this.debug);
        } else {
            this.rmiMessageList.add(new RMIMessage("Log", "DCManagerServer.inventoryServer(instance,host)", "Server Limit Reached! Click [Admin] Tab to increase number of Servers.", true));
            this.log("Server Limit Reached! Click [Admin] Tab to increase number of Servers.", true, true, true);
        }
        return this.rmiMessageList;
    }

    @Override
    public synchronized int getHostCount() {
        return this.dcmDBClient.getHostCount();
    }

    @Override
    public synchronized int getResourceCount() {
        return this.dcmDBClient.getResourceCount();
    }

    @Override
    public synchronized ArrayList<RMIMessage> deleteServer(Server serverParam, boolean deleteArchivesParam) {
        boolean archivesSuccessfullyDeleted = true;
        boolean serverSuccessfullyDeleted = true;
        this.log("Server deletion initiated for server: " + serverParam.getHost().getHostname() + ", please wait...", true, true, true);
        this.rmiMessageList.clear();
        this.rmiMessageList.add(new RMIMessage("Log", "DCManagerServer.deleteServer(server,deleteArchives)", "Server deletion initiated, please wait...", true));
        Server server = serverParam;
        if (deleteArchivesParam) {
            File hostArchiveDir = new File(this.configuration.getArchiveDBDir() + server.getHost().getHostname() + this.configuration.getFileSeparator());
            ArrayList archiveFileList = new ArrayList();
            for (File file : hostArchiveDir.listFiles()) {
                if (file.delete()) {
                    this.log("Removed archive file: " + file.getName(), false, false, false);
                    archivesSuccessfullyDeleted = true;
                    continue;
                }
                this.log("Could not remove archive file: " + file.getName(), true, true, true);
                archivesSuccessfullyDeleted = false;
            }
            if (hostArchiveDir.delete()) {
                this.log("Removed archive dir: " + hostArchiveDir.getName(), true, true, true);
                serverSuccessfullyDeleted = true;
            } else {
                this.log("Could not removed archive dir: " + hostArchiveDir.getName(), true, true, true);
                serverSuccessfullyDeleted = false;
            }
        }
        try {
            this.dcmDBClient.deleteServerByHostname(server.getHost().getHostname());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (deleteArchivesParam) {
            if (serverSuccessfullyDeleted && archivesSuccessfullyDeleted) {
                this.log("Server " + server.getHost().getHostname() + " and archives successfully deleted", true, true, true);
            } else if (serverSuccessfullyDeleted && !archivesSuccessfullyDeleted) {
                this.log("Server " + server.getHost().getHostname() + " successfully deleted, but archives might not be fully deleted", true, true, true);
            } else if (!serverSuccessfullyDeleted && archivesSuccessfullyDeleted) {
                this.log("Server " + server.getHost().getHostname() + " NOT successfully deleted, but archives were successfully deleted", true, true, true);
            } else if (!serverSuccessfullyDeleted && !archivesSuccessfullyDeleted) {
                this.log("Server " + server.getHost().getHostname() + " and archives NOT successfully deleted", true, true, true);
            }
        } else if (serverSuccessfullyDeleted) {
            this.log("Server " + server.getHost().getHostname() + " successfully deleted", true, true, true);
        } else if (!serverSuccessfullyDeleted) {
            this.log("Server " + server.getHost().getHostname() + " NOT successfully deleted", true, true, true);
        }
        return this.rmiMessageList;
    }

    @Override
    public synchronized ArrayList<RMIMessage> deleteServers(final boolean deleteArchivesParam) throws CloneNotSupportedException {
        Thread deleteServersThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCMServer.this.rmiMessageList.clear();
                DCMServer.this.rmiMessageList.add(new RMIMessage("Log", "DCManagerServer.deleteServers(deleteArchives)", "Deletion all servers initiated, please wait...", true));
                ArrayList<Object> serverList = new ArrayList();
                try {
                    serverList = DCMServer.this.dcmDBClient.selectServers();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                for (Server server : serverList) {
                    DCMServer.this.deleteServer(server, deleteArchivesParam);
                }
            }
        });
        deleteServersThread.setName("deleteServersThread");
        deleteServersThread.setDaemon(false);
        deleteServersThread.setPriority(5);
        deleteServersThread.start();
        try {
            deleteServersThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.rmiMessageList;
    }

    @Override
    public synchronized ArrayList<RMIMessage> enableHost(final Host hostParam, final boolean enableParam) {
        Thread enableServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String action = "";
                action = enableParam ? "enabled" : "disabled";
                try {
                    DCMServer.this.dcmDBClient.enableHost(hostParam, enableParam);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                DCMServer.this.log("Host: " + hostParam.getHostname() + " " + action + " for Polling.", true, true, true);
                DCMServer.this.rmiMessageList.clear();
                DCMServer.this.rmiMessageList.add(new RMIMessage("Log", "DCManagerServer.enableServer(host,enableParam)", "Host: " + hostParam.getHostname() + " " + action + " for Polling.", true));
            }
        });
        enableServerThread.setName("enableServerThread");
        enableServerThread.setDaemon(false);
        enableServerThread.setPriority(5);
        enableServerThread.start();
        return this.rmiMessageList;
    }

    @Override
    public String searchExactHosts(String searchString, ArrayList<Server> serverList) {
        String thisOutput = "";
        if (searchString.length() > 0) {
            thisOutput = this.dcmDBClient.convertSearchStringToHostsText(searchString, serverList, true);
        }
        return thisOutput;
    }

    @Override
    public String searchNonExactHosts(String searchString, ArrayList<Server> serverList) {
        String thisOutput = "";
        if (searchString.length() > 0) {
            thisOutput = this.dcmDBClient.convertSearchStringToHostsText(searchString, serverList, false);
        }
        return thisOutput;
    }

    @Override
    public String searchExactResources(String searchString, ArrayList<Server> serverList) {
        String thisOutput = "";
        if (searchString.length() > 0) {
            thisOutput = this.dcmDBClient.convertSearchStringToResourcesText(searchString, serverList, true);
        }
        return thisOutput;
    }

    @Override
    public String searchNonExactResources(String searchString, ArrayList<Server> serverList) {
        String thisOutput = "";
        if (searchString.length() > 0) {
            thisOutput = this.dcmDBClient.convertSearchStringToResourcesText(searchString, serverList, false);
        }
        return thisOutput;
    }

    @Override
    public ArrayList<Host> getHostList(String hostLines) {
        ArrayList<String> hostIdList = new ArrayList<String>();
        String[] lineArray = new String[5];
        BufferedReader reader = new BufferedReader(new StringReader(hostLines));
        String line = "";
        String thisOutput = "";
        DCMServer thisRef = this;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 1 || (lineArray = line.split("\\s+"))[0] == null || lineArray[0].length() <= 0) continue;
                hostIdList.add(lineArray[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<Host> hostList = this.dcmDBClient.convertHostsTextToHostsList(hostIdList);
        return hostList;
    }

    @Override
    public String remoteCommand(int cmdStage, Host hostParam, StringBuffer commandParam, boolean finalCommand, int timeoutParam, boolean debug) {
        DCMRemoteCommand dcmRemoteCommand = null;
        try {
            dcmRemoteCommand = new DCMRemoteCommand(this.dcmRemoteCommandCaller, 2, hostParam, commandParam, finalCommand, timeoutParam, debug);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return dcmRemoteCommand.getCommandOutput();
    }

    public String remoteCommand2(int cmdStage, Host hostParam, StringBuffer commandParam, boolean finalCommand, int timeoutParam, boolean debug) {
        DCMRemoteCommand dcmRemoteCommand = null;
        try {
            dcmRemoteCommand = new DCMRemoteCommand(this.dcmRemoteCommandCaller, 2, hostParam, commandParam, finalCommand, timeoutParam, debug);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return dcmRemoteCommand.getCommandOutput();
    }

    @Override
    public void remoteFinalCommandSuccessResponse(int stageParam, String stdOutParam, String stdErrParam) {
    }

    @Override
    public void remoteCommandSuccessResponse(int stageParam, String stdOutParam, String stdErrParam) {
    }

    @Override
    public void remoteCommandFailureResponse(int stageParam, String messageParam) {
    }

    @Override
    public void inventoryReady(Server serverParam) {
    }

    @Override
    public ImageIcon getTrend(ArrayList<Color> lineColorList, int imageWidth, int imageHeight, boolean manualValueMode, Calendar startCalendar, Calendar endCalendar, ValueLimits valueLimits, String selectedResources, Float lineType) throws CloneNotSupportedException {
        ArrayList<String> resourceIdList = new ArrayList<String>();
        String[] lineArray = new String[5];
        BufferedReader reader = new BufferedReader(new StringReader(selectedResources));
        String line = "";
        this.output = "";
        DCMServer thisRef = this;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 1 || (lineArray = line.split("\\s+"))[0] == null || lineArray[0].length() <= 0) continue;
                resourceIdList.add(lineArray[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<Resource> resourceList = this.dcmDBClient.convertResourcesTextToResources(resourceIdList);
        String rrdFile = "";
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageHeight, 1);
        RrdGraphDef rrdGraphDef = new RrdGraphDef();
        RrdGraph rrdGraph = null;
        int colorCounter = 0;
        for (Resource resource : resourceList) {
            String resourceHost = this.dcmDBClient.selectHost(resource.getHostId()).getHostname();
            rrdFile = this.configuration.getArchiveDBDir() + resourceHost + this.configuration.getFileSeparator() + resource.getRRDFile();
            rrdGraphDef.datasource(resource.getId() + resource.getResource(), rrdFile, resource.getResource(), "AVERAGE");
            rrdGraphDef.line(resource.getId() + resource.getResource(), (Paint)lineColorList.get(colorCounter), resourceHost + " " + resource.getResourceType() + " " + resource.getResource(), lineType.floatValue());
            ++colorCounter;
        }
        rrdGraphDef.setStartTime(Long.valueOf(startCalendar.getTimeInMillis()) / 1000L);
        rrdGraphDef.setEndTime(Long.valueOf(endCalendar.getTimeInMillis()) / 1000L);
        rrdGraphDef.setVerticalLabel(resourceList.get(0).getValueType());
        rrdGraphDef.setAltAutoscale(true);
        rrdGraphDef.setWidth(imageWidth - 82);
        rrdGraphDef.setHeight(imageHeight - 30);
        rrdGraphDef.setImageFormat("png");
        rrdGraphDef.setImageInfo(DCMLicense.getProcuct() + " " + DCMLicense.getVersion() + " Trend Analysis");
        rrdGraphDef.setTitle(DCMLicense.getProcuct() + " " + resourceList.get(0).getCategory() + " Trend. Period: [" + DCMTools.getHumanDateLong(startCalendar) + "] - [" + DCMTools.getHumanDateLong(endCalendar) + "]");
        rrdGraphDef.setAntiAliasing(true);
        rrdGraphDef.setRigid(true);
        rrdGraphDef.setSmallFont(new Font("STHeiti", 0, 9));
        rrdGraphDef.setLargeFont(new Font("STHeiti", 0, 11));
        rrdGraphDef.setShowSignature(false);
        rrdGraphDef.setImageQuality(0.0f);
        try {
            rrdGraph = new RrdGraph(rrdGraphDef);
        }
        catch (IOException ex) {
            this.log("Error: IOException: RrdGraph(graphDef)" + ex.getMessage(), true, true, true);
        }
        catch (RrdException ex) {
            this.log("Error: RrdException: RrdGraph(graphDef)" + ex.getMessage(), true, true, true);
        }
        int additionalHeight = rrdGraph.getRrdGraphInfo().getHeight() - (imageHeight - 30);
        rrdGraphDef.setHeight(imageHeight - additionalHeight);
        if (manualValueMode) {
            rrdGraphDef.setMinValue(valueLimits.getMin().doubleValue());
            rrdGraphDef.setMaxValue(valueLimits.getMax().doubleValue());
        }
        rrdGraphDef.setImageQuality(0.5f);
        try {
            rrdGraph = new RrdGraph(rrdGraphDef);
        }
        catch (IOException ex) {
            this.log("Error: IOException: RrdGraph(graphDef)" + ex.getMessage(), true, true, true);
        }
        catch (RrdException ex) {
            this.log("Error: RrdException: RrdGraph(graphDef)" + ex.getMessage(), true, true, true);
        }
        rrdGraph.render(bufferedImage.getGraphics());
        this.imageIcon = new ImageIcon(bufferedImage);
        return this.imageIcon;
    }

    @Override
    public StringBuffer getData(Calendar startCalendar, Calendar endCalendar, String selectedResources) throws CloneNotSupportedException {
        StringBuffer returnData = new StringBuffer();
        ArrayList<String> resourceIdList = new ArrayList<String>();
        String[] lineArray = new String[5];
        BufferedReader reader = new BufferedReader(new StringReader(selectedResources));
        String line = "";
        this.output = "";
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 1 || (lineArray = line.split("\\s+"))[0] == null || lineArray[0].length() <= 0) continue;
                resourceIdList.add(lineArray[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<Resource> resourceList = this.dcmDBClient.convertResourcesTextToResources(resourceIdList);
        RrdDb rrdDb = null;
        FetchRequest fetchRequest = null;
        FetchData fetchData = null;
        ArrayList valueList = new ArrayList();
        Host thisHost = new Host();
        for (Resource resource : resourceList) {
            thisHost = new Host();
            try {
                thisHost = (Host)this.dcmDBClient.selectHost(resource.getHostId()).clone();
            }
            catch (CloneNotSupportedException ex) {
                this.log("Error: CloneNotSupportedException: selectHost(resource.getHostId())" + ex.getMessage(), true, true, true);
            }
            returnData.append("Hostname: ").append(thisHost.getHostname()).append(" Category: ").append(resource.getCategory()).append(" Resource: ").append(resource.getResource()).append(" Archive: ").append(resource.getRRDFile()).append("\n\n");
            String rrdFetchFile = this.configuration.getArchiveDBDir() + thisHost.getHostname() + this.configuration.getFileSeparator() + resource.getRRDFile();
            try {
                rrdDb = new RrdDb(rrdFetchFile);
            }
            catch (IOException ex) {
                this.log("Error: IOException: rrdDb = new RrdDb(rrdFile)" + ex.getMessage(), true, true, true);
            }
            catch (RrdException ex) {
                this.log("Error: RrdException: rrdDb = new RrdDb(rrdFile)" + ex.getMessage(), true, true, true);
            }
            try {
                fetchRequest = rrdDb.createFetchRequest("AVERAGE", Long.valueOf(startCalendar.getTimeInMillis()) / 1000L, Long.valueOf(endCalendar.getTimeInMillis()) / 1000L);
            }
            catch (RrdException ex) {
                this.log("Error: RrdException: rrdDb.createFetchRequest(\"AVERAGE\"" + ex.getMessage(), true, true, true);
            }
            try {
                fetchData = fetchRequest.fetchData();
            }
            catch (RrdException ex) {
                this.log("Error: RrdException: fetchRequest.fetchData()" + ex.getMessage(), true, true, true);
            }
            catch (IOException ex) {
                this.log("Error: IOException: fetchRequest.fetchData()" + ex.getMessage(), true, true, true);
            }
            returnData.append(fetchData.dump());
            try {
                rrdDb.close();
            }
            catch (IOException ex) {
                this.log("Error: IOException: rrdDb.close()" + ex.getMessage(), true, true, true);
            }
        }
        return returnData;
    }

    @Override
    public ValueLimits manualValueMode(Calendar startCalendar, Calendar endCalendar, String selectedResources) {
        ValueLimits theseValueLimits = new ValueLimits();
        ArrayList<String> resourceIdList = new ArrayList<String>();
        ArrayList<Object> resourceList = new ArrayList();
        String[] lineArray = new String[5];
        BufferedReader reader = new BufferedReader(new StringReader(selectedResources));
        String line = "";
        this.output = "";
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 1 || (lineArray = line.split("\\s+"))[0] == null || lineArray[0].length() <= 0) continue;
                resourceIdList.add(lineArray[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        resourceList = this.dcmDBClient.convertResourcesTextToResources(resourceIdList);
        RrdDb rrdDb = null;
        FetchRequest fetchRequest = null;
        FetchData fetchData = null;
        ArrayList<Double> valueList = new ArrayList<Double>();
        Host thisHost = new Host();
        for (Resource resource : resourceList) {
            thisHost = new Host();
            try {
                thisHost = (Host)this.dcmDBClient.selectHost(resource.getHostId()).clone();
            }
            catch (CloneNotSupportedException ex) {
                this.log("Error: CloneNotSupportedException: selectHost(resource.getHostId())" + ex.getMessage(), true, true, true);
            }
            String rrdFetchFile = this.configuration.getArchiveDBDir() + thisHost.getHostname() + this.configuration.getFileSeparator() + resource.getRRDFile();
            try {
                rrdDb = new RrdDb(rrdFetchFile);
            }
            catch (IOException ex) {
                this.log("Error: IOException: rrdDb = new RrdDb(rrdFile)" + ex.getMessage(), true, true, true);
            }
            catch (RrdException ex) {
                this.log("Error: RrdException: rrdDb = new RrdDb(rrdFile)" + ex.getMessage(), true, true, true);
            }
            try {
                fetchRequest = rrdDb.createFetchRequest("AVERAGE", Long.valueOf(startCalendar.getTimeInMillis()) / 1000L, Long.valueOf(endCalendar.getTimeInMillis()) / 1000L);
            }
            catch (RrdException ex) {
                this.log("Error: RrdException: rrdDb.createFetchRequest(\"AVERAGE\"" + ex.getMessage(), true, true, true);
            }
            try {
                fetchData = fetchRequest.fetchData();
            }
            catch (RrdException ex) {
                this.log("Error: RrdException: fetchRequest.fetchData()" + ex.getMessage(), true, true, true);
            }
            catch (IOException ex) {
                this.log("Error: IOException: fetchRequest.fetchData()" + ex.getMessage(), true, true, true);
            }
            double[] ex = fetchData.getValues(0);
            int n = ex.length;
            for (int i = 0; i < n; ++i) {
                Double value = ex[i];
                valueList.add(value);
            }
            try {
                rrdDb.close();
            }
            catch (IOException ex2) {
                this.log("Error: IOException: rrdDb.close()" + ex2.getMessage(), true, true, true);
            }
        }
        theseValueLimits.setMin((Double)Double.MAX_VALUE);
        for (Double d : valueList) {
            if (!(theseValueLimits.getMin() > d)) continue;
            theseValueLimits.setMin(d);
        }
        theseValueLimits.setMax((Double)Double.MIN_VALUE);
        for (Double d : valueList) {
            if (!(theseValueLimits.getMax() < d)) continue;
            theseValueLimits.setMax(d);
        }
        return theseValueLimits;
    }

    private void vergunningDoorvoeren() {
        this.dcmVergunningServer = new DCMVergunningServer(this.dcmServerReference, this.debug);
        this.dcmVergunningServer.controleerVergunning();
        this.log("Action:  DCMDesktop: License being Validated", false, true, true);
        this.dcmVergunningServer.controleerVergunning();
        Calendar now = Calendar.getInstance();
        Calendar last = Calendar.getInstance();
        last = this.dcmDBClient.getDCMTijd();
        last.add(5, -1);
        if (now.compareTo(last) < 0) {
            this.dcmVergunningServer.setVergunningValid(false);
            this.dcmVergunningServer.setDefaultServersInLicense();
            this.log("Failure: DCMDesktop: Time issue detected...", true, true, true);
            if (this.debug) {
                this.log("Last: " + DCMTools.getHumanDateLong(last), false, true, true);
                this.log("Now:  " + DCMTools.getHumanDateLong(now), false, true, true);
            }
        } else {
            this.dcmDBClient.updateDCMTijd(now);
        }
        if (this.dcmVergunningServer.isValid()) {
            this.log("Success: DCMDesktop: License Valid", true, true, true);
        } else {
            this.log("Advise:  DCMDesktop: Thank you for using DataCenterManager " + DCMLicense.getVersion(), true, true, true);
            this.log("Advise:  DCMDesktop: This software is licenced under GPL 3 Licence", true, true, true);
        }
    }

    @Override
    public void applyReceiveVergunning(String activationCodeParam, String vergunningCodeParam) {
        this.dcmVergunningServer.setActivationCodeFromFile(activationCodeParam);
        this.dcmVergunningServer.setVergunningCodeFromFile(vergunningCodeParam);
        this.dcmVergunningServer.saveVergunning();
        this.dcmVergunningServer.setVergunningOrderInProgress(false);
        this.dcmVergunningServer.controleerVergunning();
    }

    @Override
    public String[] getAK() {
        return this.dcmVergunningServer.getAK();
    }

    @Override
    public boolean vergunningIsValid() {
        return this.dcmVergunningServer.isValid();
    }

    @Override
    public Calendar getDCMTijd() {
        return this.dcmDBClient.getDCMTijd();
    }

    @Override
    public String getVergunningPeriod() {
        return this.dcmVergunningServer.getVergunningPeriod();
    }

    @Override
    public String getServerVersion() {
        return DCMLicense.getVersion();
    }

    @Override
    public String getVergunningStartDateString() {
        String startDate = String.format("%04d", this.dcmVergunningServer.getVergunningStartDate().get(1)) + "-" + String.format("%02d", this.dcmVergunningServer.getVergunningStartDate().get(2) + 1) + "-" + String.format("%02d", this.dcmVergunningServer.getVergunningStartDate().get(5));
        return startDate;
    }

    @Override
    public String getVergunningEndDateString() {
        String endDate = String.format("%04d", this.dcmVergunningServer.getVergunningEndDate().get(1)) + "-" + String.format("%02d", this.dcmVergunningServer.getVergunningEndDate().get(2) + 1) + "-" + String.format("%02d", this.dcmVergunningServer.getVergunningEndDate().get(5));
        return endDate;
    }

    @Override
    public Calendar getVergunningStartDate() {
        return this.dcmVergunningServer.getVergunningStartDate();
    }

    @Override
    public Calendar getVergunningEndDate() {
        return this.dcmVergunningServer.getVergunningEndDate();
    }

    @Override
    public int getServersInLicense() {
        return this.dcmVergunningServer.getServersInLicense();
    }

    @Override
    public String getActivationCode() {
        return this.dcmVergunningServer.getActivationCodeFromFile();
    }

    @Override
    public String getVergunningCode() {
        return this.dcmVergunningServer.getVergunningCodeFromFile();
    }

    @Override
    public String getVergunningInvalidAdvice() {
        return this.dcmVergunningServer.getVergunningInvalidAdvice();
    }

    @Override
    public String getVergunningInvalidReason() {
        return this.dcmVergunningServer.getVergunningInvalidReason();
    }

    @Override
    public void setVergunningOrderInProgress(boolean inProgress) {
        this.dcmVergunningServer.setVergunningOrderInProgress(inProgress);
    }

    @Override
    public void setVergunningValid(boolean validParam) {
        this.dcmVergunningServer.setVergunningValid(validParam);
    }

    @Override
    public void setDefaultServersInLicense() {
        this.dcmVergunningServer.setDefaultServersInLicense();
    }

    @Override
    public void reloadVergunning() {
        this.dcmVergunningServer = new DCMVergunningServer(this.dcmServerReference, this.debug);
        this.dcmVergunningServer.controleerVergunning();
    }

    @Override
    public void setDCMTijd(Calendar nowParam) {
        this.dcmDBClient.updateDCMTijd(nowParam);
    }

    @Override
    public void setVergunningPeriod(String vergunningPeriodParam) {
        this.dcmVergunningServer.setVergunningPeriod(vergunningPeriodParam);
    }

    @Override
    public void setVergunningStartDate(Calendar startDateParam) {
        this.dcmVergunningServer.setVergunningStartDate(startDateParam);
    }

    @Override
    public void setVergunningEndDate(Calendar endDateParam) {
        this.dcmVergunningServer.setVergunningEndDate(endDateParam);
    }

    @Override
    public void setServersInLicense(int serversInLicenseParam) {
        this.dcmVergunningServer.setServersInLicense(serversInLicenseParam);
    }

    @Override
    public void setActivationCode(String activationCodeParam) {
        this.dcmVergunningServer.setActivationCodeFromFile(activationCodeParam);
    }

    @Override
    public void setVergunningCode(String vergunningCodeParam) {
        this.dcmVergunningServer.setVergunningCodeFromFile(vergunningCodeParam);
    }

    @Override
    public void inventoryReady() {
    }

    @Override
    public ArrayList<Server> getServerList() throws CloneNotSupportedException {
        ArrayList<Server> thisServerList = new ArrayList();
        thisServerList = this.dcmDBClient.selectServers();
        return thisServerList;
    }

    @Override
    public String updateVergunning(int serversInLicenseParam, Calendar selectedDateParam, String vergunningPeriodParam) {
        Calendar thisVergunningStartCalendar = Calendar.getInstance();
        thisVergunningStartCalendar = selectedDateParam;
        Calendar thisVergunningEndCalendar = Calendar.getInstance();
        String[] status = new String[2];
        String activationCodeString = null;
        String activationCodeKeyString = null;
        this.setVergunningOrderInProgress(true);
        this.setServersInLicense(serversInLicenseParam);
        this.setVergunningStartDate(selectedDateParam);
        if (selectedDateParam != null) {
            thisVergunningEndCalendar.setTimeInMillis(thisVergunningStartCalendar.getTimeInMillis());
            if (vergunningPeriodParam.equals("Day")) {
                thisVergunningEndCalendar.add(6, 1);
                this.dcmVergunningServer.setVergunningEndDate(thisVergunningEndCalendar);
                this.dcmVergunningServer.setVergunningPeriod(vergunningPeriodParam);
            } else if (vergunningPeriodParam.equals("Week")) {
                thisVergunningEndCalendar.add(3, 1);
                this.dcmVergunningServer.setVergunningEndDate(thisVergunningEndCalendar);
                this.dcmVergunningServer.setVergunningPeriod(vergunningPeriodParam);
            } else if (vergunningPeriodParam.equals("Month")) {
                thisVergunningEndCalendar.add(2, 1);
                this.dcmVergunningServer.setVergunningEndDate(thisVergunningEndCalendar);
                this.dcmVergunningServer.setVergunningPeriod(vergunningPeriodParam);
            } else if (vergunningPeriodParam.equals("Year")) {
                thisVergunningEndCalendar.add(1, 1);
                this.dcmVergunningServer.setVergunningEndDate(thisVergunningEndCalendar);
                this.dcmVergunningServer.setVergunningPeriod(vergunningPeriodParam);
            } else if (vergunningPeriodParam.equals("Lifetime")) {
                thisVergunningEndCalendar.add(1, 20);
                this.dcmVergunningServer.setVergunningEndDate(thisVergunningEndCalendar);
                this.dcmVergunningServer.setVergunningPeriod(vergunningPeriodParam);
            }
        }
        if (vergunningPeriodParam.length() > 0) {
            this.dcmVergunningServer.setVergunningPeriod(vergunningPeriodParam);
        }
        if (thisVergunningStartCalendar != null && vergunningPeriodParam != null && (status = this.dcmVergunningServer.getAK())[0].equals("0")) {
            activationCodeKeyString = status[1];
            activationCodeString = serversInLicenseParam + "-" + String.format("%04d", thisVergunningStartCalendar.get(1)) + "-" + String.format("%02d", thisVergunningStartCalendar.get(2) + 1) + "-" + String.format("%02d", thisVergunningStartCalendar.get(5)) + "-" + vergunningPeriodParam + "-" + activationCodeKeyString;
        }
        return activationCodeString;
    }

    @Override
    public boolean vergunningReachedLimit() {
        boolean limitExceeded = true;
        if (this.dcmMetaDBClientIsRead && this.dcmVergunningServer != null) {
            limitExceeded = this.dcmDBClient.getHostCount() >= this.dcmVergunningServer.getServersInLicense();
        }
        return limitExceeded;
    }

    @Override
    public synchronized ArrayList<RMIMessage> deleteServerByHostname(String hostnameParam) {
        this.rmiMessageList.clear();
        try {
            if (this.dcmDBClient.deleteServerByHostname(hostnameParam)) {
                this.rmiMessageList.add(new RMIMessage("Status", "DCManagerServer.deleteServerByHostname", "Success: DCMServer: Server successfully deleted", true));
            } else {
                this.rmiMessageList.add(new RMIMessage("Status", "DCManagerServer.deleteServerByHostname", "Error:   DCMServer: Server failed deletion, please check log", false));
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return this.rmiMessageList;
    }

    @Override
    public Host getHostByHostname(String hostnameParam) {
        Host thisHost = null;
        try {
            thisHost = this.dcmDBClient.getHostByHostname(hostnameParam);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return thisHost;
    }

    @Override
    public Server getServerByHostname(String hostnameParam) {
        Server server = null;
        try {
            server = (Server)this.dcmDBClient.getServerByHostname(hostnameParam).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return server;
    }

    @Override
    public Host getHostById(long idParam) throws CloneNotSupportedException {
        Host thisHost = null;
        thisHost = (Host)this.dcmDBClient.selectHost(idParam).clone();
        return thisHost;
    }

    @Override
    public boolean hostnameChangedInHostTable(String oldHostnameParam, String newHostnameParam) {
        File newHostnameDir;
        boolean succeeded = false;
        File oldHostnameDir = new File(this.configuration.getArchiveDBDir() + oldHostnameParam + this.configuration.getFileSeparator());
        if (oldHostnameDir.renameTo(newHostnameDir = new File(this.configuration.getArchiveDBDir() + newHostnameParam + this.configuration.getFileSeparator()))) {
            succeeded = true;
            this.log("Info: Renamed: " + oldHostnameDir.getPath() + " to: " + newHostnameDir.getPath(), true, true, true);
        } else {
            succeeded = false;
            this.log("Error: Renaming: " + oldHostnameDir.getPath() + " to: " + newHostnameDir.getPath(), true, true, true);
        }
        return succeeded;
    }

    @Override
    public synchronized ArrayList<RMIMessage> updateHost(Host hostParam, boolean generateScriptParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        this.rmiMessageList = this.dcmDBClient.updateHost(hostParam);
        if (generateScriptParam) {
            this.pushPollScript(this.dcmDBClient.getServer(hostParam.getId()));
        }
        return this.rmiMessageList;
    }

    @Override
    public Server getServerById(long idParam) {
        Server server = new Server();
        try {
            server = this.dcmDBClient.getServer(idParam);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return server;
    }

    @Override
    public Resource getResourceById(long idParam) {
        Resource resource = new Resource();
        try {
            resource = (Resource)this.dcmDBClient.selectResource(idParam).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return resource;
    }

    @Override
    public synchronized ArrayList<RMIMessage> pushPollScript(Server serverParam) {
        this.rmiMessageList.clear();
        try {
            DCMPushPollScriptServer dCMPushPollScriptServer = new DCMPushPollScriptServer(this.dcmServerReference, serverParam);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return this.rmiMessageList;
    }

    @Override
    public ArrayList<RMIMessage> updateResource(Resource resourceParam) throws CloneNotSupportedException {
        this.rmiMessageList.clear();
        this.dcmDBClient.updateResource(resourceParam);
        return this.rmiMessageList;
    }

    @Override
    public synchronized void log(final String messageParam, final boolean logToStatusParam, final boolean logToApplicationParam, final boolean logToFileParam) {
        if (logToStatusParam) {
            this.rmiMessageList.add(new RMIMessage("", "", messageParam, true));
        }
        Thread InventoryGUILogThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (logToStatusParam) {
                    System.out.println(messageParam);
                }
                if (logToApplicationParam) {
                    // empty if block
                }
                if (logToFileParam) {
                    DCMServer.this.logToFile(messageParam);
                }
            }
        });
        InventoryGUILogThread.setName("InventoryGUILogThread");
        InventoryGUILogThread.setDaemon(false);
        InventoryGUILogThread.setPriority(5);
        InventoryGUILogThread.start();
    }

    public synchronized void logToFile(final String displaymessage) {
        Thread logToFileThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Calendar logCalendar = Calendar.getInstance();
                String humanDate = "" + String.format("%04d", logCalendar.get(1)) + "-" + String.format("%02d", logCalendar.get(2) + 1) + "-" + String.format("%02d", logCalendar.get(5)) + " " + String.format("%02d", logCalendar.get(11)) + ":" + String.format("%02d", logCalendar.get(12)) + ":" + String.format("%02d", logCalendar.get(13));
                try {
                    DCMServer.this.logFileWriter = new FileWriter(DCMServer.this.logFileString, true);
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: new FileWriter(" + DCMServer.this.logFileString + ")" + ex.getMessage());
                    DCMServer.this.logBuffer = DCMServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMServer.this.logFileWriter.flush();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.flush()1;");
                    DCMServer.this.logBuffer = DCMServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMServer.this.logFileWriter.write(DCMServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n");
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.write()");
                    DCMServer.this.logBuffer = DCMServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                try {
                    DCMServer.this.logFileWriter.flush();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.flush()2;");
                    DCMServer.this.logBuffer = DCMServer.this.logBuffer + humanDate + " " + displaymessage + "\r\n";
                    return;
                }
                DCMServer.this.logBuffer = "";
                try {
                    DCMServer.this.logFileWriter.close();
                }
                catch (IOException ex) {
                    System.out.println("Error: IOException: logFileWriter.close(); " + ex.getMessage());
                    return;
                }
            }
        });
        logToFileThread.setName("logToFileThread");
        logToFileThread.setDaemon(this.runThreadsAsDaemons);
        logToFileThread.start();
    }

    @Override
    public void dbClientReady() {
        this.dcmMetaDBClientIsRead = true;
    }

    @Override
    public void updatedHost() {
    }

    @Override
    public void startPoller() {
        String javaParam = "";
        if (this.daemon) {
            javaParam = " --daemon ";
        }
        this.shell.startPoller(128, " -Duser.country=US -Duser.language=en ", javaParam);
    }

    @Override
    public void pollServerReady() {
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (args.length < 1) {
                    DCMServer.usage();
                    System.exit(1);
                } else {
                    try {
                        try {
                            boolean daemon = false;
                            boolean debug = false;
                            for (int i = 0; i < args.length; ++i) {
                                if (args[i].equals("--daemon")) {
                                    daemon = true;
                                    continue;
                                }
                                if (args[i].equals("--debug")) {
                                    debug = true;
                                    continue;
                                }
                                if (!args[i].equals("--help")) continue;
                                DCMServer.usage();
                                System.exit(1);
                            }
                            new DCMServer(Integer.parseInt(args[0]), daemon, debug);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static void usage() {
        System.out.println("\n");
        System.out.println("Usage:   java -server -Djava.rmi.server.hostname=server.domain.com -cp DCManager.jar DCMServer <port> [--daemon] [--debug]\n");
        System.out.println(DCMLicense.getCopyright());
    }

    public class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

