/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DCMShell {
    private String platform;
    private String[] status = new String[2];
    private Process process;
    private String[] STARTJCONSOLE;
    private String[] STARTUPDATER;
    private String[] STARTDESKTOP;
    private String[] STARTCLIENT;
    private String[] STARTSERVER;
    private String[] STARTJAVADBSERVER;
    private String[] STARTPOLLER;
    private String[] STARTCOMMANDER;
    private int heapMemMax = 128;
    private int serverPort = 20000;
    private String javaOptions = "";
    private String javaParameters = "";
    private boolean debug;
    private String debugParameter = "";
    private String workingdir;

    public DCMShell(boolean debugParam) {
        this.debug = debugParam;
        if (this.debug) {
            this.debugParameter = " --debug ";
        }
        this.platform = System.getProperty("os.name").toLowerCase();
        this.setENV();
    }

    public void startJConsole() {
        try {
            Runtime.getRuntime().exec(this.STARTJCONSOLE);
        }
        catch (IOException ex) {
            System.err.println("RunTime Error: " + ex.getMessage());
        }
    }

    public void startUpdater() {
        try {
            Runtime.getRuntime().exec(this.STARTUPDATER);
        }
        catch (IOException ex) {
            System.err.println("RunTime Error: " + ex.getMessage());
        }
    }

    public void startDesktop(int heapMemMaxParam, String javaOptionsParam, String javaParametersParam) {
        this.heapMemMax = heapMemMaxParam;
        this.javaOptions = javaOptionsParam;
        this.javaParameters = javaParametersParam;
        this.setENV();
        try {
            Runtime.getRuntime().exec(this.STARTDESKTOP);
        }
        catch (IOException ex) {
            System.err.println("RunTime Error: " + ex.getMessage());
        }
    }

    public void startClient(int heapMemMaxParam, String javaOptionsParam, String javaParametersParam) {
        this.heapMemMax = heapMemMaxParam;
        this.javaOptions = javaOptionsParam;
        this.javaParameters = javaParametersParam;
        this.setENV();
        ProcessBuilder processBuilder = new ProcessBuilder(this.STARTCLIENT);
        Map<String, String> env = processBuilder.environment();
        File log = new File("startClient.log");
        processBuilder.directory(new File(this.workingdir));
        processBuilder.redirectErrorStream(true);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(log));
        Process process = null;
        try {
            process = processBuilder.start();
        }
        catch (IOException ex) {
            Logger.getLogger(DCMShell.class.getName()).log(Level.SEVERE, null, ex);
        }
        assert (processBuilder.redirectInput() == ProcessBuilder.Redirect.PIPE);
        assert (processBuilder.redirectOutput().file() == log);
        try {
            assert (process.getInputStream().read() == -1);
        }
        catch (IOException ex) {
            Logger.getLogger(DCMShell.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void startServer(int heapMemMaxParam, String javaOptionsParam, int serverPortParam, String javaParametersParam) {
        this.serverPort = serverPortParam;
        this.heapMemMax = heapMemMaxParam;
        this.javaOptions = javaOptionsParam;
        this.javaParameters = javaParametersParam;
        this.setENV();
        try {
            Runtime.getRuntime().exec(this.STARTSERVER);
        }
        catch (IOException ex) {
            System.err.println("RunTime Error: " + ex.getMessage());
        }
    }

    public void startPoller(int heapMemMaxParam, String javaOptionsParam, String javaParametersParam) {
        this.heapMemMax = heapMemMaxParam;
        this.javaOptions = javaOptionsParam;
        this.javaParameters = javaParametersParam;
        this.setENV();
        try {
            Runtime.getRuntime().exec(this.STARTPOLLER);
        }
        catch (IOException ex) {
            System.err.println("RunTime Error: " + ex.getMessage());
        }
    }

    public void startCommander(int heapMemMaxParam, String javaOptionsParam, String javaParametersParam) {
        this.heapMemMax = heapMemMaxParam;
        this.javaOptions = javaOptionsParam;
        this.javaParameters = javaParametersParam;
        this.setENV();
        try {
            Runtime.getRuntime().exec(this.STARTCOMMANDER);
        }
        catch (IOException ex) {
            System.err.println("RunTime Error: " + ex.getMessage());
        }
    }

    public void startJavaDBServer(int heapMemMaxParam, String javaOptionsParam, String javaParametersParam) {
        this.heapMemMax = heapMemMaxParam;
        this.javaOptions = javaOptionsParam;
        this.javaParameters = javaParametersParam;
        this.setENV();
        try {
            Runtime.getRuntime().exec(this.STARTJAVADBSERVER);
        }
        catch (IOException ex) {
            System.err.println("RunTime Error: " + ex.getMessage());
        }
    }

    public String getPlatform() {
        return this.platform;
    }

    private void setENV() {
        this.workingdir = System.getProperty("user.dir");
        if (this.platform.contains("mac os") || this.platform.contains("bsd")) {
            this.STARTDESKTOP = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMDesktop" + this.javaParameters + this.debugParameter};
            this.STARTCLIENT = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMClient" + this.javaParameters + this.debugParameter};
            this.STARTSERVER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMServer " + this.serverPort + this.javaParameters + this.debugParameter};
            this.STARTJAVADBSERVER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMDBServer" + this.javaParameters + this.debugParameter};
            this.STARTPOLLER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMPoller" + this.javaParameters + this.debugParameter};
            this.STARTCOMMANDER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMCommander" + this.javaParameters + this.debugParameter};
            this.STARTUPDATER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -jar data/bin/Updater.jar"};
            this.STARTJCONSOLE = new String[]{"/bin/sh", "-c", "jconsole"};
        } else if (this.platform.contains("linux")) {
            this.STARTDESKTOP = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMDesktop" + this.javaParameters + this.debugParameter};
            this.STARTCLIENT = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMClient" + this.javaParameters + this.debugParameter};
            this.STARTSERVER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMServer " + this.serverPort + this.javaParameters + this.debugParameter};
            this.STARTJAVADBSERVER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMDBServer" + this.javaParameters + this.debugParameter};
            this.STARTPOLLER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMPoller" + this.javaParameters + this.debugParameter};
            this.STARTCOMMANDER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMCommander" + this.javaParameters + this.debugParameter};
            this.STARTUPDATER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -jar data/bin/Updater.jar"};
            this.STARTJCONSOLE = new String[]{"/bin/sh", "-c", "jconsole"};
        } else if (this.platform.contains("sunos") || this.platform.contains("hp-ux") || this.platform.contains("aix")) {
            this.STARTDESKTOP = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMDesktop" + this.javaParameters + this.debugParameter};
            this.STARTCLIENT = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMClient" + this.javaParameters + this.debugParameter};
            this.STARTSERVER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMServer " + this.serverPort + this.javaParameters + this.debugParameter};
            this.STARTJAVADBSERVER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMDBServer" + this.javaParameters + this.debugParameter};
            this.STARTPOLLER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMPoller" + this.javaParameters + this.debugParameter};
            this.STARTCOMMANDER = new String[]{"/bin/sh", "-c", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMCommander" + this.javaParameters + this.debugParameter};
            this.STARTUPDATER = new String[]{"/bin/sh", "-c", "java -jar data/bin/Updater.jar"};
            this.STARTJCONSOLE = new String[]{"/bin/sh", "-c", "jconsole"};
        } else if (this.platform.contains("windows")) {
            this.STARTDESKTOP = new String[]{"cmd", "/C", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMDesktop" + this.javaParameters + this.debugParameter};
            this.STARTCLIENT = new String[]{"cmd", "/C", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMClient" + this.javaParameters + this.debugParameter};
            this.STARTSERVER = new String[]{"cmd", "/C", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMServer " + this.serverPort + this.javaParameters + this.debugParameter};
            this.STARTJAVADBSERVER = new String[]{"cmd", "/C", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMDBServer" + this.javaParameters + this.debugParameter};
            this.STARTPOLLER = new String[]{"cmd", "/C", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMPoller" + this.javaParameters + this.debugParameter};
            this.STARTCOMMANDER = new String[]{"cmd", "/C", "java " + this.javaOptions + " -Xmx" + Integer.toString(this.heapMemMax) + "m -cp DCManager.jar DCMCommander" + this.javaParameters + this.debugParameter};
            this.STARTUPDATER = new String[]{"cmd", "/C", "java " + this.javaOptions + " -jar data\\bin\\Updater.jar"};
            this.STARTJCONSOLE = new String[]{"cmd", "/C", "jconsole"};
        } else {
            System.err.println("Shell commands not implemented for " + this.platform);
        }
    }

    public void setDebug(boolean debugParam) {
        this.debug = debugParam;
        this.debugParameter = this.debug ? " --debug" : "";
    }
}

