/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import javax.swing.plaf.FontUIResource;

public class DCMStarter
extends JFrame {
    private DCMShell shell;
    private boolean debug = false;
    private boolean blockWindow = false;
    private Color buttonForegroundColor;
    private String serverFieldExample;
    private boolean sloganWaitWarningBlinking = false;
    private boolean serverFieldsBlinking = false;
    private boolean serverFieldChanged = false;
    private String dataDir;
    private String sloganText;
    private File file;
    private DCMStarter dcmStarterReference;
    private String country;
    private String language;
    private String[][] lang;
    private Locale currentLocale;
    private Locale targetLocale;
    private JLabel backgroundLabel;
    private JLabel clientLabel;
    private JCheckBox daemonsVisibleBox;
    private JCheckBox debugCheckbox;
    private JLabel desktopLabel;
    private JLabel headerLabel;
    private JTextArea infoArea;
    private JScrollPane infoScroller;
    private JLayeredPane jLayeredPane1;
    private JComboBox languageBox;
    private JLabel pollerLabel;
    private JTextField portField;
    private JTextField serverField;
    private JLabel serverLabel;
    private JLabel sloganLabel;
    private JButton websiteButton;

    public DCMStarter() {
        UIManager.put("Label.font", new Font("Courier", 2, 12));
        this.initComponents();
        this.setTitle(DCMLicense.getProcuct() + " " + DCMLicense.getVersion());
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        int posX = Math.round(screenDim.width / 2 - winWidth / 2);
        int posY = Math.round(screenDim.height / 2 - winHeight / 2);
        this.setLocation(posX, posY);
        this.shell = new DCMShell(this.debug);
        this.buttonForegroundColor = new Color(255, 255, 255);
        this.sloganText = "A UNIX Server can Run, but it can't Hide";
        this.serverFieldExample = "127.0.0.1";
        this.serverField.setText(this.serverFieldExample);
        this.dataDir = "data";
        this.file = new File(this.dataDir);
        this.blockWindow = true;
        this.country = System.getProperty("user.country");
        this.language = System.getProperty("user.language");
        this.currentLocale = new Locale(this.language, this.country);
        this.targetLocale = new Locale(this.language, this.country);
        this.lang = new String[][]{{"\u0623\u0644\u0645\u0627\u0646\u064a", "\u0627\u0644\u0623\u0633\u0628\u0627\u0646\u064a\u0629", "\u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a\u0629", "\u0627\u0644\u0625\u064a\u0637\u0627\u0644\u064a", "\u0627\u0644\u0628\u0631\u062a\u063a\u0627\u0644\u064a\u0629", "\u0627\u0644\u0631\u0648\u0633\u064a\u0629", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "\u0641\u0631\u0646\u0633\u064a", "\u0647\u0648\u0644\u0646\u062f\u064a"}, {"Arabisch", "Deutsch", "Englisch", "Franz\u00f6sisch", "Holl\u00e4ndisch", "Italienisch", "Portugiesisch", "Russisch", "Spanisch"}, {"Arabic", "Dutch", "English", "French", "German", "Italian", "Portuguese", "Russian", "Spanish"}, {"\u00e1rabe", "holand\u00eas", "Ingl\u00eas", "alem\u00e1n", "franc\u00e9s", "espa\u00f1ol", "italiano", "portugu\u00e9s", "ruso"}, {"allemand", "anglaise", "arabe", "espagnole", "fran\u00e7ais", "hollandaise", "italien", "portugaise", "russes"}, {"arabo", "francese", "inglese", "italiano", "olandese", "portoghese", "russo", "spagnolo", "tedesco"}, {"Arabisch", "Duits", "Engels", "Frans", "Italiaans", "Nederlands", "Portugees", "Russisch", "Spaans"}, {"alem\u00e3o", "\u00e1rabe", "espanhol", "franc\u00eas", "holand\u00eas", "Ingl\u00eas", "italiano", "portugu\u00eas", "russo"}, {"\u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439", "\u0430\u0440\u0430\u0431\u0441\u043a\u0438\u0439", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439", "\u0438\u0441\u043f\u0430\u043d\u0441\u043a\u0438\u0439", "\u0438\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0438\u0439", "\u043d\u0435\u043c\u0435\u0446\u043a\u0438\u0439", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0438\u0439", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439"}};
        String loc = Locale.getDefault().getLanguage();
        if (loc.equals("ar")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[0]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("ar", "SA");
            this.languageBox.setSelectedItem(this.lang[0][6]);
        } else if (loc.equals("de")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[1]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("de", "DE");
            this.languageBox.setSelectedItem(this.lang[1][1]);
        } else if (loc.equals("en")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[2]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("en", "US");
            this.languageBox.setSelectedItem(this.lang[2][2]);
        } else if (loc.equals("es")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[3]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("es", "ES");
            this.languageBox.setSelectedItem(this.lang[3][5]);
        } else if (loc.equals("fr")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[4]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("fr", "FR");
            this.languageBox.setSelectedItem(this.lang[4][4]);
        } else if (loc.equals("it")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[5]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("it", "IT");
            this.languageBox.setSelectedItem(this.lang[5][3]);
        } else if (loc.equals("nl")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[6]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("nl", "NL");
            this.languageBox.setSelectedItem(this.lang[6][5]);
        } else if (loc.equals("pt")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[7]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("pt", "BR");
            this.languageBox.setSelectedItem(this.lang[7][7]);
        } else if (loc.equals("ru")) {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[8]) {
                this.languageBox.addItem(mylang);
            }
            this.targetLocale = new Locale("ru", "RU");
            this.languageBox.setSelectedItem(this.lang[8][7]);
        } else {
            this.languageBox.removeAllItems();
            for (String mylang : this.lang[1]) {
                this.languageBox.addItem(mylang);
            }
            this.languageBox.setSelectedItem(this.lang[2][2]);
        }
        this.blockWindow = false;
        this.dcmStarterReference = this;
    }

    private void languageSelected() {
        if (!this.blockWindow) {
            int x;
            String selItem = String.valueOf(this.languageBox.getSelectedItem());
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][6]) && !selItem.equals(this.lang[1][0]) && !selItem.equals(this.lang[2][0]) && !selItem.equals(this.lang[3][0]) && !selItem.equals(this.lang[4][2]) && !selItem.equals(this.lang[5][0]) && !selItem.equals(this.lang[6][0]) && !selItem.equals(this.lang[7][1]) && !selItem.equals(this.lang[8][1])) continue;
                this.targetLocale = new Locale("ar", "SA");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][0]) && !selItem.equals(this.lang[1][1]) && !selItem.equals(this.lang[2][4]) && !selItem.equals(this.lang[3][3]) && !selItem.equals(this.lang[4][0]) && !selItem.equals(this.lang[5][8]) && !selItem.equals(this.lang[6][1]) && !selItem.equals(this.lang[7][0]) && !selItem.equals(this.lang[8][5])) continue;
                this.targetLocale = new Locale("de", "DE");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][2]) && !selItem.equals(this.lang[1][2]) && !selItem.equals(this.lang[2][2]) && !selItem.equals(this.lang[3][2]) && !selItem.equals(this.lang[4][1]) && !selItem.equals(this.lang[5][2]) && !selItem.equals(this.lang[6][2]) && !selItem.equals(this.lang[7][5]) && !selItem.equals(this.lang[8][0])) continue;
                this.targetLocale = new Locale("en", "EN");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][1]) && !selItem.equals(this.lang[1][8]) && !selItem.equals(this.lang[2][8]) && !selItem.equals(this.lang[3][5]) && !selItem.equals(this.lang[4][3]) && !selItem.equals(this.lang[5][7]) && !selItem.equals(this.lang[6][8]) && !selItem.equals(this.lang[7][2]) && !selItem.equals(this.lang[8][3])) continue;
                this.targetLocale = new Locale("es", "ES");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][7]) && !selItem.equals(this.lang[1][3]) && !selItem.equals(this.lang[2][3]) && !selItem.equals(this.lang[3][4]) && !selItem.equals(this.lang[4][4]) && !selItem.equals(this.lang[5][1]) && !selItem.equals(this.lang[6][3]) && !selItem.equals(this.lang[7][3]) && !selItem.equals(this.lang[8][8])) continue;
                this.targetLocale = new Locale("fr", "FR");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][3]) && !selItem.equals(this.lang[1][5]) && !selItem.equals(this.lang[2][5]) && !selItem.equals(this.lang[3][6]) && !selItem.equals(this.lang[4][6]) && !selItem.equals(this.lang[5][3]) && !selItem.equals(this.lang[6][4]) && !selItem.equals(this.lang[7][6]) && !selItem.equals(this.lang[8][4])) continue;
                this.targetLocale = new Locale("it", "IT");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][8]) && !selItem.equals(this.lang[1][4]) && !selItem.equals(this.lang[2][1]) && !selItem.equals(this.lang[3][1]) && !selItem.equals(this.lang[4][5]) && !selItem.equals(this.lang[5][4]) && !selItem.equals(this.lang[6][5]) && !selItem.equals(this.lang[7][4]) && !selItem.equals(this.lang[8][2])) continue;
                this.targetLocale = new Locale("nl", "NL");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][4]) && !selItem.equals(this.lang[1][6]) && !selItem.equals(this.lang[2][6]) && !selItem.equals(this.lang[3][7]) && !selItem.equals(this.lang[4][7]) && !selItem.equals(this.lang[5][5]) && !selItem.equals(this.lang[6][6]) && !selItem.equals(this.lang[7][7]) && !selItem.equals(this.lang[8][6])) continue;
                this.targetLocale = new Locale("pt", "BR");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            for (x = 0; x < this.lang.length; ++x) {
                if (!selItem.equals(this.lang[0][5]) && !selItem.equals(this.lang[1][7]) && !selItem.equals(this.lang[2][7]) && !selItem.equals(this.lang[3][8]) && !selItem.equals(this.lang[4][8]) && !selItem.equals(this.lang[5][6]) && !selItem.equals(this.lang[6][7]) && !selItem.equals(this.lang[7][8]) && !selItem.equals(this.lang[8][7])) continue;
                this.targetLocale = new Locale("ru", "RU");
                Locale.setDefault(this.targetLocale);
                Locale.setDefault(this.targetLocale);
            }
            this.setLocale(this.targetLocale);
            this.setVisible(false);
            new DCMStarter().setVisible(true);
        }
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.portField = new JTextField();
        this.serverField = new JTextField();
        this.languageBox = new JComboBox();
        this.daemonsVisibleBox = new JCheckBox();
        this.websiteButton = new JButton();
        this.headerLabel = new JLabel();
        this.sloganLabel = new JLabel();
        this.debugCheckbox = new JCheckBox();
        this.desktopLabel = new JLabel();
        this.serverLabel = new JLabel();
        this.clientLabel = new JLabel();
        this.pollerLabel = new JLabel();
        this.backgroundLabel = new JLabel();
        this.infoScroller = new JScrollPane();
        this.infoArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("DCMStarter");
        this.setTitle(bundle.getString("DCMStarter.title"));
        this.setFont(new Font("Apple Chancery", 0, 10));
        this.setResizable(false);
        this.jLayeredPane1.setBackground(new Color(51, 51, 51));
        this.jLayeredPane1.setFont(new Font("Arial", 0, 13));
        this.jLayeredPane1.setOpaque(true);
        this.portField.setFont(new Font("Courier New", 1, 12));
        this.portField.setForeground(Color.gray);
        this.portField.setHorizontalAlignment(0);
        this.portField.setText(bundle.getString("DCMStarter.portField.text"));
        this.portField.setToolTipText(bundle.getString("DCMStarter.portField.toolTipText"));
        this.portField.setBorder(null);
        this.jLayeredPane1.add(this.portField);
        this.portField.setBounds(250, 410, 50, 15);
        this.serverField.setFont(new Font("Courier New", 1, 12));
        this.serverField.setForeground(Color.gray);
        this.serverField.setHorizontalAlignment(0);
        this.serverField.setText(bundle.getString("DCMStarter.serverField.text"));
        this.serverField.setToolTipText(bundle.getString("DCMStarter.serverField.toolTipText"));
        this.serverField.setBorder(null);
        this.serverField.setOpaque(false);
        this.serverField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DCMStarter.this.serverFieldKeyReleased(evt);
            }
        });
        this.jLayeredPane1.add(this.serverField);
        this.serverField.setBounds(50, 410, 200, 15);
        this.languageBox.setFont(this.languageBox.getFont().deriveFont((float)this.languageBox.getFont().getSize() - 3.0f));
        this.languageBox.setMaximumRowCount(25);
        this.languageBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Arabic", "English", "Portuguese", "Russian"}));
        this.languageBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMStarter.this.languageBoxActionPerformed(evt);
            }
        });
        this.jLayeredPane1.add(this.languageBox);
        this.languageBox.setBounds(520, 80, 100, 20);
        this.daemonsVisibleBox.setFont(this.daemonsVisibleBox.getFont().deriveFont((float)this.daemonsVisibleBox.getFont().getSize() - 5.0f));
        this.daemonsVisibleBox.setForeground(new Color(204, 204, 204));
        this.daemonsVisibleBox.setSelected(true);
        this.daemonsVisibleBox.setText(bundle.getString("DCMStarter.daemonsVisibleBox.text"));
        this.daemonsVisibleBox.setToolTipText(bundle.getString("DCMStarter.daemonsVisibleBox.toolTipText"));
        this.jLayeredPane1.add(this.daemonsVisibleBox);
        this.daemonsVisibleBox.setBounds(140, 430, 230, 20);
        this.websiteButton.setFont(new Font("STHeiti", 0, 10));
        this.websiteButton.setText(bundle.getString("DCMStarter.websiteButton.text"));
        this.websiteButton.setToolTipText(bundle.getString("DCMStarter.websiteButton.toolTipText"));
        this.websiteButton.setActionCommand(bundle.getString("DCMStarter.websiteButton.actionCommand"));
        this.websiteButton.setFocusable(false);
        this.websiteButton.setMaximumSize(new Dimension(90, 13));
        this.websiteButton.setMinimumSize(new Dimension(90, 13));
        this.websiteButton.setPreferredSize(new Dimension(90, 13));
        this.websiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMStarter.this.websiteButtonActionPerformed(evt);
            }
        });
        this.jLayeredPane1.add(this.websiteButton);
        this.websiteButton.setBounds(0, 80, 80, 20);
        this.headerLabel.setFont(this.headerLabel.getFont().deriveFont(this.headerLabel.getFont().getStyle() | 1, this.headerLabel.getFont().getSize() + 35));
        this.headerLabel.setForeground(new Color(255, 255, 255));
        this.headerLabel.setHorizontalAlignment(0);
        this.headerLabel.setText(bundle.getString("DCMStarter.headerLabel.text"));
        this.jLayeredPane1.add(this.headerLabel);
        this.headerLabel.setBounds(0, 4, 620, 70);
        this.sloganLabel.setFont(new Font("Courier", 1, 14));
        this.sloganLabel.setForeground(new Color(204, 204, 204));
        this.sloganLabel.setHorizontalAlignment(0);
        this.sloganLabel.setText(bundle.getString("DCMStarter.sloganLabel.text"));
        this.jLayeredPane1.add(this.sloganLabel);
        this.sloganLabel.setBounds(0, 70, 620, 40);
        this.debugCheckbox.setFont(this.debugCheckbox.getFont().deriveFont((float)this.debugCheckbox.getFont().getSize() - 5.0f));
        this.debugCheckbox.setForeground(new Color(204, 204, 204));
        this.debugCheckbox.setText(bundle.getString("DCMStarter.debugCheckbox.text"));
        this.debugCheckbox.setToolTipText(bundle.getString("DCMStarter.debugCheckbox.toolTipText"));
        this.debugCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCMStarter.this.debugCheckboxActionPerformed(evt);
            }
        });
        this.jLayeredPane1.add(this.debugCheckbox);
        this.debugCheckbox.setBounds(440, 430, 90, 20);
        this.desktopLabel.setFont(this.desktopLabel.getFont());
        this.desktopLabel.setHorizontalAlignment(0);
        this.desktopLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/desktop.png")));
        this.desktopLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), bundle.getString("DCMStarter.desktopLabel.border.title"), 2, 3, new Font("STHeiti", 0, 18), new Color(255, 255, 255)));
        this.desktopLabel.setOpaque(true);
        this.desktopLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DCMStarter.this.desktopLabelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DCMStarter.this.desktopLabelMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DCMStarter.this.desktopLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DCMStarter.this.desktopLabelMouseEntered(evt);
            }
        });
        this.jLayeredPane1.add(this.desktopLabel);
        this.desktopLabel.setBounds(0, 110, 310, 160);
        this.serverLabel.setFont(this.serverLabel.getFont());
        this.serverLabel.setHorizontalAlignment(0);
        this.serverLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/server.png")));
        this.serverLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), bundle.getString("DCMStarter.serverLabel.border.title"), 2, 3, new Font("STHeiti", 0, 18), new Color(255, 255, 255)));
        this.serverLabel.setOpaque(true);
        this.serverLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DCMStarter.this.serverLabelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DCMStarter.this.serverLabelMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                DCMStarter.this.serverLabelMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DCMStarter.this.serverLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DCMStarter.this.serverLabelMouseEntered(evt);
            }
        });
        this.jLayeredPane1.add(this.serverLabel);
        this.serverLabel.setBounds(0, 270, 310, 164);
        this.clientLabel.setFont(this.clientLabel.getFont());
        this.clientLabel.setHorizontalAlignment(0);
        this.clientLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/client.png")));
        this.clientLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), bundle.getString("DCMStarter.clientLabel.border.title"), 2, 3, new Font("STHeiti", 0, 18), new Color(255, 255, 255)));
        this.clientLabel.setOpaque(true);
        this.clientLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DCMStarter.this.clientLabelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DCMStarter.this.clientLabelMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DCMStarter.this.clientLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DCMStarter.this.clientLabelMouseEntered(evt);
            }
        });
        this.jLayeredPane1.add(this.clientLabel);
        this.clientLabel.setBounds(310, 110, 310, 160);
        this.pollerLabel.setFont(this.pollerLabel.getFont());
        this.pollerLabel.setHorizontalAlignment(0);
        this.pollerLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/poller.png")));
        this.pollerLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), bundle.getString("DCMStarter.pollerLabel.border.title"), 2, 3, new Font("STHeiti", 0, 18), new Color(255, 255, 255)));
        this.pollerLabel.setOpaque(true);
        this.pollerLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DCMStarter.this.pollerLabelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DCMStarter.this.pollerLabelMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DCMStarter.this.pollerLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DCMStarter.this.pollerLabelMouseEntered(evt);
            }
        });
        this.jLayeredPane1.add(this.pollerLabel);
        this.pollerLabel.setBounds(310, 270, 310, 164);
        this.backgroundLabel.setHorizontalAlignment(0);
        this.backgroundLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/worldmap.jpg")));
        this.backgroundLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jLayeredPane1.add(this.backgroundLabel);
        this.backgroundLabel.setBounds(0, 0, 620, 110);
        this.infoScroller.setBorder(BorderFactory.createEtchedBorder());
        this.infoScroller.setForeground(new Color(255, 255, 51));
        this.infoScroller.setHorizontalScrollBarPolicy(31);
        this.infoScroller.setVerticalScrollBarPolicy(21);
        this.infoArea.setBackground(new Color(51, 51, 51));
        this.infoArea.setColumns(20);
        this.infoArea.setEditable(false);
        this.infoArea.setFont(new Font("STHeiti", 0, 12));
        this.infoArea.setForeground(new Color(204, 204, 204));
        this.infoArea.setRows(5);
        this.infoArea.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.infoArea.setMinimumSize(new Dimension(2, 20));
        this.infoArea.setPreferredSize(new Dimension(262, 80));
        this.infoScroller.setViewportView(this.infoArea);
        this.jLayeredPane1.add(this.infoScroller);
        this.infoScroller.setBounds(0, 450, 620, 40);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 620, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLayeredPane1, -1, 492, Short.MAX_VALUE));
        this.pack();
    }

    private void desktopLabelMouseEntered(MouseEvent evt) {
        this.desktopLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Start Desktop", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.infoArea.setText("Start Standalone Desktop Application\njava -cp DCManager.jar DCMDesktop");
    }

    private void desktopLabelMouseExited(MouseEvent evt) {
        this.desktopLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Desktop", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
    }

    private void clientLabelMouseEntered(MouseEvent evt) {
        this.clientLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Start Client", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.infoArea.setText("Start Network Client (Requires Server)\njava -cp DCManager.jar DCMClient");
    }

    private void clientLabelMouseExited(MouseEvent evt) {
        this.clientLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Client", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
    }

    private void serverLabelMouseEntered(MouseEvent evt) {
        this.serverLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Start Server", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.infoArea.setText("Start Network Server (Used by Network Client)\njava -Djava.rmi.server.hostname=server.domain.com -cp DCManager.jar DCMServer 20000 #(portnumber)");
        this.blinkServerFields(4);
    }

    private void blinkServerFields(final int blinkcycle) {
        if (!this.serverFieldsBlinking && this.serverField.isEnabled() && this.portField.isEnabled()) {
            Thread blinkThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    DCMStarter.this.serverFieldsBlinking = true;
                    for (int i = 1; i < blinkcycle; ++i) {
                        DCMStarter.this.serverField.setForeground(Color.black);
                        DCMStarter.this.portField.setForeground(Color.black);
                        try {
                            Thread.sleep(125L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        DCMStarter.this.serverField.setForeground(Color.white);
                        DCMStarter.this.portField.setForeground(Color.white);
                        try {
                            Thread.sleep(125L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DCMStarter.this.serverField.setForeground(Color.GRAY);
                    DCMStarter.this.portField.setForeground(Color.GRAY);
                    DCMStarter.this.serverFieldsBlinking = false;
                }
            });
            blinkThread.setName("blinkThread");
            blinkThread.setDaemon(false);
            blinkThread.setPriority(5);
            blinkThread.start();
        }
    }

    private void blinkSloganWaitWarning(String message, int blinkRepeats) {
        if (!this.sloganWaitWarningBlinking) {
            this.desktopLabel.setEnabled(false);
            this.clientLabel.setEnabled(false);
            this.serverLabel.setEnabled(false);
            this.serverLabel.setEnabled(false);
            this.pollerLabel.setEnabled(false);
            this.serverField.setEnabled(false);
            this.portField.setEnabled(false);
            this.sloganWaitWarningBlinking = true;
            for (int i = 1; i < blinkRepeats; ++i) {
                this.sloganLabel.setText(message + " Please Wait...");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.sloganLabel.setText(message + "               ");
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.sloganLabel.setText(this.sloganText);
            this.sloganWaitWarningBlinking = false;
            this.desktopLabel.setEnabled(true);
            this.clientLabel.setEnabled(true);
            this.serverLabel.setEnabled(true);
            this.pollerLabel.setEnabled(true);
            this.serverField.setEnabled(true);
            this.portField.setEnabled(true);
        }
    }

    private void serverLabelMouseExited(MouseEvent evt) {
        this.serverLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Server", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.blinkServerFields(2);
    }

    private void pollerLabelMouseEntered(MouseEvent evt) {
        this.pollerLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Start Poller", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.infoArea.setText("Start Poller (Collects Datacenter Statistics)\njava -Duser.country=US -Duser.language=en -cp DCManager.jar DCMPoller");
    }

    private void pollerLabelMouseExited(MouseEvent evt) {
        this.pollerLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Poller", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
    }

    private void desktopLabelMousePressed(MouseEvent evt) {
        this.desktopLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Start Desktop", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
    }

    private void desktopLabelMouseReleased(MouseEvent evt) {
        this.desktopLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Start Desktop", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.dcmStarterReference = this;
        Thread blinkDesktopWaitWarningThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (DCMStarter.this.desktopLabel.isEnabled()) {
                    String daemonParamString = "";
                    daemonParamString = DCMStarter.this.daemonsVisibleBox.isSelected() ? "" : " --daemon ";
                    DCMStarter.this.shell.startDesktop(256, " -Duser.country=" + DCMStarter.this.targetLocale.getCountry() + " -Duser.language=" + DCMStarter.this.targetLocale.getLanguage() + " ", daemonParamString);
                    if (!DCMStarter.this.file.exists()) {
                        DCMStarter.this.blinkSloganWaitWarning("Desktop Initiating", 15);
                    } else {
                        DCMStarter.this.blinkSloganWaitWarning("Desktop Starting", 5);
                    }
                    DCMStarter.this.dcmStarterReference.dropWindow();
                }
            }
        });
        blinkDesktopWaitWarningThread.setName("blinkDesktopWaitWarningThread");
        blinkDesktopWaitWarningThread.setDaemon(false);
        blinkDesktopWaitWarningThread.setPriority(5);
        blinkDesktopWaitWarningThread.start();
    }

    private void clientLabelMousePressed(MouseEvent evt) {
        this.clientLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Start Client", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
    }

    private void clientLabelMouseReleased(MouseEvent evt) {
        this.clientLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Start Client", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.dcmStarterReference = this;
        Thread blinkClientWaitWarningThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (DCMStarter.this.clientLabel.isEnabled()) {
                    String daemonParamString = "";
                    daemonParamString = DCMStarter.this.daemonsVisibleBox.isSelected() ? "" : " --daemon ";
                    DCMStarter.this.shell.startClient(128, " -Duser.country=" + DCMStarter.this.targetLocale.getCountry() + " -Duser.language=" + DCMStarter.this.targetLocale.getLanguage() + " ", daemonParamString);
                    DCMStarter.this.blinkSloganWaitWarning("Client Starting", 5);
                    DCMStarter.this.dcmStarterReference.dropWindow();
                }
            }
        });
        blinkClientWaitWarningThread.setName("blinkClientWaitWarningThread");
        blinkClientWaitWarningThread.setDaemon(false);
        blinkClientWaitWarningThread.setPriority(5);
        blinkClientWaitWarningThread.start();
    }

    private void serverLabelMousePressed(MouseEvent evt) {
        this.serverLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Start Server", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
    }

    private void serverLabelMouseReleased(MouseEvent evt) {
        this.serverLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Start Server", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.dcmStarterReference = this;
        Thread blinkServerWaitWarningThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (DCMStarter.this.serverFieldChanged) {
                    if (DCMStarter.this.serverLabel.isEnabled()) {
                        String daemonParamString = "";
                        daemonParamString = DCMStarter.this.daemonsVisibleBox.isSelected() ? "" : " --daemon ";
                        DCMStarter.this.shell.startServer(256, "-server -Djava.rmi.server.hostname=" + DCMStarter.this.serverField.getText(), Integer.parseInt(DCMStarter.this.portField.getText()), daemonParamString);
                        if (!DCMStarter.this.file.exists()) {
                            DCMStarter.this.blinkSloganWaitWarning("Server Initiating", 10);
                        } else {
                            DCMStarter.this.blinkSloganWaitWarning("Server Starting", 4);
                        }
                    }
                } else {
                    DCMStarter.this.blinkServerFields(2);
                }
            }
        });
        blinkServerWaitWarningThread.setName("blinkServerWaitWarningThread");
        blinkServerWaitWarningThread.setDaemon(false);
        blinkServerWaitWarningThread.setPriority(5);
        blinkServerWaitWarningThread.start();
    }

    private void pollerLabelMousePressed(MouseEvent evt) {
        this.pollerLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Start Poller", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
    }

    private void pollerLabelMouseReleased(MouseEvent evt) {
        this.pollerLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(0), "Start Poller", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        this.dcmStarterReference = this;
        Thread blinkPollerWaitWarningThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (DCMStarter.this.pollerLabel.isEnabled()) {
                    String daemonParamString = "";
                    daemonParamString = DCMStarter.this.daemonsVisibleBox.isSelected() ? "" : " --daemon ";
                    DCMStarter.this.shell.startPoller(128, " -Duser.country=US -Duser.language=en ", daemonParamString);
                    if (!DCMStarter.this.file.exists()) {
                        DCMStarter.this.blinkSloganWaitWarning("Poller Initiating", 10);
                    } else {
                        DCMStarter.this.blinkSloganWaitWarning("Poller Starting", 4);
                    }
                }
            }
        });
        blinkPollerWaitWarningThread.setName("blinkPollerWaitWarningThread");
        blinkPollerWaitWarningThread.setDaemon(false);
        blinkPollerWaitWarningThread.setPriority(5);
        blinkPollerWaitWarningThread.start();
    }

    private void debugCheckboxActionPerformed(ActionEvent evt) {
        if (this.debugCheckbox.isSelected()) {
            this.shell.setDebug(true);
            this.debugCheckbox.setForeground(Color.ORANGE);
            this.buttonForegroundColor = Color.red;
            this.desktopLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Desktop", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
            this.clientLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Client", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
            this.serverLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Server", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
            this.pollerLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Poller", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        } else {
            this.shell.setDebug(false);
            this.debugCheckbox.setForeground(Color.LIGHT_GRAY);
            this.buttonForegroundColor = Color.white;
            this.desktopLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Desktop", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
            this.clientLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Client", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
            this.serverLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Server", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
            this.pollerLabel.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Poller", 2, 3, new Font("STHeiti", 0, 18), this.buttonForegroundColor));
        }
    }

    private void serverFieldKeyReleased(KeyEvent evt) {
        this.serverFieldChanged = true;
        if (evt.getKeyCode() == 10 && !this.serverField.getText().equals(this.serverFieldExample)) {
            this.dcmStarterReference = this;
            Thread blinkServerWaitWarningThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (DCMStarter.this.serverFieldChanged) {
                        if (DCMStarter.this.serverLabel.isEnabled()) {
                            if (!DCMStarter.this.file.exists()) {
                                DCMStarter.this.blinkSloganWaitWarning("Server Initiating", 10);
                            } else {
                                DCMStarter.this.blinkSloganWaitWarning("Server Starting", 4);
                            }
                            String daemonParamString = "";
                            daemonParamString = DCMStarter.this.daemonsVisibleBox.isSelected() ? "" : " --daemon ";
                            DCMStarter.this.shell.startServer(256, "-server -Djava.rmi.server.hostname=" + DCMStarter.this.serverField.getText(), Integer.parseInt(DCMStarter.this.portField.getText()), daemonParamString);
                        }
                    } else {
                        DCMStarter.this.blinkServerFields(2);
                    }
                }
            });
            blinkServerWaitWarningThread.setName("blinkClientWaitWarningThread");
            blinkServerWaitWarningThread.setDaemon(false);
            blinkServerWaitWarningThread.setPriority(5);
            blinkServerWaitWarningThread.start();
        }
    }

    private void websiteButtonActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(URI.create("http://sites.google.com/site/ronuitzaandam/"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void languageBoxActionPerformed(ActionEvent evt) {
        this.languageSelected();
    }

    private void serverLabelMouseClicked(MouseEvent evt) {
    }

    private void dropWindow() {
        Thread dropWindowThread = new Thread(new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        });
        dropWindowThread.setName("dropWindowThread");
        dropWindowThread.setDaemon(false);
        dropWindowThread.setPriority(5);
        dropWindowThread.start();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DCMStarter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DCMStarter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DCMStarter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DCMStarter.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DCMStarter().setVisible(true);
            }
        });
    }
}

