/*
 * Decompiled with CFR 0.152.
 */
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Calendar;

public class DCMSysMonitor {
    private OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private Calendar currCPUCalendar = Calendar.getInstance();
    private Calendar lastCPUCalendar = Calendar.getInstance();
    private long currCPUMilliesUsed = 0L;
    private long lastCPUMilliesUsed = 0L;
    private long currMemValue = 0L;

    public int getProcessTime() {
        int cpuPercent = 0;
        if (this.bean instanceof OperatingSystemMXBean) {
            this.currCPUMilliesUsed = this.bean.getProcessCpuTime() / 1000000L;
            this.currCPUCalendar = Calendar.getInstance();
            long cpuMilliesDiff = this.currCPUMilliesUsed - this.lastCPUMilliesUsed;
            long milliesPassed = this.currCPUCalendar.getTimeInMillis() - this.lastCPUCalendar.getTimeInMillis();
            cpuPercent = (int)Math.round((double)cpuMilliesDiff / ((double)milliesPassed * 0.001) / 10.0);
            if (cpuPercent > 100) {
                cpuPercent = 100;
            }
            this.lastCPUMilliesUsed = this.currCPUMilliesUsed;
            this.lastCPUCalendar.setTimeInMillis(this.currCPUCalendar.getTimeInMillis());
        } else {
            cpuPercent = 50;
        }
        return cpuPercent;
    }

    public int getPhysMem() {
        this.currMemValue = this.bean instanceof OperatingSystemMXBean ? this.bean.getFreePhysicalMemorySize() / 0x100000L : 100L;
        return (int)this.currMemValue;
    }
}

