/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DCMTools {
    public static Color[] getColorArray() {
        Color[] colorArray = new Color[36];
        int x = 255;
        for (int c = 0; c < 36; c += 6) {
            colorArray[c + 0] = new Color(x, 0, 0);
            colorArray[c + 1] = new Color(0, x, 0);
            colorArray[c + 2] = new Color(0, 0, x);
            colorArray[c + 3] = new Color(x, 0, x);
            colorArray[c + 4] = new Color(x, x, 0);
            colorArray[c + 5] = new Color(0, x, x);
            x -= 16;
        }
        return colorArray;
    }

    public static String startsWith(String messageParam, String patternParam) {
        BufferedReader reader = new BufferedReader(new StringReader(messageParam));
        String line = "";
        String output = "";
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 2 || !line.startsWith(patternParam)) continue;
                output = output + line + "\r\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static String contains(String messageParam, String patternParam) {
        BufferedReader reader = new BufferedReader(new StringReader(messageParam));
        String line = "";
        String output = "";
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 2 || !line.contains(patternParam)) continue;
                output = output + line + "\r\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static String getHumanDate(Calendar cal) {
        String dateString = "";
        dateString = "" + String.format("%04d", cal.get(1)) + "-" + String.format("%02d", cal.get(2) + 1) + "-" + String.format("%02d", cal.get(5));
        return dateString;
    }

    public static String getHumanDateLong(Calendar cal) {
        String dateString = "";
        dateString = "" + String.format("%04d", cal.get(1)) + "-" + String.format("%02d", cal.get(2) + 1) + "-" + String.format("%02d", cal.get(5)) + " " + String.format("%02d", cal.get(11)) + ":" + String.format("%02d", cal.get(12));
        return dateString;
    }

    public static int getNumOfLines(String messageParam) {
        BufferedReader reader = new BufferedReader(new StringReader(messageParam));
        String line = "";
        String output = "";
        int lineCounter = 0;
        try {
            while ((line = reader.readLine()) != null) {
                ++lineCounter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lineCounter;
    }

    public static void writeToFile(final String filenameParam, final byte[] dataParam) {
        Thread logToFileThread = new Thread(new Runnable(){
            private FileWriter logFileWriter;

            @Override
            public void run() {
                FileOutputStream fileoutputstream = null;
                try {
                    fileoutputstream = new FileOutputStream(filenameParam);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                try {
                    fileoutputstream.write(dataParam);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    fileoutputstream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        logToFileThread.setName("logToFileThread");
        logToFileThread.start();
    }

    public static boolean isSubString(String wholeString, String subString) {
        boolean output = false;
        String regex = new String("s/" + subString + "/");
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(subString);
        if (matcher.find()) {
            output = true;
        }
        return output;
    }

    public static String substitude(String text, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        StringBuffer newtext = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(newtext, "");
        }
        matcher.appendTail(newtext);
        return newtext.toString();
    }

    public static String split(String text, String separator) {
        Pattern pattern = Pattern.compile(separator);
        Matcher matcher = pattern.matcher(text);
        StringBuffer newtext = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(newtext, "");
        }
        matcher.appendTail(newtext);
        return newtext.toString();
    }

    public static String validateSIPAddress(String text) {
        StringBuffer finaltext = new StringBuffer("");
        StringBuffer newtext = new StringBuffer("");
        Pattern pattern = Pattern.compile("[^\\w\\-\\@\\:\\<\\>\\&\\.\\' ]");
        Matcher matcher = pattern.matcher(text);
        newtext = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(newtext, "");
        }
        matcher.appendTail(newtext);
        pattern = Pattern.compile("\\'");
        matcher = pattern.matcher(newtext);
        finaltext = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(finaltext, "\\\\'");
        }
        matcher.appendTail(finaltext);
        return finaltext.toString();
    }

    public static String getRandomString(int digitsParam) {
        String output = "";
        for (int counter = 0; counter < digitsParam; ++counter) {
            output = output + Integer.toString((int)(Math.random() * 9.0));
        }
        return output;
    }

    public static long getRandomNumber(int maxnumber) {
        Long result = Math.round(Math.random() * (double)maxnumber);
        return result;
    }

    public static boolean isLong(String i) {
        try {
            Long.parseLong(i);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

