/*
 * Decompiled with CFR 0.152.
 */
import data.MD5Converter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Calendar;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DCMVergunning
implements Cloneable {
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final int DAY = 86400000;
    private static final int WEEK = 604800000;
    private static final int YEAR = 1471228928;
    public int CALLSPERHOUR_FREE = 0;
    public static final String BRAND = "JavaSoft";
    public static final String BUSINESS = "ICT";
    public static final String PRODUCT = "DatacenterManager";
    public static final String BRAND_DESCRIPTION = "JavaSoft DatacenterManager offers 21st Century Trend Analysis !";
    public static final String PRODUCT_DESCRIPTION = "DatacenterManager is a fully automated datacenter control and performance, trend and scalability analysis software";
    public static final String WEBLINK = "https://sites.google.com/site/ronuitzaandam/home";
    public static final String REQUEST_VERGUNNINGLINK = "https://sites.google.com/site/ronuitzaandam/home";
    private static final String VERGUNNINGTOEKENNERTOEGANG = "IsNwtNp4L";
    public static final String WARNING = "Please use DatacenterManager software carefully, responsibly and according your country's legislation.";
    public static final String COPYRIGHT = "\u00a9 " + Calendar.getInstance().get(1);
    public static final String AUTHOR = "Ron de Jong";
    private boolean debug = false;
    private static final String dataDir = "data/";
    private final String xmlVergunningDir = "data/license/";
    private String xmlFileName;
    private String xmlFileBase;
    private String xmlFileExtention;
    private boolean vergunningLoaded;
    private boolean vergunningOrderInProgress;
    private String activationCodeFromFile;
    private String vergunningCodeFromFile;
    private String vergunningNumOfServers;
    private Calendar vergunningStartCalendar;
    private Calendar vergunningEndCalendar;
    private Calendar systemTimeCalendar;
    private Calendar ntpTimeCalendar;
    private String activationCodeFromSystem;
    private String vergunningCodeFromSystem;
    private boolean vergunningIsValid;
    private String vergunningPeriod;
    private final int FREESERVERSLICENSED = 1000000;
    private int serversLicensed;
    private String[] status;
    private byte[] myBytes;
    private String vergunningInvalidReason = "";
    private String vergunningInvalidAdvice = "";
    private String output = "";
    private String totOutput = "";
    private NetworkInterface networkInterface;
    private Enumeration networkInterfaceList;
    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = null;
    Document xmlDocument = null;
    DCMDesktop dcmDesktop;

    public DCMVergunning(boolean debugParam) {
        this.debug = debugParam;
        this.xmlFileName = "";
        this.xmlFileBase = "license";
        this.xmlFileExtention = ".xml";
        this.activationCodeFromFile = "";
        this.vergunningCodeFromFile = "";
        this.status = new String[2];
        this.vergunningLoaded = false;
        this.vergunningIsValid = false;
        this.vergunningOrderInProgress = false;
        this.vergunningNumOfServers = "";
        this.vergunningPeriod = "UNSET";
        this.serversLicensed = 1000000;
        this.vergunningStartCalendar = Calendar.getInstance();
        this.vergunningEndCalendar = Calendar.getInstance();
        this.systemTimeCalendar = Calendar.getInstance();
        this.ntpTimeCalendar = Calendar.getInstance();
        this.status = this.loadVergunning();
        if (this.status[0].equals("1")) {
            this.vergunningIsValid = false;
            this.serversLicensed = 1000000;
            this.vergunningStartCalendar = Calendar.getInstance();
            this.vergunningEndCalendar = Calendar.getInstance();
            this.vergunningEndCalendar.add(1, 100);
            this.vergunningPeriod = "Lifetime";
        } else {
            this.controleerVergunning();
        }
    }

    public DCMVergunning(DCMDesktop dcManagerParam, boolean debugParam) {
        this.debug = debugParam;
        this.dcmDesktop = dcManagerParam;
        this.xmlFileName = "";
        this.xmlFileBase = "license";
        this.xmlFileExtention = ".xml";
        this.activationCodeFromFile = "";
        this.vergunningCodeFromFile = "";
        this.status = new String[2];
        this.vergunningLoaded = false;
        this.vergunningIsValid = false;
        this.vergunningOrderInProgress = false;
        this.vergunningNumOfServers = "";
        this.vergunningPeriod = "UNSET";
        this.serversLicensed = 1000000;
        this.vergunningStartCalendar = Calendar.getInstance();
        this.vergunningEndCalendar = Calendar.getInstance();
        this.systemTimeCalendar = Calendar.getInstance();
        this.ntpTimeCalendar = Calendar.getInstance();
        this.status = this.loadVergunning();
        if (this.status[0].equals("1")) {
            this.vergunningIsValid = false;
            this.serversLicensed = 1000000;
            this.vergunningStartCalendar = Calendar.getInstance();
            this.vergunningEndCalendar = Calendar.getInstance();
            this.vergunningEndCalendar.add(1, 100);
            this.vergunningPeriod = "Lifetime";
        } else {
            this.controleerVergunning();
        }
    }

    public String[] createVergunning() {
        this.status[0] = "0";
        this.status[1] = "";
        this.setActivationCodeFromFile("");
        this.serversLicensed = 1000000;
        this.vergunningStartCalendar = Calendar.getInstance();
        this.vergunningEndCalendar = Calendar.getInstance();
        this.vergunningEndCalendar.add(1, 100);
        this.vergunningPeriod = "Lifetime";
        this.setVergunningCodeFromFile("");
        this.vergunningIsValid = false;
        return this.status;
    }

    public String[] loadVergunning() {
        this.vergunningLoaded = false;
        this.status[0] = "0";
        this.status[1] = "";
        this.xmlFileName = "data/license/" + this.xmlFileBase + this.xmlFileExtention;
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builder = null;
        this.xmlDocument = null;
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: builder = builderFactory.newDocumentBuilder(): ParserConfigurationException: " + error.getMessage();
            return this.status;
        }
        try {
            this.xmlDocument = this.builder.parse(this.xmlFileName);
        }
        catch (SAXException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: xmlDocument = builder.parse(xmlFile): SAXException: " + error.getMessage();
            return this.status;
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: xmlDocument = builder.parse(xmlFile): IOException: " + error.getMessage();
            return this.status;
        }
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: trans = transfac.newTransformer(): TransformerConfigurationException: " + error.getMessage();
            return this.status;
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(this.xmlDocument);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: trans.transform(source, result): TransformerException: " + error.getMessage();
            return this.status;
        }
        String xmlString = stringWriter.toString();
        Node node = this.xmlDocument.getFirstChild();
        NodeList nodelist = node.getChildNodes();
        int nodelistcount = nodelist.getLength();
        for (int i = 1; i < nodelistcount; i += 2) {
            String nodeName = nodelist.item(i).getNodeName();
            String nodeValue = nodelist.item(i).getTextContent();
            if (nodeName.equals("activationCode")) {
                this.setActivationCodeFromFile(nodeValue);
                continue;
            }
            if (!nodeName.equals("licenseCode")) continue;
            this.setVergunningCodeFromFile(nodeValue);
        }
        this.vergunningLoaded = true;
        return this.status;
    }

    public String[] saveVergunning() {
        this.status[0] = "0";
        this.status[1] = "";
        this.xmlFileName = "data/license/" + this.xmlFileBase + this.xmlFileExtention;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: docBuilder = documentBuilderFactory.newDocumentBuilder(): ParserConfigurationException: " + error.getMessage();
            return this.status;
        }
        this.xmlDocument = docBuilder.newDocument();
        Element root = this.xmlDocument.createElement("license");
        this.xmlDocument.appendChild(root);
        Comment comment = this.xmlDocument.createComment("DCM License");
        root.appendChild(comment);
        Element child = this.xmlDocument.createElement("activationCode");
        Text text = this.xmlDocument.createTextNode(this.getActivationCodeFromFile());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("licenseCode");
        text = this.xmlDocument.createTextNode(this.getVergunningCodeFromFile());
        child.appendChild(text);
        root.appendChild(child);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: trans = transfac.newTransformer(): TransformerConfigurationException: " + error.getMessage();
            return this.status;
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(this.xmlDocument);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: trans.transform(source, result): TransformerException: " + error.getMessage();
            return this.status;
        }
        String xmlString = stringWriter.toString();
        FileWriter fileWriter = null;
        File fileToWrite = new File(this.xmlFileName);
        try {
            fileWriter = new FileWriter(fileToWrite);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: fileWriter = new FileWriter(fileToWrite): IOException: " + error.getMessage();
            return this.status;
        }
        try {
            fileWriter.write(xmlString);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: fileWriter.write(xmlString): IOException: " + error.getMessage();
            return this.status;
        }
        try {
            fileWriter.flush();
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: fileWriter.flush(): IOException: " + error.getMessage();
            return this.status;
        }
        return this.status;
    }

    public boolean controleerVergunning() {
        this.status = this.loadVergunning();
        if (this.status[0].equals("0")) {
            this.vergunningLoaded = true;
            String[] activationCodeField = new String[10];
            activationCodeField = this.activationCodeFromFile.split("-");
            this.systemTimeCalendar = Calendar.getInstance();
            this.vergunningStartCalendar = Calendar.getInstance();
            boolean dayGood = true;
            boolean monthGood = true;
            boolean yearGood = true;
            try {
                Integer.parseInt(activationCodeField[1]);
            }
            catch (NumberFormatException ex) {
                dayGood = false;
            }
            try {
                Integer.parseInt(activationCodeField[2]);
            }
            catch (NumberFormatException ex) {
                monthGood = false;
            }
            try {
                Integer.parseInt(activationCodeField[3]);
            }
            catch (NumberFormatException ex) {
                yearGood = false;
            }
            this.vergunningNumOfServers = activationCodeField[0];
            this.serversLicensed = Integer.parseInt(this.vergunningNumOfServers);
            if (dayGood && monthGood && yearGood) {
                this.vergunningStartCalendar.set(Integer.parseInt(activationCodeField[1]), Integer.parseInt(activationCodeField[2]) - 1, Integer.parseInt(activationCodeField[3]));
                this.vergunningStartCalendar.set(11, 0);
                this.vergunningStartCalendar.set(12, 0);
                this.vergunningStartCalendar.set(13, 0);
            }
            this.vergunningEndCalendar = Calendar.getInstance();
            this.vergunningEndCalendar.setTimeInMillis(this.vergunningStartCalendar.getTimeInMillis());
            this.vergunningEndCalendar.set(11, 0);
            this.vergunningEndCalendar.set(12, 0);
            this.vergunningEndCalendar.set(13, 0);
            this.vergunningPeriod = activationCodeField[4];
            if (this.vergunningPeriod.equals("Day")) {
                this.vergunningEndCalendar.add(6, 1);
            } else if (this.vergunningPeriod.equals("Week")) {
                this.vergunningEndCalendar.add(3, 1);
            } else if (this.vergunningPeriod.equals("Month")) {
                this.vergunningEndCalendar.add(2, 1);
            } else if (this.vergunningPeriod.equals("Year")) {
                this.vergunningEndCalendar.add(1, 1);
            } else if (this.vergunningPeriod.equals("Lifetime")) {
                this.vergunningEndCalendar.add(1, 100);
            }
            this.status = this.getAK();
            if (this.status[0].equals("0")) {
                String activationCodeKeyString = null;
                activationCodeKeyString = this.status[1];
                this.activationCodeFromSystem = this.vergunningNumOfServers + "-" + String.format("%04d", this.vergunningStartCalendar.get(1)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(2) + 1) + "-" + String.format("%02d", this.vergunningStartCalendar.get(5)) + "-" + this.vergunningPeriod + "-" + activationCodeKeyString;
                this.vergunningCodeFromSystem = MD5Converter.getMD5SumFromString(this.activationCodeFromSystem + VERGUNNINGTOEKENNERTOEGANG);
                this.vergunningIsValid = true;
                if (this.vergunningCodeFromSystem == null) {
                    this.vergunningIsValid = false;
                    this.vergunningInvalidReason = "LicenseCode Missing";
                    this.vergunningInvalidAdvice = "Please contact JavaSoft";
                } else if (this.vergunningCodeFromSystem.length() == 0) {
                    this.vergunningIsValid = false;
                    this.vergunningInvalidReason = "LicenseCode Missing";
                    this.vergunningInvalidAdvice = "Please contact JavaSoft";
                } else if (!this.vergunningCodeFromSystem.equals(this.vergunningCodeFromFile)) {
                    this.vergunningIsValid = false;
                    this.vergunningInvalidReason = "LicenseCode Invalid";
                    this.vergunningInvalidAdvice = "Please fill in correct LicenseCode";
                } else if (this.systemTimeCalendar.before(this.vergunningStartCalendar)) {
                    this.vergunningIsValid = false;
                    this.vergunningInvalidReason = "License in Future";
                    this.vergunningInvalidAdvice = "Please wait until LicenseStart Date";
                } else if (this.systemTimeCalendar.after(this.vergunningEndCalendar)) {
                    this.vergunningIsValid = false;
                    this.vergunningInvalidReason = "License Expired";
                    this.vergunningInvalidAdvice = "Please renew your LicenseCode";
                }
                if (this.vergunningIsValid) {
                    if (this.debug) {
                        System.out.println();
                        System.out.println("licenseStartCalendar: " + String.format("%04d", this.vergunningStartCalendar.get(1)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(2)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(5)) + " " + String.format("%02d", this.vergunningStartCalendar.get(11)) + ":" + String.format("%02d", this.vergunningStartCalendar.get(12)) + ":" + String.format("%02d", this.vergunningStartCalendar.get(13)));
                        System.out.println("systemTimeCalendar:   " + String.format("%04d", this.systemTimeCalendar.get(1)) + "-" + String.format("%02d", this.systemTimeCalendar.get(2)) + "-" + String.format("%02d", this.systemTimeCalendar.get(5)) + " " + String.format("%02d", this.systemTimeCalendar.get(11)) + ":" + String.format("%02d", this.systemTimeCalendar.get(12)) + ":" + String.format("%02d", this.systemTimeCalendar.get(13)));
                        System.out.println("licenseEndCalendar:   " + String.format("%04d", this.vergunningEndCalendar.get(1)) + "-" + String.format("%02d", this.vergunningEndCalendar.get(2)) + "-" + String.format("%02d", this.vergunningEndCalendar.get(5)) + " " + String.format("%02d", this.vergunningEndCalendar.get(11)) + ":" + String.format("%02d", this.vergunningEndCalendar.get(12)) + ":" + String.format("%02d", this.vergunningEndCalendar.get(13)));
                    }
                } else {
                    this.serversLicensed = 1000000;
                    this.vergunningStartCalendar = Calendar.getInstance();
                    this.vergunningEndCalendar = Calendar.getInstance();
                    this.vergunningEndCalendar.add(1, 20);
                    this.vergunningPeriod = "Lifetime";
                    if (this.debug) {
                        System.out.println();
                        System.out.println(this.vergunningInvalidReason);
                        System.out.println();
                        System.out.println("licenseStartCalendar: " + String.format("%04d", this.vergunningStartCalendar.get(1)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(2)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(5)) + " " + String.format("%02d", this.vergunningStartCalendar.get(11)) + ":" + String.format("%02d", this.vergunningStartCalendar.get(12)) + ":" + String.format("%02d", this.vergunningStartCalendar.get(13)));
                        System.out.println("systemTimeCalendar:   " + String.format("%04d", this.systemTimeCalendar.get(1)) + "-" + String.format("%02d", this.systemTimeCalendar.get(2)) + "-" + String.format("%02d", this.systemTimeCalendar.get(5)) + " " + String.format("%02d", this.systemTimeCalendar.get(11)) + ":" + String.format("%02d", this.systemTimeCalendar.get(12)) + ":" + String.format("%02d", this.systemTimeCalendar.get(13)));
                        System.out.println("licenseEndCalendar:   " + String.format("%04d", this.vergunningEndCalendar.get(1)) + "-" + String.format("%02d", this.vergunningEndCalendar.get(2)) + "-" + String.format("%02d", this.vergunningEndCalendar.get(5)) + " " + String.format("%02d", this.vergunningEndCalendar.get(11)) + ":" + String.format("%02d", this.vergunningEndCalendar.get(12)) + ":" + String.format("%02d", this.vergunningEndCalendar.get(13)));
                    }
                }
            }
        } else {
            this.vergunningLoaded = false;
            this.vergunningIsValid = false;
            this.createVergunning();
        }
        if (this.debug) {
            System.out.println("systemTimeCalendar:   " + String.format("%04d", this.systemTimeCalendar.get(1)) + "-" + String.format("%02d", this.systemTimeCalendar.get(2)) + "-" + String.format("%02d", this.systemTimeCalendar.get(5)) + " " + String.format("%02d", this.systemTimeCalendar.get(11)) + ":" + String.format("%02d", this.systemTimeCalendar.get(12)) + ":" + String.format("%02d", this.systemTimeCalendar.get(13)));
        }
        return this.vergunningIsValid;
    }

    public String[] getAK() {
        try {
            this.status[0] = "0";
            this.status[1] = "";
            this.output = "";
            this.totOutput = "";
            this.networkInterfaceList = NetworkInterface.getNetworkInterfaces();
            this.networkInterfaceList = NetworkInterface.getNetworkInterfaces();
            while (this.networkInterfaceList.hasMoreElements()) {
                this.networkInterface = (NetworkInterface)this.networkInterfaceList.nextElement();
                if (this.networkInterface.isUp() && !this.networkInterface.isLoopback() && !this.networkInterface.isVirtual()) {
                    try {
                        this.myBytes = this.networkInterface.getHardwareAddress();
                    }
                    catch (SocketException ex) {
                        System.out.println("myBytes = netif.getHardwareAddress(): " + ex.getMessage());
                    }
                }
                if (!this.networkInterface.isUp() || this.networkInterface.isLoopback() || this.networkInterface.isVirtual() || this.myBytes == null || this.myBytes.length <= 0) continue;
                byte[] ex = this.myBytes;
                int n = ex.length;
                for (int i = 0; i < n; ++i) {
                    Byte myByte = ex[i];
                    int highNibble = 0;
                    int high2lowNibble = 0;
                    int lowNibble = 0;
                    if (myByte != null && myByte >= 0) {
                        highNibble = myByte & 0xF0;
                        high2lowNibble = highNibble >>> 4;
                        lowNibble = myByte & 0xF;
                    }
                    this.output = this.output + Integer.toHexString(high2lowNibble) + Integer.toHexString(lowNibble);
                }
                this.totOutput = this.totOutput + this.output;
            }
            this.status[1] = this.status[1] + MD5Converter.getMD5SumFromString(this.totOutput);
        }
        catch (SocketException ex) {
            System.out.println("Error: UnknownHostException: Vergunning.getAK()): NetworkInterface.getByInetAddress(inetAddress): " + ex.getMessage());
        }
        return this.status;
    }

    public boolean isValid() {
        return this.vergunningIsValid;
    }

    public String getVergunningInvalidReason() {
        return this.vergunningInvalidReason;
    }

    public String getVergunningInvalidAdvice() {
        return this.vergunningInvalidAdvice;
    }

    public boolean vergunningOrderInProgress() {
        return this.vergunningOrderInProgress;
    }

    public String getActivationCodeFromFile() {
        return this.activationCodeFromFile;
    }

    public String getVergunningCodeFromFile() {
        return this.vergunningCodeFromFile;
    }

    public Calendar getVergunningStartDate() {
        return this.vergunningStartCalendar;
    }

    public Calendar getVergunningEndDate() {
        return this.vergunningEndCalendar;
    }

    public String getVergunningPeriod() {
        return this.vergunningPeriod;
    }

    public int getDefaultServersInLicense() {
        return 1000000;
    }

    public int getServersInLicense() {
        return this.serversLicensed;
    }

    public void setActivationCodeFromFile(String activationCodeFromFileParam) {
        this.activationCodeFromFile = activationCodeFromFileParam;
    }

    public void setVergunningCodeFromFile(String vergunningCodeFromFileParam) {
        this.vergunningCodeFromFile = vergunningCodeFromFileParam;
    }

    public void setVergunningValid(boolean vergunningValidParam) {
        this.vergunningIsValid = vergunningValidParam;
    }

    public void setVergunningOrderInProgress(boolean vergunningOrderInProgressParam) {
        this.vergunningOrderInProgress = vergunningOrderInProgressParam;
    }

    public void setVergunningStartDate(Calendar vergunningStartCalendarParam) {
        this.vergunningStartCalendar = vergunningStartCalendarParam;
    }

    public void setVergunningEndDate(Calendar vergunningEndCalendarParam) {
        this.vergunningEndCalendar = vergunningEndCalendarParam;
    }

    public void setVergunningPeriod(String vergunningPeriodParam) {
        this.vergunningPeriod = vergunningPeriodParam;
    }

    public void setServersInLicense(int serversLicensedParam) {
        this.serversLicensed = serversLicensedParam;
    }

    public void setDefaultServersInLicense() {
        this.serversLicensed = 1000000;
    }

    public String toString() {
        String output = null;
        output = "valid: " + this.isValid() + "\n";
        output = output + "serversLicensed: " + this.getServersInLicense() + "\n";
        output = output + "startDate:       " + DCMTools.getHumanDate(this.getVergunningStartDate()) + "\n";
        output = output + "endDate:         " + DCMTools.getHumanDate(this.getVergunningEndDate()) + "\n";
        output = output + "period:          " + this.getVergunningPeriod() + "\n";
        output = output + "activationCode:  " + this.getActivationCodeFromFile() + "\n";
        output = output + "licenseCode: " + this.getVergunningCodeFromFile() + "\n";
        return output;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

