/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.ConfigurationCaller;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Configuration
implements Cloneable {
    public static final boolean DEBUG = true;
    public static final int FREEYEAR = 2011;
    private static String dataDir;
    private static String databasesDir;
    private static String backupDir;
    private static String javadb;
    private static String archiveDBDir;
    private static String xmlConfigDir;
    private static String xmlFileName;
    private static String xmlFileBase;
    private static String xmlFileExtention;
    private static String domain;
    private static String toegang;
    private static String register;
    private static String[] status;
    public static final String WEBLINK = "http://www.voipstorm.nl/";
    private ConfigurationCaller configurationCaller;
    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = null;
    Document xmlDocument = null;
    private String platform;
    private String fileSeparator;
    private String lineTerminator;
    private String soundsDir;
    private String scriptsDir;
    private String imagesDir;
    private String vergunningDir;
    private String configDir;
    private String logDir;
    private String binDir;
    private File file;

    public Configuration(ConfigurationCaller configurationCallerParam) {
        this.configurationCaller = configurationCallerParam;
        this.platform = System.getProperty("os.name").toLowerCase();
        if (this.platform.indexOf("windows") != -1) {
            this.fileSeparator = "\\";
            this.lineTerminator = "\r\n";
        } else {
            this.fileSeparator = "/";
            this.lineTerminator = "\r\n";
        }
        dataDir = "data" + this.fileSeparator;
        databasesDir = dataDir + "databases" + this.fileSeparator;
        backupDir = dataDir + "backup" + this.fileSeparator;
        javadb = "DCMMetaDB";
        archiveDBDir = databasesDir + "DCMArchiveDB" + this.fileSeparator;
        this.soundsDir = dataDir + "sounds" + this.fileSeparator;
        this.scriptsDir = dataDir + "scripts" + this.fileSeparator;
        this.imagesDir = dataDir + "images" + this.fileSeparator;
        this.vergunningDir = dataDir + "license" + this.fileSeparator;
        this.configDir = dataDir + "config" + this.fileSeparator;
        this.binDir = dataDir + "bin" + this.fileSeparator;
        this.logDir = dataDir + "log" + this.fileSeparator;
        boolean missingDirsDetected = false;
        boolean missingCriticalDirsDetected = false;
        this.file = new File(dataDir);
        if (!this.file.exists() && new File(dataDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + dataDir, false, true, false);
        }
        this.file = new File(this.logDir);
        if (!this.file.exists() && new File(this.logDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + this.logDir, false, true, false);
        }
        this.file = new File(this.soundsDir);
        if (!this.file.exists() && new File(this.soundsDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + this.soundsDir, false, true, false);
            missingCriticalDirsDetected = true;
        }
        this.file = new File(this.scriptsDir);
        if (!this.file.exists() && new File(this.scriptsDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + this.scriptsDir, false, true, false);
            missingCriticalDirsDetected = true;
        }
        this.file = new File(this.imagesDir);
        if (!this.file.exists() && new File(this.imagesDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + this.imagesDir, false, true, false);
            missingCriticalDirsDetected = true;
        }
        this.file = new File(this.vergunningDir);
        if (!this.file.exists() && new File(this.vergunningDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + this.vergunningDir, false, true, false);
        }
        this.file = new File(databasesDir);
        if (!this.file.exists() && new File(databasesDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + databasesDir, false, true, false);
        }
        this.file = new File(backupDir);
        if (!this.file.exists() && new File(backupDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + backupDir, false, true, false);
        }
        this.file = new File(archiveDBDir);
        if (!this.file.exists() && new File(archiveDBDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + archiveDBDir, false, true, false);
        }
        this.file = new File(this.configDir);
        if (!this.file.exists() && new File(this.configDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + this.configDir, false, true, false);
        }
        this.file = new File(this.binDir);
        if (!this.file.exists() && new File(this.binDir).mkdir()) {
            missingDirsDetected = true;
            configurationCallerParam.log("Action:  Config: Creating missing directory: " + this.binDir, false, true, false);
            missingCriticalDirsDetected = true;
        }
        if (missingCriticalDirsDetected) {
            configurationCallerParam.log("Status:  Config: Critical directories were missing !", false, true, false);
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (missingDirsDetected) {
            configurationCallerParam.log("Success: Config: DCM directory structure built", false, true, false);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        xmlFileName = "";
        xmlFileBase = "network";
        xmlFileExtention = ".xml";
        domain = "voipstorm.nl";
        register = "0";
        status = new String[2];
    }

    public Configuration(ConfigurationCaller configurationCallerParam, String domainParam, String registerParam) {
        this(configurationCallerParam);
        domain = domainParam;
        register = registerParam;
    }

    public Configuration() {
        this.platform = System.getProperty("os.name").toLowerCase();
        if (this.platform.indexOf("windows") != -1) {
            this.fileSeparator = "\\";
            this.lineTerminator = "\r\n";
        } else {
            this.fileSeparator = "/";
            this.lineTerminator = "\r\n";
        }
        dataDir = "data" + this.fileSeparator;
        databasesDir = dataDir + "databases" + this.fileSeparator;
        backupDir = dataDir + "backup" + this.fileSeparator;
        javadb = "DCMMetaDB";
        archiveDBDir = databasesDir + "DCMArchiveDB" + this.fileSeparator;
        this.soundsDir = dataDir + "sounds" + this.fileSeparator;
        this.scriptsDir = dataDir + "scripts" + this.fileSeparator;
        this.imagesDir = dataDir + "images" + this.fileSeparator;
        this.vergunningDir = dataDir + "license" + this.fileSeparator;
        this.configDir = dataDir + "config" + this.fileSeparator;
        this.binDir = dataDir + "bin" + this.fileSeparator;
        this.logDir = dataDir + "log" + this.fileSeparator;
        boolean missingDirsDetected = false;
        boolean missingCriticalDirsDetected = false;
        this.file = new File(dataDir);
        if (!this.file.exists() && new File(dataDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + dataDir);
        }
        this.file = new File(this.logDir);
        if (!this.file.exists() && new File(this.logDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + this.logDir);
        }
        this.file = new File(this.soundsDir);
        if (!this.file.exists() && new File(this.soundsDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + this.soundsDir);
            missingCriticalDirsDetected = true;
        }
        this.file = new File(this.scriptsDir);
        if (!this.file.exists() && new File(this.scriptsDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + this.scriptsDir);
            missingCriticalDirsDetected = true;
        }
        this.file = new File(this.imagesDir);
        if (!this.file.exists() && new File(this.imagesDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + this.imagesDir);
            missingCriticalDirsDetected = true;
        }
        this.file = new File(this.vergunningDir);
        if (!this.file.exists() && new File(this.vergunningDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + this.vergunningDir);
        }
        this.file = new File(databasesDir);
        if (!this.file.exists() && new File(databasesDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + databasesDir);
        }
        this.file = new File(backupDir);
        if (!this.file.exists() && new File(backupDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + backupDir);
        }
        this.file = new File(archiveDBDir);
        if (!this.file.exists() && new File(archiveDBDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + archiveDBDir);
        }
        this.file = new File(this.configDir);
        if (!this.file.exists() && new File(this.configDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + this.configDir);
        }
        this.file = new File(this.binDir);
        if (!this.file.exists() && new File(this.binDir).mkdir()) {
            missingDirsDetected = true;
            this.log("Action:  Config: Creating missing directory: " + this.binDir);
            missingCriticalDirsDetected = true;
        }
        if (missingCriticalDirsDetected) {
            this.log("Critical directories were missing !");
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (missingDirsDetected) {
            this.log("DCM directory structure built");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        xmlFileName = "";
        xmlFileBase = "network";
        xmlFileExtention = ".xml";
        domain = "voipstorm.nl";
        register = "0";
        status = new String[2];
    }

    public String[] createConfiguration() {
        Configuration.status[0] = "0";
        Configuration.status[1] = "";
        this.setDomain("");
        this.setRegister("0");
        return status;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String[] loadConfiguration(String configNumberParam) {
        Configuration.status[0] = "0";
        Configuration.status[1] = "";
        xmlFileName = configNumberParam != null && !configNumberParam.equals("") ? xmlConfigDir + xmlFileBase + configNumberParam + xmlFileExtention : xmlConfigDir + xmlFileBase + "1" + xmlFileExtention;
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builder = null;
        this.xmlDocument = null;
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "loadConfiguration Error: builder = builderFactory.newDocumentBuilder(): ParserConfigurationException: " + error.getMessage();
            return status;
        }
        try {
            this.xmlDocument = this.builder.parse(xmlFileName);
        }
        catch (SAXException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "loadConfiguration Error: xmlDocument = builder.parse(xmlFile): SAXException: " + error.getMessage();
            return status;
        }
        catch (IOException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "loadConfiguration Error: xmlDocument = builder.parse(xmlFile): IOException: " + error.getMessage();
            return status;
        }
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "loadConfiguration Error: trans = transfac.newTransformer(): TransformerConfigurationException: " + error.getMessage();
            return status;
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(this.xmlDocument);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "loadConfiguration Error: trans.transform(source, result): TransformerException: " + error.getMessage();
            return status;
        }
        String xmlString = stringWriter.toString();
        Node node = this.xmlDocument.getFirstChild();
        NodeList nodelist = node.getChildNodes();
        int nodelistcount = nodelist.getLength();
        for (int i = 1; i < nodelistcount; i += 2) {
            String nodeName = nodelist.item(i).getNodeName();
            String nodeValue = nodelist.item(i).getTextContent();
            if (nodeName.equals("domain")) {
                this.setDomain(nodeValue);
                continue;
            }
            if (!nodeName.equals("register")) continue;
            this.setRegister(nodeValue);
        }
        return status;
    }

    public String[] saveConfiguration(String configNumberParam) {
        Configuration.status[0] = "0";
        Configuration.status[1] = "";
        xmlFileName = configNumberParam != null && !configNumberParam.equals("") ? xmlConfigDir + xmlFileBase + configNumberParam + xmlFileExtention : xmlConfigDir + xmlFileBase + "1" + xmlFileExtention;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "saveConfiguration Error: docBuilder = documentBuilderFactory.newDocumentBuilder(): ParserConfigurationException: " + error.getMessage();
            return status;
        }
        this.xmlDocument = docBuilder.newDocument();
        Element root = this.xmlDocument.createElement("softphoneconfiguration");
        this.xmlDocument.appendChild(root);
        Comment comment = this.xmlDocument.createComment("SoftPhone Configuration");
        root.appendChild(comment);
        Element child = this.xmlDocument.createElement("domain");
        Text text = this.xmlDocument.createTextNode(this.getDomain());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("register");
        text = this.xmlDocument.createTextNode(this.getRegister());
        child.appendChild(text);
        root.appendChild(child);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "saveConfiguration Error: trans = transfac.newTransformer(): TransformerConfigurationException: " + error.getMessage();
            return status;
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(this.xmlDocument);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "saveConfiguration Error: trans.transform(source, result): TransformerException: " + error.getMessage();
            return status;
        }
        String xmlString = stringWriter.toString();
        FileWriter fileWriter = null;
        File fileToWrite = new File(xmlFileName);
        try {
            fileWriter = new FileWriter(fileToWrite);
        }
        catch (IOException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "saveConfiguration Error: fileWriter = new FileWriter(fileToWrite): IOException: " + error.getMessage();
            return status;
        }
        try {
            fileWriter.write(xmlString);
        }
        catch (IOException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "saveConfiguration Error: fileWriter.write(xmlString): IOException: " + error.getMessage();
            return status;
        }
        try {
            fileWriter.flush();
        }
        catch (IOException error) {
            Configuration.status[0] = "1";
            Configuration.status[1] = "saveConfiguration Error: fileWriter.flush(): IOException: " + error.getMessage();
            return status;
        }
        return status;
    }

    public String getDomain() {
        return domain;
    }

    public String getRegister() {
        return register;
    }

    public String getDataDir() {
        return dataDir;
    }

    public String getSoundsDir() {
        return this.soundsDir;
    }

    public String getScriptsDir() {
        return this.scriptsDir;
    }

    public String getImagesDir() {
        return this.imagesDir;
    }

    public String getDatabasesDir() {
        return databasesDir;
    }

    public String getBackupDir() {
        return backupDir;
    }

    public String getArchiveDBDir() {
        return archiveDBDir;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public String getJavaDB() {
        return javadb;
    }

    public void setDomain(String domainParam) {
        domain = domainParam;
    }

    public void setRegister(String registerParam) {
        register = registerParam;
    }

    public String toString() {
        String output = null;
        output = "domain: " + this.getDomain() + "\n";
        output = output + "register: " + this.getRegister() + "\n";
        return output;
    }

    public void log(String messageParam) {
        System.out.println(messageParam);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        xmlConfigDir = dataDir + "config/";
    }
}

