/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.daemon.authentication.SshAuthenticationServerFactory;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthBanner;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.AsyncService;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationProtocolServer
extends AsyncService {
    private static Log log = LogFactory.getLog((Class)AuthenticationProtocolServer.class);
    private List completedAuthentications = new ArrayList();
    private Map acceptServices = new HashMap();
    private List availableAuths;
    private String serviceToStart;
    private int[] messageFilter = new int[1];
    private SshMessageStore methodMessages = new SshMessageStore();
    private int attempts = 0;
    private boolean completed = false;

    public AuthenticationProtocolServer() {
        super("ssh-userauth");
        this.messageFilter[0] = 50;
    }

    protected void onServiceAccept() throws IOException {
    }

    protected void onServiceInit(int n) throws IOException {
        this.messageStore.registerMessage(50, SshMsgUserAuthRequest.class);
        this.transport.addMessageStore(this.methodMessages);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public TransportProtocolState getConnectionState() {
        return this.transport.getState();
    }

    public void sendMessage(SshMessage sshMessage) throws IOException {
        this.transport.sendMessage(sshMessage, (Object)this);
    }

    public SshMessage readMessage() throws IOException {
        try {
            return this.methodMessages.nextMessage();
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted");
        }
    }

    public void registerMessage(int n, Class clazz) {
        this.methodMessages.registerMessage(n, clazz);
    }

    protected void onServiceRequest() throws IOException {
        ServerConfiguration serverConfiguration = (ServerConfiguration)ConfigurationLoader.getConfiguration((Class)ServerConfiguration.class);
        if (serverConfiguration == null) {
            throw new AuthenticationProtocolException("Server configuration unavailable");
        }
        this.availableAuths = new ArrayList();
        Iterator iterator = SshAuthenticationServerFactory.getSupportedMethods().iterator();
        List list = serverConfiguration.getAllowedAuthentications();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!list.contains(string)) continue;
            this.availableAuths.add(string);
        }
        if (this.availableAuths.size() <= 0) {
            throw new AuthenticationProtocolException("No valid authentication methods have been specified");
        }
        this.sendServiceAccept();
        String string = serverConfiguration.getAuthenticationBanner();
        if (string != null && string.length() > 0) {
            InputStream inputStream = ConfigurationLoader.loadFile((String)string);
            if (inputStream != null) {
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                inputStream.close();
                SshMsgUserAuthBanner sshMsgUserAuthBanner = new SshMsgUserAuthBanner(new String(byArray));
                this.transport.sendMessage((SshMessage)sshMsgUserAuthBanner, (Object)this);
            } else {
                log.info((Object)("The banner file '" + string + "' was not found"));
            }
        }
    }

    protected void onMessageReceived(SshMessage sshMessage) throws IOException {
        switch (sshMessage.getMessageId()) {
            case 50: {
                this.onMsgUserAuthRequest((SshMsgUserAuthRequest)sshMessage);
                break;
            }
            default: {
                throw new AuthenticationProtocolException("Unregistered message received!");
            }
        }
    }

    protected int[] getAsyncMessageFilter() {
        return this.messageFilter;
    }

    public void acceptService(Service service) {
        this.acceptServices.put(service.getServiceName(), service);
    }

    private void sendUserAuthFailure(boolean bl) throws IOException {
        Iterator iterator = this.availableAuths.iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (string == null ? "" : string + ",") + (String)iterator.next();
        }
        SshMsgUserAuthFailure sshMsgUserAuthFailure = new SshMsgUserAuthFailure(string, bl);
        this.transport.sendMessage((SshMessage)sshMsgUserAuthFailure, (Object)this);
    }

    protected void onStop() {
        block4: {
            try {
                if (!this.completed) break block4;
                try {
                    this.transport.getState().waitForState(5);
                }
                catch (InterruptedException interruptedException) {
                    log.warn((Object)"The authentication service was interrupted");
                }
                NativeAuthenticationProvider nativeAuthenticationProvider = NativeAuthenticationProvider.getInstance();
                nativeAuthenticationProvider.logoffUser();
            }
            catch (IOException iOException) {
                log.warn((Object)("Failed to logoff " + SshThread.getCurrentThreadUser()));
            }
        }
    }

    private void sendUserAuthSuccess() throws IOException {
        SshMsgUserAuthSuccess sshMsgUserAuthSuccess = new SshMsgUserAuthSuccess();
        Service service = (Service)this.acceptServices.get(this.serviceToStart);
        service.init(2, this.transport);
        service.start();
        this.transport.sendMessage((SshMessage)sshMsgUserAuthSuccess, (Object)this);
        this.completed = true;
        this.stop();
    }

    private void onMsgUserAuthRequest(SshMsgUserAuthRequest sshMsgUserAuthRequest) throws IOException {
        if (sshMsgUserAuthRequest.getMethodName().equals("none")) {
            this.sendUserAuthFailure(false);
        } else if (this.attempts >= ((ServerConfiguration)ConfigurationLoader.getConfiguration((Class)ServerConfiguration.class)).getMaxAuthentications()) {
            this.transport.disconnect("Too many failed authentication attempts");
        } else {
            if (this.acceptServices.containsKey(sshMsgUserAuthRequest.getServiceName())) {
                String string = sshMsgUserAuthRequest.getMethodName();
                if (this.availableAuths.contains(string)) {
                    SshAuthenticationServer sshAuthenticationServer = SshAuthenticationServerFactory.newInstance(string);
                    this.serviceToStart = sshMsgUserAuthRequest.getServiceName();
                    int n = sshAuthenticationServer.authenticate(this, sshMsgUserAuthRequest);
                    if (n == 2) {
                        this.sendUserAuthFailure(false);
                    } else if (n == 4) {
                        this.completedAuthentications.add(sshAuthenticationServer.getMethodName());
                        ServerConfiguration serverConfiguration = (ServerConfiguration)ConfigurationLoader.getConfiguration((Class)ServerConfiguration.class);
                        Iterator iterator = serverConfiguration.getRequiredAuthentications().iterator();
                        while (iterator.hasNext()) {
                            if (this.completedAuthentications.contains(iterator.next())) continue;
                            this.sendUserAuthFailure(true);
                            return;
                        }
                        this.thread.setUsername(sshMsgUserAuthRequest.getUsername());
                        this.sendUserAuthSuccess();
                    }
                } else {
                    this.sendUserAuthFailure(false);
                }
            } else {
                this.sendUserAuthFailure(false);
            }
            ++this.attempts;
        }
    }
}

