/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.BufferOverflowException;
import com.sshtools.daemon.terminal.CharBuffer;
import com.sshtools.daemon.terminal.TerminalIO;
import java.io.IOException;

public class Editline {
    private Buffer buf;
    private TerminalIO myIO;
    private int Cursor = 0;
    private boolean InsertMode = true;
    private int lastSize = 0;
    private boolean hardwrapped = false;
    private char lastread;
    private int lastcurspos = 0;
    private boolean maskInput = false;
    private char mask = (char)42;

    public Editline(TerminalIO terminalIO) {
        this.myIO = terminalIO;
        this.buf = new Buffer(this.myIO.getColumns() - 1);
        this.Cursor = 0;
        this.InsertMode = true;
    }

    public int size() {
        return this.buf.size();
    }

    public String getValue() {
        return this.buf.toString();
    }

    public void setValue(String string) throws BufferOverflowException, IOException {
        this.storeSize();
        this.buf.clear();
        this.Cursor = 0;
        this.myIO.moveLeft(this.lastSize);
        this.myIO.eraseToEndOfLine();
        this.append(string);
    }

    public void maskInput(boolean bl) {
        this.maskInput = bl;
    }

    public void setMask(char c) {
        this.mask = c;
    }

    public void clear() throws IOException {
        this.storeSize();
        this.buf.clear();
        this.Cursor = 0;
        this.draw();
    }

    public String getSoftwrap() throws IndexOutOfBoundsException, IOException {
        String string = this.buf.toString();
        int n = string.lastIndexOf(" ");
        if (n == -1) {
            string = "";
        } else {
            string = string.substring(n + 1, string.length());
            this.Cursor = this.size();
            this.Cursor -= string.length();
            for (int i = 0; i < string.length(); ++i) {
                this.buf.removeCharAt(this.Cursor);
            }
            this.myIO.moveLeft(string.length());
            this.myIO.eraseToEndOfLine();
        }
        return string + this.getLastRead();
    }

    public String getHardwrap() throws IndexOutOfBoundsException, IOException {
        String string = this.buf.toString();
        string = string.substring(this.Cursor, string.length());
        int n = this.buf.size();
        for (int i = this.Cursor; i < n; ++i) {
            this.buf.removeCharAt(this.Cursor);
        }
        this.myIO.eraseToEndOfLine();
        return string;
    }

    private void setCharAt(int n, char c) throws IndexOutOfBoundsException, IOException {
        this.buf.setCharAt(n, c);
        this.draw();
    }

    private void insertCharAt(int n, char c) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.buf.ensureSpace(1);
        this.buf.insertCharAt(n, c);
        if (this.Cursor >= n) {
            ++this.Cursor;
        }
        this.draw();
    }

    private void removeCharAt(int n) throws IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.buf.removeCharAt(n);
        if (this.Cursor > n) {
            --this.Cursor;
        }
        this.draw();
    }

    private void insertStringAt(int n, String string) throws BufferOverflowException, IndexOutOfBoundsException, IOException {
        this.storeSize();
        this.buf.ensureSpace(string.length());
        for (int i = 0; i < string.length(); ++i) {
            this.buf.insertCharAt(n, string.charAt(i));
            ++this.Cursor;
        }
        this.draw();
    }

    public void append(char c) throws BufferOverflowException, IOException {
        this.storeSize();
        this.buf.ensureSpace(1);
        this.buf.append(c);
        ++this.Cursor;
        if (!this.maskInput) {
            this.myIO.write(c);
        } else {
            this.myIO.write(this.mask);
        }
    }

    public void append(String string) throws BufferOverflowException, IOException {
        int n;
        this.storeSize();
        this.buf.ensureSpace(string.length());
        for (n = 0; n < string.length(); ++n) {
            this.buf.append(string.charAt(n));
            ++this.Cursor;
        }
        if (!this.maskInput) {
            this.myIO.write(string);
        } else {
            for (n = 0; n < string.length(); ++n) {
                this.myIO.write(this.mask);
            }
        }
    }

    public int getCursorPosition() {
        return this.Cursor;
    }

    public void setCursorPosition(int n) {
        this.Cursor = this.buf.size() < n ? this.buf.size() : n;
    }

    private char getLastRead() {
        return this.lastread;
    }

    private void setLastRead(char c) {
        this.lastread = c;
    }

    public boolean isInInsertMode() {
        return this.InsertMode;
    }

    public void setInsertMode(boolean bl) {
        this.InsertMode = bl;
    }

    public boolean isHardwrapped() {
        return this.hardwrapped;
    }

    public void setHardwrapped(boolean bl) {
        this.hardwrapped = bl;
    }

    public int run() {
        try {
            int n = 0;
            while (true) {
                n = this.myIO.read();
                this.lastcurspos = this.Cursor;
                switch (n) {
                    case 1004: {
                        if (this.moveLeft()) break;
                        return n;
                    }
                    case 1003: {
                        if (this.moveRight()) break;
                        return n;
                    }
                    case 1303: {
                        try {
                            if (this.Cursor == 0) {
                                return n;
                            }
                            this.removeCharAt(this.Cursor - 1);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            this.myIO.bell();
                        }
                        break;
                    }
                    case 1302: {
                        try {
                            this.removeCharAt(this.Cursor);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            this.myIO.bell();
                        }
                        break;
                    }
                    case 10: 
                    case 1001: 
                    case 1002: 
                    case 1301: {
                        return n;
                    }
                    default: {
                        try {
                            this.handleCharInput(n);
                            break;
                        }
                        catch (BufferOverflowException bufferOverflowException) {
                            this.setLastRead((char)n);
                            return n;
                        }
                    }
                }
                this.myIO.flush();
            }
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public void draw() throws IOException {
        this.myIO.moveLeft(this.lastcurspos);
        this.myIO.eraseToEndOfLine();
        if (!this.maskInput) {
            this.myIO.write(this.buf.toString());
        } else {
            for (int i = 0; i < this.buf.size(); ++i) {
                this.myIO.write(this.mask);
            }
        }
        if (this.Cursor < this.buf.size()) {
            this.myIO.moveLeft(this.buf.size() - this.Cursor);
        }
    }

    private boolean moveRight() throws IOException {
        if (this.Cursor < this.buf.size()) {
            ++this.Cursor;
            this.myIO.moveRight(1);
            return true;
        }
        return false;
    }

    private boolean moveLeft() throws IOException {
        if (this.Cursor > 0) {
            --this.Cursor;
            this.myIO.moveLeft(1);
            return true;
        }
        return false;
    }

    private boolean isCursorAtEnd() {
        return this.Cursor == this.buf.size();
    }

    private void handleCharInput(int n) throws BufferOverflowException, IOException {
        if (this.isCursorAtEnd()) {
            this.append((char)n);
        } else if (this.isInInsertMode()) {
            try {
                this.insertCharAt(this.Cursor, (char)n);
            }
            catch (BufferOverflowException bufferOverflowException) {
                this.myIO.bell();
            }
        } else {
            this.setCharAt(this.Cursor, (char)n);
        }
    }

    private void storeSize() {
        this.lastSize = this.buf.size();
    }

    class Buffer
    extends CharBuffer {
        public Buffer(int n) {
            super(n);
        }
    }
}

